/*
 * Decompiled with CFR 0.152.
 */
package frost.storage;

import frost.boards.Board;
import frost.fcp.FreenetKeys;
import frost.messages.AttachmentList;
import frost.messages.BoardAttachment;
import frost.util.XMLTools;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class KnownBoardsXmlDAO {
    private static final Logger logger = Logger.getLogger(KnownBoardsXmlDAO.class.getName());

    public static List<Board> loadKnownBoards(File file) {
        File boards = file;
        ArrayList<Board> knownBoards = new ArrayList<Board>();
        if (boards.exists()) {
            Document doc = null;
            try {
                doc = XMLTools.parseXmlFile(boards, false);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Error reading knownboards.xml", ex);
                return knownBoards;
            }
            Element rootNode = doc.getDocumentElement();
            if (!rootNode.getTagName().equals("FrostKnownBoards")) {
                logger.severe("Error - invalid knownboards.xml: does not contain the root tag 'FrostKnownBoards'");
                return knownBoards;
            }
            AttachmentList al = new AttachmentList();
            try {
                al.loadXMLElement(rootNode);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Error - knownboards.xml: contains unexpected content.", ex);
                return knownBoards;
            }
            AttachmentList lst = al.getAllOfType(1);
            for (BoardAttachment ba : lst) {
                Board b = ba.getBoardObj();
                if (KnownBoardsXmlDAO.isBoardKeyValidForFreenetVersion(b)) {
                    knownBoards.add(b);
                    continue;
                }
                logger.warning("Known board keys are invalid for this freenet version, board ignored: " + b.getName());
            }
            logger.info("Loaded " + knownBoards.size() + " known boards.");
        }
        return knownBoards;
    }

    private static boolean isBoardKeyValidForFreenetVersion(Board b) {
        String key = b.getPublicKey();
        if (key != null && key.length() > 0 && !FreenetKeys.isValidKey(key)) {
            return false;
        }
        key = b.getPrivateKey();
        return key == null || key.length() <= 0 || FreenetKeys.isValidKey(key);
    }

    public static boolean saveKnownBoards(File file, List<Board> knownBoards) {
        Document doc = XMLTools.createDomDocument();
        if (doc == null) {
            logger.severe("Error - saveBoardTree: factory couldn't create XML Document.");
            return false;
        }
        Element rootElement = doc.createElement("FrostKnownBoards");
        doc.appendChild(rootElement);
        for (Board b : knownBoards) {
            BoardAttachment current = new BoardAttachment(b);
            Element anAttachment = current.getXMLElement(doc);
            rootElement.appendChild(anAttachment);
        }
        boolean writeOK = false;
        try {
            writeOK = XMLTools.writeXmlFile(doc, file.getPath());
        }
        catch (Throwable ex) {
            logger.log(Level.SEVERE, "Exception while writing knownboards.xml:", ex);
        }
        if (!writeOK) {
            logger.severe("Error exporting knownboards, file was not saved");
        }
        return writeOK;
    }
}

