/*
 * Decompiled with CFR 0.152.
 */
package frost.storage.perst;

import frost.Core;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilterOutputStream;
import java.text.NumberFormat;
import java.util.logging.Logger;
import org.garret.perst.Storage;
import org.garret.perst.StorageFactory;

public abstract class AbstractFrostStorage {
    private static final Logger logger = Logger.getLogger(AbstractFrostStorage.class.getName());
    private Storage storage = null;

    protected AbstractFrostStorage() {
    }

    public abstract String getStorageFilename();

    public abstract boolean initStorage();

    protected void open(String databaseFilePath, int pagePoolSize, boolean utf8Encoding, boolean concurrentIterator, boolean serializeTransientObjects) {
        if (this.storage != null) {
            System.out.println("Storage is already opened!");
            return;
        }
        this.storage = StorageFactory.getInstance().createStorage();
        if (utf8Encoding) {
            this.storage.setProperty("perst.string.encoding", "UTF-8");
        }
        if (concurrentIterator) {
            this.storage.setProperty("perst.concurrent.iterator", Boolean.TRUE);
        }
        if (serializeTransientObjects) {
            this.storage.setProperty("perst.serialize.transient.objects", Boolean.TRUE);
        }
        this.storage.open(databaseFilePath, pagePoolSize);
    }

    public void exportToXml() throws Exception {
        File xmlFile = new File(this.buildStoragePath(this.getStorageFilename() + ".xml"));
        logger.warning("Exporting storage file '" + this.getStorageFilename() + "' to XML...");
        this.initStorage();
        FileWriter writer = null;
        try {
            writer = new FileWriter(xmlFile);
            this.getStorage().exportXML(writer);
            writer.close();
        }
        catch (Exception t) {
            if (writer != null) {
                try {
                    writer.close();
                }
                catch (Exception t2) {
                    // empty catch block
                }
            }
            xmlFile.delete();
            throw t;
        }
        this.close();
        logger.warning("Finished XML export of storage file " + this.getStorageFilename() + " into " + xmlFile.getPath());
    }

    public long compactStorage() throws Exception {
        File storageFile = new File(this.buildStoragePath(this.getStorageFilename()));
        File bakFile = new File(this.buildStoragePath(this.getStorageFilename() + ".bak"));
        File oldFile = new File(this.buildStoragePath(this.getStorageFilename() + ".old"));
        logger.warning("Compacting storage file '" + this.getStorageFilename() + "'...");
        long beforeStorageSize = storageFile.length();
        this.initStorage();
        FilterOutputStream bakStream = null;
        try {
            bakStream = new BufferedOutputStream(new FileOutputStream(bakFile));
            this.getStorage().backup(bakStream);
            bakStream.close();
        }
        catch (Exception t) {
            if (bakStream != null) {
                try {
                    bakStream.close();
                }
                catch (Exception t2) {
                    // empty catch block
                }
            }
            bakFile.delete();
            throw t;
        }
        this.close();
        if (!storageFile.renameTo(oldFile)) {
            throw new Exception("Failed to rename '" + storageFile.getPath() + "' into '" + oldFile.getPath() + "'!");
        }
        if (!bakFile.renameTo(storageFile)) {
            if (!oldFile.renameTo(storageFile)) {
                throw new Exception("URGENT: Failed to rename '" + oldFile.getPath() + "' back into '" + storageFile.getPath() + "'!");
            }
            throw new Exception("Failed to rename '" + bakFile.getPath() + "' into '" + storageFile.getPath() + "'!");
        }
        long afterStorageSize = storageFile.length();
        oldFile.delete();
        long savedBytes = beforeStorageSize - afterStorageSize;
        NumberFormat nf = NumberFormat.getInstance();
        logger.warning("Finished compacting storage file " + this.getStorageFilename() + ", released " + nf.format(savedBytes) + " bytes.");
        return savedBytes;
    }

    protected Storage getStorage() {
        return this.storage;
    }

    public boolean beginCooperativeThreadTransaction() {
        if (this.getStorage() != null) {
            this.getStorage().beginThreadTransaction(1);
            return true;
        }
        return false;
    }

    public boolean beginExclusiveThreadTransaction() {
        if (this.getStorage() != null) {
            this.getStorage().beginThreadTransaction(0);
            return true;
        }
        return false;
    }

    public boolean endThreadTransaction() {
        if (this.getStorage() != null) {
            this.getStorage().endThreadTransaction();
            return true;
        }
        return false;
    }

    public boolean rollbackTransaction() {
        if (this.getStorage() != null) {
            this.getStorage().rollbackThreadTransaction();
            return true;
        }
        return false;
    }

    public int gc() {
        if (this.storage == null) {
            return 0;
        }
        return this.storage.gc();
    }

    public synchronized void commit() {
        if (this.storage != null) {
            this.storage.commit();
        }
    }

    public void close() {
        if (this.storage != null) {
            this.beginExclusiveThreadTransaction();
            this.storage.close();
            this.storage = null;
        } else {
            System.out.println("Storage is already closed!");
        }
    }

    protected int getPagePoolSize(String configKey) {
        int pagePoolSize = Core.frostSettings.getIntValue(configKey);
        if (pagePoolSize <= 0) {
            pagePoolSize = 1024;
        }
        return pagePoolSize *= 1024;
    }

    protected String buildStoragePath(String filename) {
        String storeDir = Core.frostSettings.getValue("store.dir");
        return storeDir + filename;
    }
}

