/*
 * Decompiled with CFR 0.152.
 */
package frost.storage.perst;

import java.util.BitSet;
import org.garret.perst.Persistent;

public class IndexSlot
extends Persistent {
    private int indexName;
    private long msgDate;
    private BitSet wasDownloaded;
    private BitSet wasUploaded;

    public IndexSlot() {
    }

    public IndexSlot(int newIndexName, long newMsgDate) {
        this.indexName = newIndexName;
        this.msgDate = newMsgDate;
        this.wasDownloaded = new BitSet();
        this.wasUploaded = new BitSet();
    }

    public int getIndexName() {
        return this.indexName;
    }

    public long getMsgDate() {
        return this.msgDate;
    }

    public void setDownloadSlotUsed(int index) {
        this.wasDownloaded.set(index);
    }

    public void setUploadSlotUsed(int index) {
        this.wasUploaded.set(index);
    }

    public int findFirstDownloadSlot() {
        return this.wasDownloaded.nextClearBit(0);
    }

    public int findNextDownloadSlot(int beforeIndex) {
        return this.wasDownloaded.nextClearBit(beforeIndex + 1);
    }

    public boolean isDownloadIndexBehindLastSetIndex(int index) {
        int indexBehindLastIndex = Math.max(this.wasDownloaded.length(), this.wasUploaded.length());
        return index >= indexBehindLastIndex;
    }

    public int findFirstUploadSlot() {
        int index = Math.max(this.wasDownloaded.length(), this.wasUploaded.length());
        return index;
    }

    public int findNextUploadSlot(int beforeIndex) {
        int index = Math.max(this.wasDownloaded.length(), this.wasUploaded.length());
        if (index > beforeIndex) {
            return index;
        }
        return beforeIndex + 1;
    }
}

