/*
 * Decompiled with CFR 0.152.
 */
package frost.storage.perst;

import frost.fileTransfer.FrostFileListFileObject;
import frost.fileTransfer.download.FrostDownloadItem;
import frost.storage.perst.filelist.FileListStorage;
import java.util.logging.Logger;
import org.garret.perst.Persistent;

public class PerstFrostDownloadItem
extends Persistent {
    public String fileName;
    public String targetPath;
    public long fileSize;
    public String key;
    public boolean enabled;
    public int state;
    public long downloadAddedTime;
    public long downloadStartedTime;
    public long downloadFinishedTime;
    public int retries;
    public long lastDownloadStopTime;
    public String gqIdentifier;
    public String fileListFileSha;
    public boolean isLoggedToFile;
    public int runtimeSecondsWithoutProgress;
    public int oldDoneBlocks;

    public PerstFrostDownloadItem() {
    }

    public PerstFrostDownloadItem(FrostDownloadItem dlItem) {
        this.fileName = dlItem.getFilename();
        this.targetPath = dlItem.getTargetPath();
        this.fileSize = dlItem.getFileSize();
        this.key = dlItem.getKey();
        this.enabled = dlItem.isEnabled() == null ? true : dlItem.isEnabled();
        this.state = dlItem.getState();
        this.downloadAddedTime = dlItem.getDownloadAddedMillis();
        this.downloadStartedTime = dlItem.getDownloadStartedMillis();
        this.downloadFinishedTime = dlItem.getDownloadFinishedMillis();
        this.retries = dlItem.getRetries();
        this.lastDownloadStopTime = dlItem.getLastDownloadStopTime();
        this.gqIdentifier = dlItem.getGqIdentifier();
        this.fileListFileSha = dlItem.getFileListFileObject() == null ? null : dlItem.getFileListFileObject().getSha();
        this.isLoggedToFile = dlItem.isLoggedToFile();
        this.runtimeSecondsWithoutProgress = dlItem.getRuntimeSecondsWithoutProgress();
        this.oldDoneBlocks = dlItem.getOldDoneBlocks();
    }

    public FrostDownloadItem toFrostDownloadItem(Logger logger) {
        FrostFileListFileObject sharedFileObject = null;
        if (this.fileListFileSha != null && this.fileListFileSha.length() > 0 && (sharedFileObject = FileListStorage.inst().getFileBySha(this.fileListFileSha)) == null && this.key == null) {
            logger.warning("Download items file list file object does not exist, and there is no key. Removed from download files: " + this.fileName);
            return null;
        }
        FrostDownloadItem dlItem = new FrostDownloadItem(this.fileName, this.targetPath, this.fileSize <= 0L ? -1L : this.fileSize, this.key, this.enabled, this.state, this.downloadAddedTime, this.downloadStartedTime, this.downloadFinishedTime, this.retries, this.lastDownloadStopTime, this.gqIdentifier, this.isLoggedToFile, this.runtimeSecondsWithoutProgress, this.oldDoneBlocks);
        dlItem.setFileListFileObject(sharedFileObject);
        return dlItem;
    }
}

