/*
 * Decompiled with CFR 0.152.
 */
package frost.storage.perst.messagearchive;

import frost.boards.Board;
import frost.messages.FrostMessageObject;
import frost.storage.ExitSavable;
import frost.storage.MessageCallback;
import frost.storage.perst.AbstractFrostStorage;
import frost.storage.perst.messagearchive.ArchiveMessageStorageRoot;
import frost.storage.perst.messagearchive.PerstFrostArchiveBoardObject;
import frost.storage.perst.messagearchive.PerstFrostArchiveMessageObject;
import java.util.logging.Logger;
import org.garret.perst.IterableIterator;

public class ArchiveMessageStorage
extends AbstractFrostStorage
implements ExitSavable {
    private static final Logger logger = Logger.getLogger(ArchiveMessageStorage.class.getName());
    private static final String STORAGE_FILENAME = "messageArchive.dbs";
    public static final int INSERT_OK = 1;
    public static final int INSERT_DUPLICATE = 2;
    public static final int INSERT_ERROR = 3;
    private ArchiveMessageStorageRoot storageRoot = null;
    private static ArchiveMessageStorage instance = new ArchiveMessageStorage();

    protected ArchiveMessageStorage() {
    }

    public static ArchiveMessageStorage inst() {
        return instance;
    }

    public String getStorageFilename() {
        return STORAGE_FILENAME;
    }

    public boolean initStorage() {
        String databaseFilePath = this.buildStoragePath(this.getStorageFilename());
        int pagePoolSize = this.getPagePoolSize("perst.pagepoolsizeKiB.messagearchive");
        this.open(databaseFilePath, pagePoolSize, true, false, false);
        this.storageRoot = (ArchiveMessageStorageRoot)this.getStorage().getRoot();
        if (this.storageRoot == null) {
            this.storageRoot = new ArchiveMessageStorageRoot(this.getStorage());
            this.getStorage().setRoot(this.storageRoot);
            this.commit();
        }
        return true;
    }

    public void exitSave() {
        this.close();
        this.storageRoot = null;
        System.out.println("INFO: MessageArchiveStorage closed.");
    }

    public void silentClose() {
        this.close();
        this.storageRoot = null;
    }

    public int getMessageCount() {
        int msgCount = 0;
        for (PerstFrostArchiveBoardObject bo : this.storageRoot.getBoardsByName()) {
            if (bo.getMessageIndex() == null) continue;
            msgCount += bo.getMessageIndex().size();
        }
        return msgCount;
    }

    private void addBoard(String boardName) {
        if (boardName == null) {
            return;
        }
        if (this.storageRoot.getBoardsByName().contains(boardName)) {
            return;
        }
        PerstFrostArchiveBoardObject pfbo = new PerstFrostArchiveBoardObject(this.getStorage(), boardName);
        this.storageRoot.getBoardsByName().put(boardName, pfbo);
        logger.severe("Added archive board: " + boardName);
        this.commit();
    }

    public synchronized int insertMessage(FrostMessageObject mo) {
        Board targetBoard = mo.getBoard();
        if (targetBoard == null) {
            logger.severe("msgInsertError: no board in msg");
            return 3;
        }
        return this.insertMessage(mo, targetBoard.getNameLowerCase());
    }

    public synchronized int insertMessage(FrostMessageObject mo, String boardName) {
        if (!mo.isValid()) {
            return 1;
        }
        if (mo.isDeleted()) {
            return 1;
        }
        if (mo.isJunk()) {
            return 1;
        }
        if (mo.getFromIdentity() != null && mo.getFromIdentity().isBAD()) {
            return 1;
        }
        PerstFrostArchiveBoardObject bo = (PerstFrostArchiveBoardObject)this.storageRoot.getBoardsByName().get(boardName);
        if (bo == null) {
            this.addBoard(boardName);
            bo = (PerstFrostArchiveBoardObject)this.storageRoot.getBoardsByName().get(boardName);
            if (bo == null) {
                logger.severe("Error: still no board???");
                return 3;
            }
        }
        PerstFrostArchiveMessageObject pmo = new PerstFrostArchiveMessageObject(mo, this.getStorage());
        if (mo.getMessageId() != null && !bo.getMessageIdIndex().put(mo.getMessageId(), pmo)) {
            return 2;
        }
        bo.getMessageIndex().put(mo.getDateAndTime().getMillis(), pmo);
        return 1;
    }

    public void retrieveMessagesForSearch(Board board, long startDate, long endDate, MessageCallback mc) {
        PerstFrostArchiveMessageObject p;
        FrostMessageObject mo;
        boolean shouldStop;
        PerstFrostArchiveBoardObject bo = (PerstFrostArchiveBoardObject)this.storageRoot.getBoardsByName().get(board.getNameLowerCase());
        if (bo == null) {
            return;
        }
        IterableIterator i = bo.getMessageIndex().iterator(startDate, endDate, 0);
        while (i.hasNext() && !(shouldStop = mc.messageRetrieved(mo = (p = (PerstFrostArchiveMessageObject)i.next()).toFrostMessageObject(board)))) {
        }
    }
}

