/*
 * Decompiled with CFR 0.152.
 */
package frost.storage.perst.messages;

import frost.Core;
import frost.boards.Board;
import frost.messages.FileAttachment;
import frost.messages.FrostMessageObject;
import frost.messages.FrostUnsentMessageObject;
import frost.storage.ExitSavable;
import frost.storage.MessageArchivingCallback;
import frost.storage.MessageCallback;
import frost.storage.perst.AbstractFrostStorage;
import frost.storage.perst.messages.MessageContentStorage;
import frost.storage.perst.messages.MessageStorageRoot;
import frost.storage.perst.messages.PerstFrostBoardObject;
import frost.storage.perst.messages.PerstFrostMessageObject;
import frost.storage.perst.messages.PerstFrostUnsentMessageObject;
import frost.storage.perst.messages.PerstIdentitiesMessages;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Logger;
import org.garret.perst.IterableIterator;
import org.garret.perst.Persistent;
import org.garret.perst.PersistentIterator;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageStorage
extends AbstractFrostStorage
implements ExitSavable {
    private static final transient Logger logger = Logger.getLogger(MessageStorage.class.getName());
    private static final String STORAGE_FILENAME = "messages.dbs";
    public static final int INSERT_OK = 1;
    public static final int INSERT_DUPLICATE = 2;
    public static final int INSERT_ERROR = 3;
    private MessageStorageRoot storageRoot = null;
    private static MessageStorage instance = new MessageStorage();
    private final boolean storeInvalidMessages = Core.frostSettings.getBoolValue("storage.storeInvalidMessages");

    protected MessageStorage() {
    }

    public static MessageStorage inst() {
        return instance;
    }

    @Override
    public String getStorageFilename() {
        return STORAGE_FILENAME;
    }

    @Override
    public boolean initStorage() {
        String databaseFilePath = this.buildStoragePath(this.getStorageFilename());
        int pagePoolSize = this.getPagePoolSize("perst.pagepoolsizeKiB.messages");
        this.open(databaseFilePath, pagePoolSize, true, true, false);
        this.storageRoot = (MessageStorageRoot)this.getStorage().getRoot();
        if (this.storageRoot == null) {
            this.storageRoot = new MessageStorageRoot(this.getStorage());
            this.getStorage().setRoot(this.storageRoot);
            this.commit();
        }
        return true;
    }

    @Override
    public synchronized void commit() {
        MessageContentStorage.inst().commit();
        super.commit();
    }

    @Override
    public boolean endThreadTransaction() {
        MessageContentStorage.inst().commit();
        return super.endThreadTransaction();
    }

    @Override
    public void exitSave() {
        this.close();
        this.storageRoot = null;
        System.out.println("INFO: MessagesStorage closed.");
    }

    public void silentClose() {
        this.close();
        this.storageRoot = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean importBoards(Hashtable<String, Integer> boardPrimaryKeysByName) {
        if (!this.beginExclusiveThreadTransaction()) {
            return false;
        }
        try {
            int highestBoardId = 0;
            for (String boardName : boardPrimaryKeysByName.keySet()) {
                Integer boardId = boardPrimaryKeysByName.get(boardName);
                if (this.storageRoot.getBoardsByName().contains(boardName)) continue;
                PerstFrostBoardObject pfbo = new PerstFrostBoardObject(this.getStorage(), boardName, boardId);
                this.storageRoot.getBoardsByName().put(boardName, pfbo);
                this.storageRoot.getBoardsById().put(boardId, pfbo);
                highestBoardId = Math.max(highestBoardId, boardId);
            }
            this.storageRoot.initUniqueBoardId(highestBoardId + 1);
            boolean bl = true;
            return bl;
        }
        finally {
            this.endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean assignPerstFrostBoardObject(Board newNode) {
        if (!this.beginExclusiveThreadTransaction()) {
            return false;
        }
        try {
            PerstFrostBoardObject pbo = (PerstFrostBoardObject)this.storageRoot.getBoardsByName().get(newNode.getNameLowerCase());
            if (pbo == null) {
                this.addBoard(newNode);
                pbo = (PerstFrostBoardObject)this.storageRoot.getBoardsByName().get(newNode.getNameLowerCase());
                if (pbo == null) {
                    logger.severe("board still not added!");
                    boolean bl = false;
                    return bl;
                }
            }
            newNode.setPerstFrostBoardObject(pbo);
            pbo.setRefBoard(newNode);
            boolean bl = true;
            return bl;
        }
        finally {
            this.endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Board addBoard(Board board) {
        if (board == null) {
            return null;
        }
        if (!this.beginExclusiveThreadTransaction()) {
            return null;
        }
        try {
            PerstFrostBoardObject pfbo = (PerstFrostBoardObject)this.storageRoot.getBoardsByName().get(board.getNameLowerCase());
            if (pfbo != null) {
                board.setPerstFrostBoardObject(pfbo);
                Board board2 = board;
                return board2;
            }
            int boardId = this.storageRoot.getNextUniqueBoardId();
            pfbo = new PerstFrostBoardObject(this.getStorage(), board.getNameLowerCase(), boardId);
            this.storageRoot.getBoardsByName().put(board.getNameLowerCase(), pfbo);
            this.storageRoot.getBoardsById().put(boardId, pfbo);
            Board board3 = board;
            return board3;
        }
        finally {
            this.endThreadTransaction();
        }
    }

    private void removeAll(Iterator<? extends Persistent> i) {
        while (i.hasNext()) {
            i.next().deallocate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBoard(Board board) {
        PerstFrostBoardObject boardToRemove = board.getPerstFrostBoardObject();
        if (boardToRemove == null) {
            return;
        }
        if (!this.beginExclusiveThreadTransaction()) {
            return;
        }
        try {
            for (PerstFrostMessageObject pmo : boardToRemove.getMessageIndex()) {
                PerstIdentitiesMessages pim;
                if (FrostMessageObject.isSignatureStatusVERIFIED(pmo.signatureStatus) && (pim = (PerstIdentitiesMessages)this.storageRoot.getIdentitiesMessages().get(pmo.fromName)) != null) {
                    pim.getMessagesFromIdentity().remove(pmo);
                    if (pim.getMessagesFromIdentity().size() == 0) {
                        this.storageRoot.getIdentitiesMessages().remove(pmo.fromName);
                        pim.deallocate();
                    }
                }
                pmo.deallocate();
            }
            boardToRemove.getMessageIndex().clear();
            boardToRemove.getUnreadMessageIndex().clear();
            boardToRemove.getFlaggedMessageIndex().clear();
            boardToRemove.getStarredMessageIndex().clear();
            this.removeAll(boardToRemove.getInvalidMessagesIndex().iterator());
            boardToRemove.getInvalidMessagesIndex().clear();
            this.removeAll(boardToRemove.getSentMessagesList().iterator());
            boardToRemove.getSentMessagesList().clear();
            this.removeAll(boardToRemove.getUnsentMessagesList().iterator());
            boardToRemove.getUnsentMessagesList().clear();
            this.removeAll(boardToRemove.getDraftMessagesList().iterator());
            boardToRemove.getDraftMessagesList().clear();
            this.storageRoot.getBoardsByName().remove(boardToRemove);
            this.storageRoot.getBoardsById().remove(boardToRemove);
            boardToRemove.deallocate();
        }
        finally {
            this.endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getInvalidMessageCount() {
        if (!this.beginCooperativeThreadTransaction()) {
            return -1;
        }
        try {
            int invalidMsgCount = 0;
            for (PerstFrostBoardObject bo : this.storageRoot.getBoardsByName()) {
                if (bo.getInvalidMessagesIndex() == null) continue;
                invalidMsgCount += bo.getInvalidMessagesIndex().size();
            }
            int n = invalidMsgCount;
            return n;
        }
        finally {
            this.endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageCount() {
        if (!this.beginCooperativeThreadTransaction()) {
            return -1;
        }
        try {
            int msgCount = 0;
            for (PerstFrostBoardObject bo : this.storageRoot.getBoardsByName()) {
                if (bo.getMessageIndex() == null) continue;
                msgCount += bo.getMessageIndex().size();
            }
            int n = msgCount;
            return n;
        }
        finally {
            this.endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageCount(String uniqueIdentityName) {
        if (!this.beginCooperativeThreadTransaction()) {
            return -1;
        }
        try {
            PerstIdentitiesMessages pim = (PerstIdentitiesMessages)this.storageRoot.getIdentitiesMessages().get(uniqueIdentityName);
            if (pim != null) {
                int n = pim.getMessagesFromIdentity().size();
                return n;
            }
            int n = 0;
            return n;
        }
        finally {
            this.endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageCount(Board board, int maxDaysBack) {
        if (!this.beginCooperativeThreadTransaction()) {
            return -1;
        }
        try {
            PerstFrostBoardObject bo = (PerstFrostBoardObject)this.storageRoot.getBoardsByName().get(board.getNameLowerCase());
            if (bo == null) {
                int n = -1;
                return n;
            }
            if (maxDaysBack < 0) {
                int n = bo.getMessageIndex().size();
                return n;
            }
            LocalDate localDate = new LocalDate(DateTimeZone.UTC).minusDays(maxDaysBack);
            long minDateTime = localDate.toDateMidnight(DateTimeZone.UTC).getMillis();
            IterableIterator i1 = bo.getMessageIndex().iterator(minDateTime, Long.MAX_VALUE, 0);
            IterableIterator i2 = bo.getUnreadMessageIndex().iterator(minDateTime, Long.MAX_VALUE, 0);
            Iterator i = this.getStorage().join(new Iterator[]{i1, i2});
            int count = 0;
            while (i.hasNext()) {
                ((PersistentIterator)((Object)i)).nextOid();
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            this.endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getUnreadMessageCount(Board board) {
        if (!this.beginCooperativeThreadTransaction()) {
            return -1;
        }
        try {
            PerstFrostBoardObject bo = (PerstFrostBoardObject)this.storageRoot.getBoardsByName().get(board.getNameLowerCase());
            if (bo == null) {
                int n = -1;
                return n;
            }
            int n = bo.getUnreadMessageIndex().size();
            return n;
        }
        finally {
            this.endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getFlaggedMessageCount(Board board) {
        if (!this.beginCooperativeThreadTransaction()) {
            return -1;
        }
        try {
            PerstFrostBoardObject bo = (PerstFrostBoardObject)this.storageRoot.getBoardsByName().get(board.getNameLowerCase());
            if (bo == null) {
                int n = 0;
                return n;
            }
            int n = bo.getFlaggedMessageIndex().size();
            return n;
        }
        finally {
            this.endThreadTransaction();
        }
    }

    public boolean hasFlaggedMessages(Board board) {
        return this.getFlaggedMessageCount(board) > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getStarredMessageCount(Board board) {
        if (!this.beginCooperativeThreadTransaction()) {
            return -1;
        }
        try {
            PerstFrostBoardObject bo = (PerstFrostBoardObject)this.storageRoot.getBoardsByName().get(board.getNameLowerCase());
            if (bo == null) {
                int n = 0;
                return n;
            }
            int n = bo.getStarredMessageIndex().size();
            return n;
        }
        finally {
            this.endThreadTransaction();
        }
    }

    public boolean hasStarredMessages(Board board) {
        return this.getStarredMessageCount(board) > 0;
    }

    public int insertMessage(FrostMessageObject mo) {
        return this.insertMessage(mo, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int insertMessage(FrostMessageObject mo, boolean useTransaction) {
        if (useTransaction && !this.beginExclusiveThreadTransaction()) {
            return 3;
        }
        try {
            if (mo.getPerstFrostMessageObject() != null) {
                logger.severe("msgInsertError: perst obj already set");
                int n = 3;
                return n;
            }
            Board targetBoard = mo.getBoard();
            if (targetBoard == null) {
                logger.severe("msgInsertError: no board in msg");
                int n = 3;
                return n;
            }
            if (!this.storeInvalidMessages && !mo.isValid()) {
                int n = 1;
                return n;
            }
            PerstFrostBoardObject bo = (PerstFrostBoardObject)this.storageRoot.getBoardsByName().get(targetBoard.getNameLowerCase());
            if (bo == null) {
                logger.severe("Creating new perst board: " + targetBoard.getName());
                this.addBoard(targetBoard);
                bo = (PerstFrostBoardObject)this.storageRoot.getBoardsByName().get(targetBoard.getNameLowerCase());
                if (bo == null) {
                    logger.severe("Error: duplicate board???");
                    int n = 3;
                    return n;
                }
            }
            PerstFrostMessageObject pmo = new PerstFrostMessageObject(mo, this.getStorage(), useTransaction);
            if (!mo.isValid()) {
                bo.getInvalidMessagesIndex().put(mo.getDateAndTime().getMillis(), pmo);
            } else {
                if (mo.getMessageId() != null && !bo.getMessageIdIndex().put(mo.getMessageId(), pmo)) {
                    int n = 2;
                    return n;
                }
                mo.setPerstFrostMessageObject(pmo);
                bo.getMessageIndex().put(mo.getDateAndTime().getMillis(), pmo);
                if (pmo.isNew) {
                    bo.getUnreadMessageIndex().put(mo.getDateAndTime().getMillis(), pmo);
                }
                if (pmo.isFlagged) {
                    bo.getFlaggedMessageIndex().put(mo.getDateAndTime().getMillis(), pmo);
                }
                if (pmo.isStarred) {
                    bo.getStarredMessageIndex().put(mo.getDateAndTime().getMillis(), pmo);
                }
                if (FrostMessageObject.isSignatureStatusVERIFIED(pmo.signatureStatus)) {
                    PerstIdentitiesMessages pim = (PerstIdentitiesMessages)this.storageRoot.getIdentitiesMessages().get(pmo.fromName);
                    if (pim == null) {
                        pim = new PerstIdentitiesMessages(pmo.fromName, this.getStorage());
                        this.storageRoot.getIdentitiesMessages().put(pmo.fromName, pim);
                    }
                    pim.getMessagesFromIdentity().add(pmo);
                }
            }
            int n = 1;
            return n;
        }
        finally {
            if (useTransaction) {
                this.endThreadTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FrostMessageObject retrieveMessageByMessageId(Board board, String msgId, boolean withContent, boolean withAttachments, boolean showDeleted) {
        if (!this.beginCooperativeThreadTransaction()) {
            return null;
        }
        try {
            FrostMessageObject mo;
            PerstFrostBoardObject bo = (PerstFrostBoardObject)this.storageRoot.getBoardsByName().get(board.getNameLowerCase());
            if (bo == null) {
                FrostMessageObject frostMessageObject = null;
                return frostMessageObject;
            }
            PerstFrostMessageObject p = (PerstFrostMessageObject)bo.getMessageIdIndex().get(msgId);
            if (p == null) {
                FrostMessageObject frostMessageObject = null;
                return frostMessageObject;
            }
            if (!showDeleted && p.isDeleted) {
                FrostMessageObject frostMessageObject = null;
                return frostMessageObject;
            }
            FrostMessageObject frostMessageObject = mo = p.toFrostMessageObject(board, withContent, withAttachments);
            return frostMessageObject;
        }
        finally {
            this.endThreadTransaction();
        }
    }

    public void retrieveMessageContent(FrostMessageObject mo) {
        if (mo.getPerstFrostMessageObject() != null) {
            mo.getPerstFrostMessageObject().retrieveMessageContent(mo);
        }
    }

    public void retrievePublicKey(FrostMessageObject mo) {
        if (mo.getPerstFrostMessageObject() != null) {
            mo.getPerstFrostMessageObject().retrievePublicKey(mo);
        }
    }

    public void retrieveSignature(FrostMessageObject mo) {
        if (mo.getPerstFrostMessageObject() != null) {
            mo.getPerstFrostMessageObject().retrieveSignature(mo);
        }
    }

    public void retrieveAttachments(FrostMessageObject mo) {
        if (mo.getPerstFrostMessageObject() != null) {
            mo.getPerstFrostMessageObject().retrieveAttachments(mo);
        }
    }

    public void retrieveMessagesForArchive(Board board, int maxDaysOld, boolean archiveKeepUnread, boolean archiveKeepFlaggedAndStarred, MessageArchivingCallback mc) {
        LocalDate localDate = new LocalDate(DateTimeZone.UTC).minusDays(maxDaysOld);
        long maxDateTime = localDate.toDateMidnight(DateTimeZone.UTC).getMillis();
        PerstFrostBoardObject bo = (PerstFrostBoardObject)this.storageRoot.getBoardsByName().get(board.getNameLowerCase());
        if (bo == null) {
            logger.severe("error: no perst board for archive");
            return;
        }
        IterableIterator i = bo.getMessageIndex().iterator(Long.MIN_VALUE, maxDateTime, 0);
        while (i.hasNext()) {
            PerstIdentitiesMessages pim;
            PerstFrostMessageObject p = (PerstFrostMessageObject)i.next();
            if (archiveKeepUnread && p.isNew || archiveKeepFlaggedAndStarred && (p.isFlagged || p.isStarred)) continue;
            FrostMessageObject mo = p.toFrostMessageObject(board, false, false);
            int mode = mc.messageRetrieved(mo);
            if (mode == 1) {
                return;
            }
            if (mode != 3) continue;
            i.remove();
            if (p.isNew) {
                bo.getUnreadMessageIndex().remove(p.dateAndTime, p);
            }
            if (p.isFlagged) {
                bo.getFlaggedMessageIndex().remove(p.dateAndTime, p);
            }
            if (p.isStarred) {
                bo.getStarredMessageIndex().remove(p.dateAndTime, p);
            }
            if (mo.isSignatureStatusVERIFIED() && (pim = (PerstIdentitiesMessages)this.storageRoot.getIdentitiesMessages().get(p.fromName)) != null) {
                pim.getMessagesFromIdentity().remove(p);
                if (pim.getMessagesFromIdentity().size() == 0) {
                    this.storageRoot.getIdentitiesMessages().remove(p.fromName);
                    pim.deallocate();
                }
            }
            if (p.messageId != null) {
                bo.getMessageIdIndex().remove(p.messageId);
            }
            p.deallocate();
        }
        IterableIterator ii = bo.getInvalidMessagesIndex().iterator(Long.MIN_VALUE, maxDateTime, 0);
        while (ii.hasNext()) {
            PerstFrostMessageObject p = (PerstFrostMessageObject)ii.next();
            ii.remove();
            p.deallocate();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveMessagesForSearch(Board board, long startDate, long endDate, boolean searchInDisplayedMessages, boolean withContent, boolean withAttachments, boolean showDeleted, MessageCallback mc) {
        if (!this.beginCooperativeThreadTransaction()) {
            return;
        }
        try {
            Iterator i;
            PerstFrostBoardObject bo = (PerstFrostBoardObject)this.storageRoot.getBoardsByName().get(board.getNameLowerCase());
            if (bo == null) {
                logger.severe("error: no perst board for search");
                return;
            }
            IterableIterator i1 = bo.getMessageIndex().iterator(startDate, endDate, 0);
            if (searchInDisplayedMessages) {
                Iterator i2 = bo.getUnreadMessageIndex().iterator();
                Iterator i3 = bo.getStarredMessageIndex().iterator();
                Iterator i4 = bo.getFlaggedMessageIndex().iterator();
                i = this.getStorage().join(new Iterator[]{i1, i2, i3, i4});
            } else {
                i = i1;
            }
            while (i.hasNext()) {
                FrostMessageObject mo;
                boolean shouldStop;
                PerstFrostMessageObject p = (PerstFrostMessageObject)i.next();
                if (!showDeleted && p.isDeleted || !(shouldStop = mc.messageRetrieved(mo = p.toFrostMessageObject(board, withContent, withAttachments)))) continue;
                break;
            }
        }
        finally {
            this.endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DateTime getDateTimeOfLatestMessage(Board board) {
        if (!this.beginCooperativeThreadTransaction()) {
            return null;
        }
        try {
            PerstFrostBoardObject bo = (PerstFrostBoardObject)this.storageRoot.getBoardsByName().get(board.getNameLowerCase());
            if (bo == null) {
                logger.severe("error: no perst board for show");
                DateTime dateTime = null;
                return dateTime;
            }
            IterableIterator i = bo.getMessageIndex().iterator(null, Long.MAX_VALUE, 1);
            if (i.hasNext()) {
                PerstFrostMessageObject p = (PerstFrostMessageObject)i.next();
                DateTime dateTime = p.getDateTime();
                return dateTime;
            }
        }
        finally {
            this.endThreadTransaction();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void retrieveMessagesForShow(Board board, int maxDaysBack, boolean withContent, boolean withAttachments, boolean showDeleted, boolean showUnreadOnly, MessageCallback mc) {
        LocalDate localDate = new LocalDate(DateTimeZone.UTC).minusDays(maxDaysBack);
        long minDateTime = localDate.toDateMidnight(DateTimeZone.UTC).getMillis();
        if (!this.beginCooperativeThreadTransaction()) {
            return;
        }
        try {
            Iterator i;
            PerstFrostBoardObject bo = (PerstFrostBoardObject)this.storageRoot.getBoardsByName().get(board.getNameLowerCase());
            if (bo == null) {
                logger.severe("error: no perst board for show");
                return;
            }
            if (showUnreadOnly) {
                i = bo.getUnreadMessageIndex().iterator();
            } else {
                IterableIterator i1 = bo.getMessageIndex().iterator(minDateTime, Long.MAX_VALUE, 0);
                Iterator i2 = bo.getUnreadMessageIndex().iterator();
                Iterator i3 = bo.getStarredMessageIndex().iterator();
                Iterator i4 = bo.getFlaggedMessageIndex().iterator();
                i = this.getStorage().join(new Iterator[]{i1, i2, i3, i4});
            }
            while (i.hasNext()) {
                FrostMessageObject mo;
                boolean shouldStop;
                PerstFrostMessageObject p = (PerstFrostMessageObject)i.next();
                if (!showDeleted && p.isDeleted || !(shouldStop = mc.messageRetrieved(mo = p.toFrostMessageObject(board, withContent, withAttachments)))) continue;
                break;
            }
        }
        finally {
            this.endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAllMessagesRead(Board board) {
        if (!this.beginExclusiveThreadTransaction()) {
            return;
        }
        try {
            PerstFrostBoardObject bo = (PerstFrostBoardObject)this.storageRoot.getBoardsByName().get(board.getNameLowerCase());
            if (bo == null) {
                logger.severe("error: no perst board for update");
                return;
            }
            for (PerstFrostMessageObject pmo : bo.getUnreadMessageIndex()) {
                pmo.isNew = false;
                pmo.modify();
            }
            bo.getUnreadMessageIndex().clear();
        }
        finally {
            this.endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMessagesRead(Board board, List<FrostMessageObject> msgs) {
        if (msgs == null || msgs.size() == 0) {
            return;
        }
        if (!this.beginExclusiveThreadTransaction()) {
            return;
        }
        try {
            PerstFrostBoardObject bo = (PerstFrostBoardObject)this.storageRoot.getBoardsByName().get(board.getNameLowerCase());
            if (bo == null) {
                logger.severe("error: no perst board for update");
                return;
            }
            for (FrostMessageObject mo : msgs) {
                PerstFrostMessageObject pmo = mo.getPerstFrostMessageObject();
                if (pmo == null) {
                    logger.severe("error: no perst obj in msg");
                    continue;
                }
                if (!pmo.isNew) continue;
                mo.setNew(false);
                pmo.isNew = false;
                bo.getUnreadMessageIndex().remove(pmo.dateAndTime, pmo);
                pmo.modify();
            }
        }
        finally {
            this.endThreadTransaction();
        }
    }

    public void updateMessage(FrostMessageObject mo) {
        this.updateMessage(mo, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateMessage(FrostMessageObject mo, boolean useTransaction) {
        if (mo.getPerstFrostMessageObject() == null) {
            return;
        }
        if (useTransaction && !this.beginExclusiveThreadTransaction()) {
            return;
        }
        try {
            PerstFrostBoardObject bo = (PerstFrostBoardObject)this.storageRoot.getBoardsByName().get(mo.getBoard().getNameLowerCase());
            if (bo == null) {
                logger.severe("error: no perst board for update");
                return;
            }
            PerstFrostMessageObject p = mo.getPerstFrostMessageObject();
            if (p.isNew && !mo.isNew()) {
                bo.getUnreadMessageIndex().remove(p.dateAndTime, p);
            } else if (!p.isNew && mo.isNew()) {
                bo.getUnreadMessageIndex().put(p.dateAndTime, p);
            }
            if (p.isFlagged && !mo.isFlagged()) {
                bo.getFlaggedMessageIndex().remove(p.dateAndTime, p);
            } else if (!p.isFlagged && mo.isFlagged()) {
                bo.getFlaggedMessageIndex().put(p.dateAndTime, p);
            }
            if (p.isStarred && !mo.isStarred()) {
                bo.getStarredMessageIndex().remove(p.dateAndTime, p);
            } else if (!p.isStarred && mo.isStarred()) {
                bo.getStarredMessageIndex().put(p.dateAndTime, p);
            }
            p.isDeleted = mo.isDeleted();
            p.isNew = mo.isNew();
            p.isReplied = mo.isReplied();
            p.isJunk = mo.isJunk();
            p.isFlagged = mo.isFlagged();
            p.isStarred = mo.isStarred();
            p.modify();
        }
        finally {
            if (useTransaction) {
                this.endThreadTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FrostMessageObject> retrieveAllSentMessages() {
        ArrayList<FrostMessageObject> lst = new ArrayList<FrostMessageObject>();
        if (!this.beginCooperativeThreadTransaction()) {
            return lst;
        }
        try {
            for (PerstFrostBoardObject bo : this.storageRoot.getBoardsByName()) {
                for (PerstFrostMessageObject pmo : bo.getSentMessagesList()) {
                    FrostMessageObject mo = pmo.toFrostMessageObject(bo.getRefBoard(), false, false);
                    lst.add(mo);
                }
            }
            ArrayList<FrostMessageObject> arrayList = lst;
            return arrayList;
        }
        finally {
            this.endThreadTransaction();
        }
    }

    public boolean insertSentMessage(FrostMessageObject sentMo) {
        return this.insertSentMessage(sentMo, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertSentMessage(FrostMessageObject sentMo, boolean useTransaction) {
        if (useTransaction && !this.beginExclusiveThreadTransaction()) {
            return false;
        }
        try {
            PerstFrostBoardObject bo = sentMo.getBoard().getPerstFrostBoardObject();
            if (bo == null) {
                logger.severe("no board for new sent msg!");
                boolean bl = false;
                return bl;
            }
            PerstFrostMessageObject pmo = new PerstFrostMessageObject(sentMo, this.getStorage(), useTransaction);
            sentMo.setPerstFrostMessageObject(pmo);
            bo.getSentMessagesList().add(pmo);
            boolean bl = true;
            return bl;
        }
        finally {
            if (useTransaction) {
                this.endThreadTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int deleteSentMessages(List<FrostMessageObject> msgObjects) {
        int count = 0;
        if (!this.beginExclusiveThreadTransaction()) {
            return 0;
        }
        try {
            for (FrostMessageObject mo : msgObjects) {
                if (mo.getPerstFrostMessageObject() == null) {
                    logger.severe("delete not possible");
                    continue;
                }
                PerstFrostBoardObject bo = (PerstFrostBoardObject)this.storageRoot.getBoardsByName().get(mo.getBoard().getNameLowerCase());
                if (bo == null) {
                    logger.severe("board not found");
                    continue;
                }
                bo.getSentMessagesList().remove(mo.getPerstFrostMessageObject());
                mo.getPerstFrostMessageObject().deallocate();
                mo.setPerstFrostMessageObject(null);
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            this.endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<FrostUnsentMessageObject> retrieveAllUnsentMessages() {
        ArrayList<FrostUnsentMessageObject> lst = new ArrayList<FrostUnsentMessageObject>();
        if (!this.beginCooperativeThreadTransaction()) {
            return lst;
        }
        try {
            for (PerstFrostBoardObject bo : this.storageRoot.getBoardsByName()) {
                for (PerstFrostUnsentMessageObject pmo : bo.getUnsentMessagesList()) {
                    FrostUnsentMessageObject mo = pmo.toFrostUnsentMessageObject(bo.getRefBoard());
                    lst.add(mo);
                }
            }
            ArrayList<FrostUnsentMessageObject> arrayList = lst;
            return arrayList;
        }
        finally {
            this.endThreadTransaction();
        }
    }

    public boolean insertUnsentMessage(FrostUnsentMessageObject mo) {
        return this.insertUnsentMessage(mo, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean insertUnsentMessage(FrostUnsentMessageObject mo, boolean useTransaction) {
        if (useTransaction && !this.beginExclusiveThreadTransaction()) {
            return false;
        }
        try {
            PerstFrostBoardObject bo = mo.getBoard().getPerstFrostBoardObject();
            if (bo == null) {
                logger.severe("no board for new unsent msg!");
                boolean bl = false;
                return bl;
            }
            PerstFrostUnsentMessageObject pmo = new PerstFrostUnsentMessageObject(this.getStorage(), mo);
            bo.getUnsentMessagesList().add(pmo);
            boolean bl = true;
            return bl;
        }
        finally {
            if (useTransaction) {
                this.endThreadTransaction();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteUnsentMessage(FrostUnsentMessageObject mo) {
        PerstFrostBoardObject bo = mo.getBoard().getPerstFrostBoardObject();
        if (bo == null) {
            logger.severe("no board for unsent msg!");
            return false;
        }
        PerstFrostUnsentMessageObject pmo = mo.getPerstFrostUnsentMessageObject();
        if (pmo == null) {
            logger.severe("no perst unsent msg obj!");
            return false;
        }
        if (!this.beginExclusiveThreadTransaction()) {
            return false;
        }
        try {
            bo.getUnsentMessagesList().remove(pmo);
            pmo.deallocate();
            boolean bl = true;
            return bl;
        }
        finally {
            this.endThreadTransaction();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateUnsentMessageFileAttachmentKey(FrostUnsentMessageObject mo, FileAttachment fa) {
        PerstFrostBoardObject bo = mo.getBoard().getPerstFrostBoardObject();
        if (bo == null) {
            logger.severe("no board for new unsent msg update!");
            return;
        }
        PerstFrostUnsentMessageObject pmo = mo.getPerstFrostUnsentMessageObject();
        if (pmo == null) {
            logger.severe("no perst unsent msg obj for update!");
            return;
        }
        if (!this.beginExclusiveThreadTransaction()) {
            return;
        }
        try {
            pmo.updateUnsentMessageFileAttachmentKey(fa);
        }
        finally {
            this.endThreadTransaction();
        }
    }
}

