/*
 * Decompiled with CFR 0.152.
 */
package frost.threads;

import frost.Core;
import frost.fileTransfer.FilePointerFile;
import frost.fileTransfer.FilePointerFileContent;
import frost.fileTransfer.SharedFilesCHKKeyManager;
import frost.storage.perst.IndexSlot;
import frost.storage.perst.IndexSlotsStorage;
import frost.storage.perst.SharedFilesCHKKey;
import frost.transferlayer.GlobalFileDownloader;
import frost.transferlayer.GlobalFileDownloaderResult;
import frost.transferlayer.GlobalFileUploader;
import frost.util.DateFun;
import frost.util.FileAccess;
import frost.util.Logging;
import frost.util.Mixed;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

public class FilePointersThread
extends Thread {
    private static final Logger logger = Logger.getLogger(FilePointersThread.class.getName());
    private static final int baseSleepTime = 900000;
    private final String keyPrefix;
    private static FilePointersThread instance = new FilePointersThread();

    private FilePointersThread() {
        String fileBase = Core.frostSettings.getValue("fileBase");
        this.keyPrefix = "KSK@frost/filepointers/" + fileBase + "-";
    }

    public static FilePointersThread getInstance() {
        return instance;
    }

    public boolean cancelThread() {
        return false;
    }

    private boolean uploadIndexFile(String dateStr, IndexSlot gis) throws Throwable {
        List<SharedFilesCHKKey> sharedFileCHKkeys = SharedFilesCHKKeyManager.getCHKKeysToSend();
        if (sharedFileCHKkeys == null || sharedFileCHKkeys.size() == 0) {
            logger.info("FILEDN: No CHK keys to send.");
            return true;
        }
        ArrayList<String> tmpChkStringKeys = new ArrayList<String>(sharedFileCHKkeys.size());
        Iterator<SharedFilesCHKKey> i$ = sharedFileCHKkeys.iterator();
        while (i$.hasNext()) {
            SharedFilesCHKKey element;
            SharedFilesCHKKey ck = element = i$.next();
            tmpChkStringKeys.add(ck.getChkKey());
        }
        FilePointerFileContent content = new FilePointerFileContent(System.currentTimeMillis(), tmpChkStringKeys);
        File tmpPointerFile = FileAccess.createTempFile("kskptr_", ".xml");
        tmpPointerFile.deleteOnExit();
        if (!FilePointerFile.writePointerFile(content, tmpPointerFile)) {
            logger.severe("FILEDN: Error writing the KSK pointer file.");
            return false;
        }
        tmpChkStringKeys.clear();
        tmpChkStringKeys = null;
        Mixed.waitRandom(2000);
        logger.info("FILEDN: Starting upload of pointer file containing " + sharedFileCHKkeys.size() + " CHK keys");
        String insertKey = this.keyPrefix + dateStr + "-";
        if (Logging.inst().doLogFilebaseMessages()) {
            System.out.println("uploadIndexFile: Starting upload of pointer file containing " + sharedFileCHKkeys.size() + " CHK keys to " + insertKey + "...");
        }
        boolean wasOk = GlobalFileUploader.uploadFile(gis, tmpPointerFile, insertKey, ".xml", true);
        if (Logging.inst().doLogFilebaseMessages()) {
            System.out.println("uploadIndexFile: upload finished, wasOk=" + wasOk);
        }
        tmpPointerFile.delete();
        if (wasOk) {
            SharedFilesCHKKeyManager.updateCHKKeysWereSuccessfullySent(sharedFileCHKkeys);
        }
        IndexSlotsStorage.inst().storeSlot(gis);
        return wasOk;
    }

    private void downloadDate(String dateStr, IndexSlot gis, boolean isForToday) throws Throwable {
        String requestKey = this.keyPrefix + dateStr + "-";
        int maxFailures = isForToday ? 3 : 2;
        int index = gis.findFirstDownloadSlot();
        int failures = 0;
        while (failures < maxFailures && index >= 0) {
            int maxRetries;
            boolean quicklyFailOnAdnf;
            Mixed.waitRandom(3000);
            logger.info("FILEDN: Requesting index " + index + " for date " + dateStr);
            String downKey = requestKey + index + ".xml";
            if (Logging.inst().doLogFilebaseMessages()) {
                System.out.println("FilePointersThread.downloadDate: requesting: " + downKey);
            }
            if (Core.frostSettings.getBoolValue("fcp2.quicklyFailOnAdnf")) {
                quicklyFailOnAdnf = true;
                maxRetries = 2;
            } else {
                quicklyFailOnAdnf = false;
                maxRetries = -1;
            }
            GlobalFileDownloaderResult result = GlobalFileDownloader.downloadFile(downKey, 81920, maxRetries);
            if (result == null) {
                if (Logging.inst().doLogFilebaseMessages()) {
                    System.out.println("FilePointersThread.downloadDate: failure");
                }
                if (gis.isDownloadIndexBehindLastSetIndex(index)) {
                    ++failures;
                }
                index = gis.findNextDownloadSlot(index);
                continue;
            }
            failures = 0;
            if (result.getErrorCode() == 1) {
                if (Logging.inst().doLogFilebaseMessages()) {
                    if (quicklyFailOnAdnf) {
                        System.out.println("FilePointersThread.downloadDate: Index " + index + " got ADNF, will never try index again.");
                    } else {
                        System.out.println("FilePointersThread.downloadDate: Skipping index " + index + " for now, will try again later.");
                    }
                }
                if (quicklyFailOnAdnf) {
                    gis.setDownloadSlotUsed(index);
                    IndexSlotsStorage.inst().storeSlot(gis);
                }
                index = gis.findNextDownloadSlot(index);
                continue;
            }
            gis.setDownloadSlotUsed(index);
            index = gis.findNextDownloadSlot(index);
            if (result.getErrorCode() == 2) {
                logger.severe("FilePointersThread.downloadDate: Dropping index " + index + ", FILE_TOO_BIG.");
            } else {
                if (Logging.inst().doLogFilebaseMessages()) {
                    System.out.println("FilePointersThread.downloadDate: success");
                }
                File downloadedFile = result.getResultFile();
                FilePointerFileContent content = null;
                try {
                    content = FilePointerFile.readPointerFile(downloadedFile);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Invalid XML content: " + e.getMessage());
                }
                if (Logging.inst().doLogFilebaseMessages()) {
                    System.out.println("readPointerFile: result: " + content);
                }
                downloadedFile.delete();
                SharedFilesCHKKeyManager.processReceivedCHKKeys(content);
            }
            IndexSlotsStorage.inst().storeSlot(gis);
        }
        if (Logging.inst().doLogFilebaseMessages()) {
            System.out.println("FilePointersThread.downloadDate: finished");
        }
    }

    public void run() {
        int maxAllowedExceptions = 5;
        int occuredExceptions = 0;
        int downloadFullBackloadCount = 2;
        while (true) {
            int downloadBack;
            if (downloadFullBackloadCount > 0) {
                downloadBack = 1 + Core.frostSettings.getIntValue("fileListDownloadDays");
                --downloadFullBackloadCount;
            } else {
                downloadBack = 2;
            }
            try {
                LocalDate nowDate = new LocalDate(DateTimeZone.UTC);
                for (int i = 0; i < downloadBack; ++i) {
                    boolean isForToday = i == 0;
                    LocalDate localDate = nowDate.minusDays(i);
                    String dateStr = DateFun.FORMAT_DATE.print(localDate);
                    long date = localDate.toDateMidnight(DateTimeZone.UTC).getMillis();
                    IndexSlot gis = IndexSlotsStorage.inst().getSlotForDate(-1, date);
                    if (Logging.inst().doLogFilebaseMessages()) {
                        System.out.println("FilePointersThread: download for " + dateStr);
                    }
                    if (!this.isInterrupted()) {
                        this.downloadDate(dateStr, gis, isForToday);
                    }
                    if (!this.isInterrupted() && isForToday) {
                        try {
                            if (Logging.inst().doLogFilebaseMessages()) {
                                System.out.println("FilePointersThread: upload for " + dateStr);
                            }
                            this.uploadIndexFile(dateStr, gis);
                        }
                        catch (Throwable t) {
                            logger.log(Level.SEVERE, "Exception during uploadIndexFile()", t);
                        }
                    }
                    if (!this.isInterrupted()) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                logger.log(Level.SEVERE, "Exception catched", e);
                ++occuredExceptions;
            }
            if (occuredExceptions > 5) {
                logger.log(Level.SEVERE, "Stopping FilePointersThread because of too much exceptions");
                break;
            }
            if (this.isInterrupted()) break;
            Mixed.waitRandom(900000);
        }
    }
}

