/*
 * Decompiled with CFR 0.152.
 */
package frost.threads;

import frost.Core;
import frost.MainFrame;
import frost.boards.Board;
import frost.boards.BoardUpdateInformation;
import frost.boards.TOF;
import frost.identities.Identity;
import frost.identities.LocalIdentity;
import frost.messages.FrostMessageObject;
import frost.messages.FrostUnsentMessageObject;
import frost.messages.MessageXmlFile;
import frost.messages.SentMessagesManager;
import frost.messages.UnsentMessagesManager;
import frost.storage.perst.IndexSlot;
import frost.storage.perst.IndexSlotsStorage;
import frost.threads.BoardUpdateThread;
import frost.threads.BoardUpdateThreadObject;
import frost.transferlayer.MessageDownloader;
import frost.transferlayer.MessageDownloaderResult;
import frost.transferlayer.MessageUploader;
import frost.transferlayer.MessageUploaderCallback;
import frost.transferlayer.MessageUploaderResult;
import frost.util.DateFun;
import frost.util.FileAccess;
import frost.util.Mixed;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.joda.time.DateMidnight;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.LocalDate;

public class MessageThread
extends BoardUpdateThreadObject
implements BoardUpdateThread,
MessageUploaderCallback {
    private final Board board;
    private final int maxMessageDownload;
    private final boolean downloadToday;
    private static final Logger logger = Logger.getLogger(MessageThread.class.getName());

    public MessageThread(boolean downloadToday, Board boa, int maxmsgdays) {
        super(boa);
        this.downloadToday = downloadToday;
        this.board = boa;
        this.maxMessageDownload = maxmsgdays;
    }

    public int getThreadType() {
        if (this.downloadToday) {
            return 1;
        }
        return 2;
    }

    public void run() {
        this.notifyThreadStarted(this);
        try {
            String tofType = this.downloadToday ? "TOF Download" : "TOF Download Back";
            Mixed.waitRandom(5000);
            logger.info("TOFDN: " + tofType + " Thread started for board " + this.board.getName());
            if (this.isInterrupted()) {
                this.notifyThreadFinished(this);
                return;
            }
            LocalDate localDate = new LocalDate(DateTimeZone.UTC);
            int boardId = this.board.getPerstFrostBoardObject().getBoardId();
            if (this.downloadToday) {
                long dateMillis = localDate.toDateMidnight(DateTimeZone.UTC).getMillis();
                IndexSlot gis = IndexSlotsStorage.inst().getSlotForDate(boardId, dateMillis);
                BoardUpdateInformation todayBui = this.downloadDate(localDate, gis, dateMillis);
                if (todayBui.isBoardUpdateAllowed()) {
                    this.uploadMessages(gis);
                }
            } else {
                int daysBack = 0;
                while (!this.isInterrupted() && daysBack < this.maxMessageDownload) {
                    ++daysBack;
                    localDate = localDate.minusDays(1);
                    long dateMillis = localDate.toDateMidnight(DateTimeZone.UTC).getMillis();
                    IndexSlot gis = IndexSlotsStorage.inst().getSlotForDate(boardId, dateMillis);
                    this.downloadDate(localDate, gis, dateMillis);
                    if (this.isInterrupted()) continue;
                    this.board.setLastBackloadUpdateFinishedMillis(System.currentTimeMillis());
                }
            }
            logger.info("TOFDN: " + tofType + " Thread stopped for board " + this.board.getName());
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, Thread.currentThread().getName() + ": Oo. Exception in MessageDownloadThread:", t);
        }
        this.notifyThreadFinished(this);
    }

    protected String composeDownKey(int index, String dirdate) {
        String downKey = null;
        downKey = !this.board.isPublicBoard() ? this.board.getPublicKey() + "/" + this.board.getBoardFilename() + "/" + dirdate + "-" + index + ".xml" : "KSK@frost/message/" + Core.frostSettings.getValue("messageBase") + "/" + dirdate + "-" + this.board.getBoardFilename() + "-" + index + ".xml";
        return downKey;
    }

    protected BoardUpdateInformation downloadDate(LocalDate localDate, IndexSlot gis, long dateMillis) {
        String dirDateString = DateFun.FORMAT_DATE.print(localDate);
        BoardUpdateInformation boardUpdateInformation = this.board.getOrCreateBoardUpdateInformationForDay(dirDateString, dateMillis);
        boardUpdateInformation.resetSubsequentInvalidMsgs();
        int index = -1;
        int failures = 0;
        int maxFailures = 2;
        while (failures < 2 && !this.isInterrupted() && boardUpdateInformation.checkBoardUpdateAllowedState()) {
            index = index < 0 ? gis.findFirstDownloadSlot() : gis.findNextDownloadSlot(index);
            String logInfo = null;
            try {
                int maxRetries;
                boolean quicklyFailOnAdnf;
                boolean fastDownload;
                Mixed.waitRandom(2000);
                String downKey = this.composeDownKey(index, dirDateString);
                logInfo = " board=" + this.board.getName() + ", key=" + downKey;
                boolean bl = fastDownload = !this.downloadToday;
                if (Core.frostSettings.getBoolValue("fcp2.quicklyFailOnAdnf")) {
                    quicklyFailOnAdnf = true;
                    maxRetries = 2;
                } else {
                    quicklyFailOnAdnf = false;
                    maxRetries = -1;
                }
                boardUpdateInformation.setCurrentIndex(index);
                this.notifyBoardUpdateInformationChanged(this, boardUpdateInformation);
                long millisBefore = System.currentTimeMillis();
                MessageDownloaderResult mdResult = MessageDownloader.downloadMessage(downKey, index, maxRetries, fastDownload, logInfo);
                boardUpdateInformation.incCountTriedIndices();
                boardUpdateInformation.addNodeTime(System.currentTimeMillis() - millisBefore);
                if (mdResult == null) {
                    if (gis.isDownloadIndexBehindLastSetIndex(index)) {
                        ++failures;
                    }
                    boardUpdateInformation.incCountDNF();
                    this.notifyBoardUpdateInformationChanged(this, boardUpdateInformation);
                    continue;
                }
                failures = 0;
                if (mdResult.isFailure() && mdResult.getErrorMessage() != null && mdResult.getErrorMessage().equals("AllDataNotFound")) {
                    boardUpdateInformation.incCountADNF();
                    this.notifyBoardUpdateInformationChanged(this, boardUpdateInformation);
                    if (quicklyFailOnAdnf) {
                        System.out.println("TOFDN: Index " + index + " got ADNF, will never try this index again.");
                        gis.setDownloadSlotUsed(index);
                        IndexSlotsStorage.inst().storeSlot(gis);
                        continue;
                    }
                    System.out.println("TOFDN: Skipping index " + index + " for now, will try again later.");
                    continue;
                }
                gis.setDownloadSlotUsed(index);
                if (mdResult.isFailure()) {
                    this.receivedInvalidMessage(this.board, localDate, index, mdResult.getErrorMessage());
                    boardUpdateInformation.incCountInvalid();
                    this.notifyBoardUpdateInformationChanged(this, boardUpdateInformation);
                } else if (mdResult.getMessage() != null) {
                    mdResult.getMessage().getFile().delete();
                    if (this.isValidFormat(mdResult.getMessage(), localDate, this.board)) {
                        this.receivedValidMessage(mdResult.getMessage(), mdResult.getOwner(), this.board, index);
                        boardUpdateInformation.incCountValid();
                        boardUpdateInformation.updateMaxSuccessfulIndex(index);
                        this.notifyBoardUpdateInformationChanged(this, boardUpdateInformation);
                    } else {
                        this.receivedInvalidMessage(this.board, localDate, index, "InvalidMsg");
                        logger.warning("TOFDN: Message was dropped, format validation failed: " + logInfo);
                        boardUpdateInformation.incCountInvalid();
                        this.notifyBoardUpdateInformationChanged(this, boardUpdateInformation);
                    }
                }
                IndexSlotsStorage.inst().storeSlot(gis);
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "TOFDN: Exception thrown in downloadDate: " + logInfo, t);
            }
        }
        boardUpdateInformation.setCurrentIndex(-1);
        boardUpdateInformation.updateBoardUpdateAllowedState();
        this.notifyBoardUpdateInformationChanged(this, boardUpdateInformation);
        return boardUpdateInformation;
    }

    private void receivedInvalidMessage(Board b, LocalDate calDL, int index, String reason) {
        TOF.getInstance().receivedInvalidMessage(b, calDL.toDateTimeAtMidnight(), index, reason);
    }

    private void receivedValidMessage(MessageXmlFile mo, Identity owner, Board b, int index) {
        TOF.getInstance().receivedValidMessage(mo, owner, b, index);
    }

    public boolean isValidFormat(MessageXmlFile mo, LocalDate dirDate, Board b) {
        try {
            String downloadingBoardName;
            DateTime dateTime;
            try {
                dateTime = mo.getDateAndTime();
            }
            catch (Throwable ex) {
                logger.log(Level.SEVERE, "Exception in isValidFormat() - skipping message.", ex);
                return false;
            }
            if (mo.getMessageId() == null || mo.getMessageId().length() < 60 || mo.getMessageId().length() > 68) {
                logger.log(Level.SEVERE, "Message has no unique message id - skipping Message: " + dirDate + ";" + dateTime);
                return false;
            }
            DateMidnight dm = dateTime.toDateMidnight();
            if (dm.isAfter(dirDate.plusDays(1).toDateMidnight(DateTimeZone.UTC)) || dm.isBefore(dirDate.minusDays(1).toDateMidnight(DateTimeZone.UTC))) {
                logger.log(Level.SEVERE, "Invalid date - skipping Message: " + dirDate + ";" + dateTime);
                return false;
            }
            if (mo.getBoardName() == null) {
                logger.log(Level.SEVERE, "No boardname in message - skipping message: (null)");
                return false;
            }
            String boardNameInMsg = mo.getBoardName().toLowerCase();
            if (!boardNameInMsg.equals(downloadingBoardName = b.getName().toLowerCase())) {
                logger.log(Level.SEVERE, "Different boardnames - skipping message: " + mo.getBoardName().toLowerCase() + ";" + b.getName().toLowerCase());
                return false;
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Exception in isValidFormat() - skipping message.", t);
            return false;
        }
        return true;
    }

    protected void uploadMessages(IndexSlot gis) {
        FrostUnsentMessageObject unsendMsg = UnsentMessagesManager.getUnsentMessage(this.board);
        if (unsendMsg == null) {
            return;
        }
        String fromName = unsendMsg.getFromName();
        while (unsendMsg != null) {
            Identity recipient = null;
            if (unsendMsg.getRecipientName() != null && unsendMsg.getRecipientName().length() > 0 && (recipient = Core.getIdentities().getIdentity(unsendMsg.getRecipientName())) == null) {
                logger.severe("Can't send Message '" + unsendMsg.getSubject() + "', the recipient is not longer in your identites list!");
                UnsentMessagesManager.deleteMessage(unsendMsg);
                continue;
            }
            UnsentMessagesManager.incRunningMessageUploads();
            this.uploadMessage(unsendMsg, recipient, gis);
            UnsentMessagesManager.decRunningMessageUploads();
            Mixed.waitRandom(5000);
            unsendMsg = UnsentMessagesManager.getUnsentMessage(this.board, fromName);
        }
    }

    private void uploadMessage(FrostUnsentMessageObject mo, Identity recipient, IndexSlot gis) {
        logger.info("Preparing upload of message to board '" + this.board.getName() + "'");
        mo.setCurrentUploadThread(this);
        try {
            LocalIdentity senderId = null;
            if (mo.getFromName().indexOf("@") > 0) {
                if (mo.getFromIdentity() instanceof LocalIdentity) {
                    senderId = (LocalIdentity)mo.getFromIdentity();
                } else {
                    logger.severe("The LocalIdentity used to write this unsent msg was deleted: " + mo.getFromName());
                    mo.setCurrentUploadThread(null);
                    UnsentMessagesManager.deleteMessage(mo);
                    return;
                }
            }
            MessageXmlFile message = new MessageXmlFile(mo);
            DateTime now = new DateTime(DateTimeZone.UTC);
            message.setDateAndTime(now);
            File unsentMessageFile = FileAccess.createTempFile("unsendMsg", ".xml");
            message.setFile(unsentMessageFile);
            if (!message.save()) {
                logger.severe("This was a HARD error and the file to upload is lost, please report to a dev!");
                mo.setCurrentUploadThread(null);
                return;
            }
            unsentMessageFile.deleteOnExit();
            MessageUploaderResult result = MessageUploader.uploadMessage(message, recipient, senderId, this, gis, MainFrame.getInstance(), this.board.getName());
            message.getFile().delete();
            if (!result.isSuccess()) {
                mo.setCurrentUploadThread(null);
                if (!result.isKeepMessage()) {
                    UnsentMessagesManager.deleteMessage(mo);
                } else {
                    UnsentMessagesManager.dequeueMessage(mo);
                }
                return;
            }
            IndexSlotsStorage.inst().storeSlot(gis);
            int index = result.getUploadIndex();
            FrostMessageObject sentMo = new FrostMessageObject(message, senderId, this.board, index);
            if (!SentMessagesManager.addSentMessage(sentMo)) {
                sentMo.setPerstFrostMessageObject(null);
            }
            if (sentMo.getRecipientName() != null && sentMo.getRecipientName().length() > 0) {
                FrostMessageObject moForMsgTable = sentMo.getPerstFrostMessageObject() != null ? new FrostMessageObject(message, senderId, this.board, index) : sentMo;
                moForMsgTable.setSignatureStatusVERIFIED_V2();
                TOF.getInstance().receivedValidMessage(moForMsgTable, this.board, index);
            }
            mo.setCurrentUploadThread(null);
            UnsentMessagesManager.deleteMessage(mo);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Catched exception", t);
        }
        mo.setCurrentUploadThread(null);
        logger.info("Message upload finished");
    }

    public String composeDownloadKey(MessageXmlFile message, int index) {
        String key = this.board.isWriteAccessBoard() ? this.board.getPublicKey() + "/" + this.board.getBoardFilename() + "/" + message.getDateStr() + "-" + index + ".xml" : "KSK@frost/message/" + Core.frostSettings.getValue("messageBase") + "/" + message.getDateStr() + "-" + this.board.getBoardFilename() + "-" + index + ".xml";
        return key;
    }

    public String composeUploadKey(MessageXmlFile message, int index) {
        String key = this.board.isWriteAccessBoard() ? this.board.getPrivateKey() + "/" + this.board.getBoardFilename() + "/" + message.getDateStr() + "-" + index + ".xml" : "KSK@frost/message/" + Core.frostSettings.getValue("messageBase") + "/" + message.getDateStr() + "-" + this.board.getBoardFilename() + "-" + index + ".xml";
        return key;
    }
}

