/*
 * Decompiled with CFR 0.152.
 */
package frost.transferlayer;

import frost.Core;
import frost.crypt.EncryptMetaData;
import frost.crypt.MetaData;
import frost.crypt.SignMetaData;
import frost.fcp.FcpHandler;
import frost.fcp.FcpResultGet;
import frost.identities.Identity;
import frost.identities.LocalIdentity;
import frost.messages.MessageCreationException;
import frost.messages.MessageXmlFile;
import frost.transferlayer.MessageDownloaderResult;
import frost.util.FileAccess;
import frost.util.Mixed;
import frost.util.XMLTools;
import java.io.File;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.w3c.dom.Document;

public class MessageDownloader {
    private static final Logger logger = Logger.getLogger(MessageDownloader.class.getName());

    protected static MessageDownloaderResult processDownloadedFile(File tmpFile, FcpResultGet results, String logInfo) {
        try {
            if (FcpHandler.isFreenet05()) {
                return MessageDownloader.processDownloadedFile05(tmpFile, results, logInfo);
            }
            if (FcpHandler.isFreenet07()) {
                return MessageDownloader.processDownloadedFile07(tmpFile, results, logInfo);
            }
            logger.severe("Unsupported freenet version, not 0.5 or 0.7");
            return null;
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Error processing downloaded message", t);
            MessageDownloaderResult mdResult = new MessageDownloaderResult("BrokenMsg");
            return mdResult;
        }
    }

    public static MessageDownloaderResult downloadMessage(String downKey, int targetIndex, int maxRetries, boolean fastDownload, String logInfo) {
        FcpResultGet results;
        File tmpFile = FileAccess.createTempFile("dlMsg_", "-" + targetIndex + ".xml.tmp");
        try {
            results = FcpHandler.inst().getFile(1, downKey, null, tmpFile, false, fastDownload, 81920, maxRetries);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "TOFDN: Exception thrown in downloadDate part 1." + logInfo, t);
            tmpFile.delete();
            return null;
        }
        if (results == null || !results.isSuccess()) {
            tmpFile.delete();
            if (results != null && results.getReturnCode() == 28) {
                logger.warning("TOFDN: All data not found." + logInfo);
                System.out.println("TOFDN: Contents of message key partially missing.");
                return new MessageDownloaderResult("AllDataNotFound");
            }
            if (results != null && results.getReturnCode() == 21) {
                logger.severe("TOFDN: Message file too big." + logInfo);
                System.out.println("TOFDN: Message file too big.");
                return new MessageDownloaderResult("MsgTooBig");
            }
            return null;
        }
        return MessageDownloader.processDownloadedFile(tmpFile, results, logInfo);
    }

    protected static MessageDownloaderResult processDownloadedFile05(File tmpFile, FcpResultGet results, String logInfo) {
        try {
            String messageHash;
            byte[] unzippedXml;
            logger.info("TOFDN: A message was downloaded." + logInfo);
            byte[] metadata = results.getRawMetadata();
            if (tmpFile.length() == 0L) {
                if (metadata != null && metadata.length > 0) {
                    logger.severe("TOFDN: Received metadata without data, maybe faked message." + logInfo);
                } else if (metadata == null || metadata.length == 0) {
                    logger.severe("TOFDN: Received neither metadata nor data, maybe a bug or a faked message." + logInfo);
                } else {
                    logger.severe("TOFDN: Received something, but bad things happened in code, maybe a bug or a faked message." + logInfo);
                }
                tmpFile.delete();
                return new MessageDownloaderResult("BrokenMsg");
            }
            if (metadata == null) {
                byte[] unzippedXml2 = FileAccess.readZipFileBinary(tmpFile);
                if (unzippedXml2 == null) {
                    logger.log(Level.SEVERE, "TOFDN: Unzip of unsigned xml failed." + logInfo);
                    tmpFile.delete();
                    return new MessageDownloaderResult("BrokenMsg");
                }
                FileAccess.writeFile(unzippedXml2, tmpFile);
                try {
                    MessageXmlFile currentMsg = new MessageXmlFile(tmpFile);
                    if (currentMsg.getFromName().indexOf(64) > -1) {
                        logger.severe("TOFDN: unsigned message has an invalid fromName (contains an @: '" + currentMsg.getFromName() + "'), message dropped." + logInfo);
                        tmpFile.delete();
                        return new MessageDownloaderResult("InvalidMsg");
                    }
                    currentMsg.setSignatureStatusOLD();
                    return new MessageDownloaderResult(currentMsg);
                }
                catch (Exception ex) {
                    logger.log(Level.SEVERE, "TOFDN: Unsigned message is invalid." + logInfo, ex);
                    tmpFile.delete();
                    return new MessageDownloaderResult("BrokenMsg");
                }
            }
            MetaData _metaData = null;
            try {
                Document doc = XMLTools.parseXmlContent(metadata, false);
                if (doc != null) {
                    _metaData = MetaData.getInstance(doc.getDocumentElement());
                }
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "TOFDN: Invalid metadata of signed message" + logInfo, t);
                _metaData = null;
            }
            if (_metaData == null) {
                logger.log(Level.SEVERE, "TOFDN: Metadata couldn't be read. Offending file saved as badmetadata.xml - send to a dev for analysis." + logInfo);
                File badmetadata = new File("badmetadata.xml");
                FileAccess.writeFile(metadata, badmetadata);
                tmpFile.delete();
                return new MessageDownloaderResult("BrokenMetaData");
            }
            if (_metaData.getType() != 0 && _metaData.getType() != 1) {
                logger.severe("TOFDN: Unknown type of metadata." + logInfo);
                tmpFile.delete();
                return new MessageDownloaderResult("BrokenMetaData");
            }
            SignMetaData metaData = (SignMetaData)_metaData;
            Identity owner = metaData.getPerson();
            if (!Core.getIdentities().isNewIdentityValid(owner)) {
                logger.severe("TOFDN: identity failed verification, message dropped." + logInfo);
                tmpFile.delete();
                return new MessageDownloaderResult("InvalidMsg");
            }
            byte[] plaintext = FileAccess.readByteArray(tmpFile);
            boolean sigIsValid = Core.getCrypto().detachedVerify(plaintext, owner.getPublicKey(), metaData.getSig());
            if (_metaData.getType() == 1) {
                EncryptMetaData encMetaData = (EncryptMetaData)metaData;
                if (!Core.getIdentities().isMySelf(encMetaData.getRecipient())) {
                    logger.fine("TOFDN: Encrypted message was not for me.");
                    tmpFile.delete();
                    return new MessageDownloaderResult("NotForMe");
                }
                LocalIdentity receiverId = Core.getIdentities().getLocalIdentity(encMetaData.getRecipient());
                byte[] cipherText = FileAccess.readByteArray(tmpFile);
                byte[] zipData = Core.getCrypto().decrypt(cipherText, receiverId.getPrivateKey());
                if (zipData == null) {
                    logger.severe("TOFDN: Encrypted message from " + encMetaData.getPerson().getUniqueName() + " could not be decrypted!" + logInfo);
                    tmpFile.delete();
                    return new MessageDownloaderResult("DecryptFailed");
                }
                tmpFile.delete();
                FileAccess.writeFile(zipData, tmpFile);
                logger.fine("TOFDN: Decrypted an encrypted message for me, sender was " + encMetaData.getPerson().getUniqueName() + "." + logInfo);
            }
            if ((unzippedXml = FileAccess.readZipFileBinary(tmpFile)) == null) {
                logger.severe("TOFDN: Unzip of signed xml failed." + logInfo);
                tmpFile.delete();
                return new MessageDownloaderResult("BrokenMsg");
            }
            FileAccess.writeFile(unzippedXml, tmpFile);
            MessageXmlFile currentMsg = null;
            try {
                currentMsg = new MessageXmlFile(tmpFile);
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "TOFDN: Exception when creating message object" + logInfo, ex);
                tmpFile.delete();
                return new MessageDownloaderResult("BrokenMsg");
            }
            if (!sigIsValid) {
                logger.severe("TOFDN: message failed verification, message dropped." + logInfo);
                tmpFile.delete();
                return new MessageDownloaderResult("InvalidMsg");
            }
            String metaDataHash = Mixed.makeFilename(Core.getCrypto().digest(metaData.getPerson().getPublicKey()));
            if (!metaDataHash.equals(messageHash = Mixed.makeFilename(currentMsg.getFromName().substring(currentMsg.getFromName().indexOf("@") + 1, currentMsg.getFromName().length())))) {
                logger.severe("TOFDN: Hash in metadata doesn't match hash in message!\nmetadata : " + metaDataHash + " , message: " + messageHash + ". Message failed verification and was dropped." + logInfo);
                tmpFile.delete();
                return new MessageDownloaderResult("InvalidMsg");
            }
            currentMsg.setSignatureStatusVERIFIED_V2();
            return new MessageDownloaderResult(currentMsg, owner);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "TOFDN: Exception thrown in downloadDate part 2." + logInfo, t);
            tmpFile.delete();
            return null;
        }
    }

    protected static MessageDownloaderResult processDownloadedFile07(File tmpFile, FcpResultGet results, String logInfo) {
        try {
            boolean sigIsValid;
            boolean acceptV1;
            MessageXmlFile currentMsg;
            try {
                currentMsg = new MessageXmlFile(tmpFile);
            }
            catch (MessageCreationException ex) {
                String errorMessage;
                if (ex.getMessageNo() == 1) {
                    logger.warning("Info: Encrypted message is not for me. " + logInfo);
                    errorMessage = "NotForMe";
                } else if (ex.getMessageNo() == 2) {
                    logger.log(Level.WARNING, "TOFDN: Exception catched." + logInfo, ex);
                    errorMessage = "DecryptFailed";
                } else if (ex.getMessageNo() == 3) {
                    logger.warning("Error: Message validation failed. " + logInfo);
                    errorMessage = "InvalidMsg";
                } else {
                    logger.log(Level.WARNING, "TOFDN: Exception catched." + logInfo, ex);
                    errorMessage = "BrokenMsg";
                }
                tmpFile.delete();
                return new MessageDownloaderResult(errorMessage);
            }
            catch (Throwable ex) {
                logger.log(Level.SEVERE, "TOFDN: Exception catched." + logInfo, ex);
                tmpFile.delete();
                return new MessageDownloaderResult("BrokenMsg");
            }
            boolean isSignedV1 = false;
            boolean isSignedV2 = false;
            if (currentMsg.getSignatureV1() != null && currentMsg.getSignatureV1().length() > 0) {
                isSignedV1 = true;
            }
            if (currentMsg.getSignatureV2() != null && currentMsg.getSignatureV2().length() > 0) {
                isSignedV2 = true;
            }
            if (!isSignedV1 && !isSignedV2) {
                if (currentMsg.getFromName().indexOf(64) > -1) {
                    logger.severe("TOFDN: unsigned message has an invalid fromName (contains an @: '" + currentMsg.getFromName() + "'), message dropped." + logInfo);
                    tmpFile.delete();
                    return new MessageDownloaderResult("InvalidMsg");
                }
                currentMsg.setSignatureStatusOLD();
                return new MessageDownloaderResult(currentMsg);
            }
            if (isSignedV1 && !isSignedV2 && !(acceptV1 = Core.frostSettings.getBoolValue("acceptSignatureFormatV1"))) {
                logger.severe("TOFDN: message has only V1 signature which is not accepted, message dropped." + logInfo);
                tmpFile.delete();
                return new MessageDownloaderResult("InvalidMsg");
            }
            Identity owner = Identity.createIdentityFromExactStrings(currentMsg.getFromName(), currentMsg.getPublicKey());
            if (!Core.getIdentities().isNewIdentityValid(owner)) {
                logger.severe("TOFDN: identity failed verification, message dropped." + logInfo);
                tmpFile.delete();
                return new MessageDownloaderResult("InvalidMsg");
            }
            if (isSignedV2) {
                sigIsValid = currentMsg.verifyMessageSignatureV2(owner.getPublicKey());
                logger.info("TOFDN: verification of V2 signature: " + sigIsValid + "." + logInfo);
            } else {
                sigIsValid = currentMsg.verifyMessageSignatureV1(owner.getPublicKey());
                logger.info("TOFDN: verification of V1 signature: " + sigIsValid + "." + logInfo);
            }
            if (!sigIsValid) {
                logger.severe("TOFDN: message failed verification, message dropped." + logInfo);
                tmpFile.delete();
                return new MessageDownloaderResult("InvalidMsg");
            }
            if (isSignedV2) {
                currentMsg.setSignatureStatusVERIFIED_V2();
            } else {
                currentMsg.setSignatureStatusVERIFIED_V1();
            }
            return new MessageDownloaderResult(currentMsg, owner);
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "TOFDN: Exception catched." + logInfo, t);
            tmpFile.delete();
            return null;
        }
    }
}

