/*
 * Decompiled with CFR 0.152.
 */
package frost.util;

import java.text.NumberFormat;

public class FormatterUtils {
    private static final String[] sizeSuffixes = new String[]{" B", " KiB", " MiB", " GiB", " TiB", " PiB", " EiB", " ZiB", " YiB"};
    private static final NumberFormat numberFormat = NumberFormat.getInstance();

    public static String formatSize(long sz) {
        int i;
        long s = 1L;
        for (i = 0; i < sizeSuffixes.length && (s *= 1024L) <= sz; ++i) {
        }
        if ((s /= 1024L) == 1L) {
            return sz + sizeSuffixes[0];
        }
        double mantissa = (double)sz / (double)s;
        String o = Double.toString(mantissa);
        if (o.indexOf(46) == 3) {
            o = o.substring(0, 3);
        } else if (o.indexOf(46) > -1 && o.indexOf(69) == -1 && o.length() > 4) {
            o = o.substring(0, 4);
        }
        o = o + sizeSuffixes[i];
        return o;
    }

    public static String formatPercent(int value, int maxValue) {
        if (maxValue == 0) {
            maxValue = 1;
        }
        double d = (double)value * 100.0 / (double)maxValue;
        return numberFormat.format(d);
    }

    public static String formatFraction(long value, long maxValue) {
        if (maxValue == 0L) {
            maxValue = 1L;
        }
        double d = (double)value / (double)maxValue;
        return numberFormat.format(d);
    }

    static {
        numberFormat.setMaximumFractionDigits(2);
    }
}

