/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui;

import frost.util.gui.TextComponentClipboardMenu;
import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import frost.util.gui.translation.TranslatableListModel;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class FontChooser
extends JDialog {
    private final Listener listener = new Listener();
    private Language language = null;
    private final DefaultListModel fontNamesModel = new DefaultListModel();
    private final JList fontNamesList = new JList(this.fontNamesModel);
    private final JTextField selectedNameTextField = new JTextField();
    private TranslatableListModel fontStylesModel = null;
    private final JList fontStylesList = new JList();
    private final JTextField selectedStyleTextField = new JTextField();
    private final DefaultListModel fontSizesModel = new DefaultListModel();
    private final JList fontSizesList = new JList(this.fontSizesModel);
    private final JTextField selectedSizeTextField = new JTextField();
    private final JLabel sampleLabel = new JLabel();
    private final JTextField sampleTextField = new JTextField();
    private final JButton cancelButton = new JButton();
    private final JButton okButton = new JButton();
    private Font selectedFont = null;
    private String selectedName = null;
    private Integer selectedSize = null;
    private Integer selectedStyle = null;
    private final HashMap<String, Integer> styles = new HashMap();

    public FontChooser(Frame owner, Language language) {
        super(owner);
        this.language = language;
        language.addLanguageListener(this.listener);
        this.initialize();
    }

    public FontChooser(Dialog owner, Language language) {
        super(owner);
        this.language = language;
        language.addLanguageListener(this.listener);
        this.initialize();
    }

    private void initialize() {
        Insets insets4444;
        this.refreshLanguage();
        this.setSize(400, 350);
        this.setLocationRelativeTo(this.getOwner());
        new TextComponentClipboardMenu(this.selectedNameTextField, this.language);
        new TextComponentClipboardMenu(this.selectedStyleTextField, this.language);
        new TextComponentClipboardMenu(this.selectedSizeTextField, this.language);
        new TextComponentClipboardMenu(this.sampleTextField, this.language);
        JPanel contentPane = new JPanel();
        contentPane.setBorder(new EmptyBorder(10, 10, 10, 10));
        contentPane.setLayout(new GridBagLayout());
        this.setContentPane(contentPane);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.insets = insets4444 = new Insets(4, 4, 4, 4);
        constraints.fill = 1;
        constraints.weightx = 1.0;
        constraints.weighty = 1.0;
        constraints.gridx = 0;
        constraints.gridy = 0;
        this.fontNamesList.setBorder(new EmptyBorder(1, 1, 1, 4));
        JScrollPane scrollPane = new JScrollPane(this.fontNamesList);
        contentPane.add((Component)scrollPane, constraints);
        constraints.gridx = 1;
        constraints.gridy = 0;
        scrollPane = new JScrollPane(this.fontStylesList);
        this.fontStylesList.setBorder(new EmptyBorder(1, 1, 1, 4));
        contentPane.add((Component)scrollPane, constraints);
        constraints.gridx = 2;
        constraints.gridy = 0;
        scrollPane = new JScrollPane(this.fontSizesList);
        this.fontSizesList.setBorder(new EmptyBorder(1, 1, 1, 4));
        contentPane.add((Component)scrollPane, constraints);
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.weighty = 0.0;
        this.selectedNameTextField.setEditable(false);
        contentPane.add((Component)this.selectedNameTextField, constraints);
        constraints.gridx = 1;
        constraints.gridy = 1;
        this.selectedStyleTextField.setEditable(false);
        contentPane.add((Component)this.selectedStyleTextField, constraints);
        constraints.gridx = 2;
        constraints.gridy = 1;
        contentPane.add((Component)this.selectedSizeTextField, constraints);
        constraints.gridx = 0;
        constraints.gridy = 3;
        contentPane.add((Component)this.sampleLabel, constraints);
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.gridwidth = 3;
        constraints.weighty = 1.0;
        this.sampleTextField.setText("aAbByYzZ");
        contentPane.add((Component)this.sampleTextField, constraints);
        JPanel buttonsPanel = new JPanel(new GridBagLayout());
        GridBagConstraints panelConstraints = new GridBagConstraints();
        panelConstraints.insets = insets4444;
        panelConstraints.weighty = 1.0;
        panelConstraints.anchor = 13;
        panelConstraints.gridx = 0;
        panelConstraints.gridy = 0;
        panelConstraints.weightx = 1.0;
        buttonsPanel.add((Component)this.okButton, panelConstraints);
        panelConstraints.gridx = 1;
        panelConstraints.gridy = 0;
        panelConstraints.weightx = 0.0;
        buttonsPanel.add((Component)this.cancelButton, panelConstraints);
        constraints.gridx = 0;
        constraints.gridy = 6;
        constraints.weighty = 0.0;
        contentPane.add((Component)buttonsPanel, constraints);
        this.okButton.addActionListener(this.listener);
        this.cancelButton.addActionListener(this.listener);
        this.fontNamesList.addListSelectionListener(this.listener);
        this.fontStylesList.addListSelectionListener(this.listener);
        this.fontSizesList.addListSelectionListener(this.listener);
        this.selectedSizeTextField.addActionListener(this.listener);
        GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        String[] names = environment.getAvailableFontFamilyNames();
        String[] sizes = new String[]{"8", "9", "10", "11", "12", "14", "16", "18", "22", "26", "30", "36", "48", "64"};
        this.styles.put(this.language.getString("Options.display.fontChooser.plain"), new Integer(0));
        this.styles.put(this.language.getString("Options.display.fontChooser.italic"), new Integer(2));
        this.styles.put(this.language.getString("Options.display.fontChooser.bold"), new Integer(1));
        this.styles.put(this.language.getString("Options.display.fontChooser.boldItalic"), new Integer(3));
        for (String element : names) {
            this.fontNamesModel.addElement(element);
        }
        for (String element : sizes) {
            this.fontSizesModel.addElement(element);
        }
        this.fontStylesModel = new TranslatableListModel(this.language);
        this.fontStylesList.setModel(this.fontStylesModel);
        ArrayList<String> styleKeysList = new ArrayList<String>(this.styles.keySet());
        Collections.reverse(styleKeysList);
        Iterator<String> styleKeys = styleKeysList.iterator();
        while (styleKeys.hasNext()) {
            this.fontStylesModel.addElement(styleKeys.next());
        }
        this.fontNamesList.setSelectedIndex(0);
        this.fontSizesList.setSelectedIndex(0);
        this.fontStylesList.setSelectedIndex(0);
    }

    private void cancelButtonPressed() {
        this.selectedFont = null;
        this.dispose();
    }

    private void okButtonPressed() {
        this.dispose();
    }

    private void fontNameValueChanged() {
        if (this.fontNamesList.getSelectedIndex() != -1) {
            this.selectedName = this.fontNamesList.getSelectedValue().toString();
            this.selectedNameTextField.setText(this.selectedName);
            this.refreshFont();
        }
    }

    private void refreshFont() {
        if (this.selectedName != null && this.selectedSize != null && this.selectedStyle != null) {
            this.selectedFont = new Font(this.selectedName, (int)this.selectedStyle, this.selectedSize);
            this.sampleTextField.setFont(this.selectedFont);
        }
    }

    private void fontStyleValueChanged() {
        int selectedIndex = this.fontStylesList.getSelectedIndex();
        if (selectedIndex != -1) {
            String styleString = this.fontStylesModel.getElementAt(selectedIndex).toString();
            String styleKey = this.fontStylesModel.getKeyAt(selectedIndex);
            this.selectedStyleTextField.setText(styleString);
            this.selectedStyle = this.styles.get(styleKey);
            this.refreshFont();
        }
    }

    private void fontSizeValueChanged() {
        if (this.fontSizesList.getSelectedIndex() != -1) {
            this.selectedSize = new Integer(this.fontSizesList.getSelectedValue().toString());
            this.selectedSizeTextField.setText(this.selectedSize.toString());
            this.refreshFont();
        }
    }

    public Font getSelectedFont() {
        return this.selectedFont;
    }

    public void setSelectedFont(Font font) {
        this.selectedFont = font;
        String familyName = font.getFamily();
        if (this.fontNamesModel.contains(familyName)) {
            this.fontNamesList.setSelectedValue(familyName, true);
        }
        this.selectedSize = new Integer(font.getSize());
        if (this.fontSizesModel.contains(this.selectedSize)) {
            this.fontSizesList.setSelectedValue(this.selectedSize, true);
        } else {
            this.selectedSizeTextField.setText(this.selectedSize.toString());
            this.sizeTyped();
        }
        int stylePos = -1;
        Integer style = new Integer(font.getStyle());
        Iterator<Map.Entry<String, Integer>> styleEntries = this.styles.entrySet().iterator();
        while (styleEntries.hasNext() && stylePos == -1) {
            Map.Entry<String, Integer> entry = styleEntries.next();
            if (!entry.getValue().equals(style)) continue;
            stylePos = this.fontStylesModel.indexOfKey(entry.getKey());
        }
        this.fontStylesList.setSelectedIndex(stylePos);
    }

    private void sizeTyped() {
        String size = this.selectedSizeTextField.getText();
        try {
            this.selectedSize = new Integer(size);
            if (this.fontSizesModel.contains(size)) {
                this.fontSizesList.setSelectedValue(size, true);
            } else {
                this.fontSizesList.clearSelection();
            }
            this.refreshFont();
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
    }

    private void refreshLanguage() {
        this.setTitle(this.language.getString("Options.display.fontChooser.title"));
        this.sampleLabel.setText(this.language.getString("Options.display.fontChooser.sample"));
        this.okButton.setText(this.language.getString("Common.ok"));
        this.cancelButton.setText(this.language.getString("Common.cancel"));
    }

    private class Listener
    implements ActionListener,
    ListSelectionListener,
    LanguageListener {
        public void actionPerformed(ActionEvent e) {
            if (e.getSource() == FontChooser.this.okButton) {
                FontChooser.this.okButtonPressed();
            }
            if (e.getSource() == FontChooser.this.cancelButton) {
                FontChooser.this.cancelButtonPressed();
            }
            if (e.getSource() == FontChooser.this.selectedSizeTextField) {
                FontChooser.this.sizeTyped();
            }
        }

        public void valueChanged(ListSelectionEvent e) {
            if (!e.getValueIsAdjusting()) {
                if (e.getSource() == FontChooser.this.fontNamesList) {
                    FontChooser.this.fontNameValueChanged();
                }
                if (e.getSource() == FontChooser.this.fontStylesList) {
                    FontChooser.this.fontStyleValueChanged();
                }
                if (e.getSource() == FontChooser.this.fontSizesList) {
                    FontChooser.this.fontSizeValueChanged();
                }
            }
        }

        public void languageChanged(LanguageEvent event) {
            FontChooser.this.refreshLanguage();
        }
    }
}

