/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui;

import frost.util.gui.GlassPane;
import java.awt.Component;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;

public abstract class FrostSwingWorker {
    private static final Logger logger = Logger.getLogger(FrostSwingWorker.class.getName());
    private ThreadVar threadVar;
    private GlassPane glassPane;
    private Component aComponent;

    public FrostSwingWorker(Component aComponent) {
        this.setAComponent(aComponent);
        final Runnable doFinished = new Runnable(){

            public void run() {
                FrostSwingWorker.this.finished();
            }
        };
        Runnable doConstruct = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    FrostSwingWorker.this.construct();
                }
                finally {
                    FrostSwingWorker.this.threadVar.clear();
                }
                SwingUtilities.invokeLater(doFinished);
            }
        };
        Thread t = new Thread(Thread.currentThread().getThreadGroup(), doConstruct);
        this.threadVar = new ThreadVar(t);
    }

    private void activateGlassPane() {
        GlassPane aPane = GlassPane.mount(this.getAComponent(), true);
        this.setGlassPane(aPane);
        if (this.getGlassPane() != null) {
            this.getGlassPane().setVisible(true);
        }
    }

    private void construct() {
        this.activateGlassPane();
        try {
            this.doNonUILogic();
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    private void deactivateGlassPane() {
        if (this.getGlassPane() != null) {
            this.getGlassPane().setVisible(false);
        }
    }

    protected abstract void doNonUILogic() throws RuntimeException;

    protected abstract void doUIUpdateLogic() throws RuntimeException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finished() {
        try {
            this.deactivateGlassPane();
            this.doUIUpdateLogic();
        }
        catch (RuntimeException e) {
            logger.log(Level.SEVERE, "SwingWorker error", e);
        }
        finally {
            if (this.getAComponent() != null) {
                this.getAComponent().requestFocus();
            }
        }
    }

    protected Component getAComponent() {
        return this.aComponent;
    }

    protected GlassPane getGlassPane() {
        return this.glassPane;
    }

    public void interrupt() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.interrupt();
        }
        this.threadVar.clear();
    }

    protected void setAComponent(Component newAComponent) {
        this.aComponent = newAComponent;
    }

    protected void setGlassPane(GlassPane newGlassPane) {
        this.glassPane = newGlassPane;
    }

    public void start() {
        Thread t = this.threadVar.get();
        if (t != null) {
            t.start();
        }
    }

    private static class ThreadVar {
        private Thread thread;

        ThreadVar(Thread t) {
            this.thread = t;
        }

        synchronized Thread get() {
            return this.thread;
        }

        synchronized void clear() {
            this.thread = null;
        }
    }
}

