/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui;

import frost.util.gui.translation.Language;
import java.util.HashSet;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public class StartupMessage {
    protected MessageType messageType;
    protected String title;
    protected String text;
    protected int dialogType;
    protected boolean allowIgnore;
    private static HashSet<MessageType> ignoredMessageTypes = new HashSet();

    public StartupMessage(MessageType newMessageType, String newTitle, String newText, int newDialogType, boolean newAllowIgnore) {
        this.messageType = newMessageType;
        this.title = newTitle;
        this.text = newText;
        this.dialogType = newDialogType;
        this.allowIgnore = newAllowIgnore;
    }

    public void display(JFrame parent) {
        if (StartupMessage.isMessageTypeIgnored(this.getMessageType())) {
            return;
        }
        if (this.isAllowIgnore()) {
            Language language = Language.getInstance();
            String okStr = language.getString("Common.ok");
            String ignoreStr = language.getString("Common.ignoreMessagesOfThisType");
            Object[] options = new Object[]{okStr, ignoreStr};
            int answer = JOptionPane.showOptionDialog(parent, this.getText(), this.getTitle(), -1, this.getDialogType(), null, options, options[0]);
            if (answer == 1) {
                StartupMessage.setMessageTypeIgnored(this.getMessageType());
            }
        } else {
            JOptionPane.showMessageDialog(parent, this.getText(), this.getTitle(), this.getDialogType());
        }
    }

    public boolean isAllowIgnore() {
        return this.allowIgnore;
    }

    public int getDialogType() {
        return this.dialogType;
    }

    public MessageType getMessageType() {
        return this.messageType;
    }

    public String getText() {
        return this.text;
    }

    public String getTitle() {
        return this.title;
    }

    public static boolean isMessageTypeIgnored(MessageType msgType) {
        return ignoredMessageTypes.contains((Object)msgType);
    }

    public static void setMessageTypeIgnored(MessageType msgType) {
        ignoredMessageTypes.add(msgType);
    }

    public static void cleanup() {
        ignoredMessageTypes.clear();
        ignoredMessageTypes = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum MessageType {
        SharedFileNotFound,
        SharedFileSizeChanged,
        SharedFileLastModifiedChanged,
        UploadFileNotFound,
        UploadFileSizeChanged,
        BoardsWithObsoleteKeysFound;

    }
}

