/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui.search;

import frost.util.gui.search.FindAction;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.text.Position;
import javax.swing.tree.TreePath;

public class TreeFindAction
extends FindAction {
    protected boolean changed(JComponent comp2, String searchString, Position.Bias bias) {
        TreePath path;
        int startingRow;
        JTree tree = (JTree)comp2;
        boolean startingFromSelection = true;
        int max = tree.getRowCount();
        int increment = 0;
        if (bias != null) {
            int n = increment = bias == Position.Bias.Forward ? 1 : -1;
        }
        if ((startingRow = (tree.getLeadSelectionRow() + increment + max) % max) < 0 || startingRow >= tree.getRowCount()) {
            startingFromSelection = false;
            startingRow = 0;
        }
        if ((path = this.getNextMatch(tree, searchString, startingRow, bias)) != null) {
            this.changeSelection(tree, path);
            return true;
        }
        if (startingFromSelection && (path = this.getNextMatch(tree, searchString, 0, bias)) != null) {
            this.changeSelection(tree, path);
            return true;
        }
        return false;
    }

    protected void changeSelection(JTree tree, TreePath path) {
        if (this.controlDown) {
            tree.addSelectionPath(path);
        } else {
            tree.setSelectionPath(path);
        }
        tree.scrollPathToVisible(path);
    }

    public TreePath getNextMatch(JTree tree, String prefix, int startingRow, Position.Bias bias) {
        int max = tree.getRowCount();
        if (prefix == null) {
            throw new IllegalArgumentException();
        }
        if (startingRow < 0 || startingRow >= max) {
            throw new IllegalArgumentException();
        }
        if (this.ignoreCase) {
            prefix = prefix.toUpperCase();
        }
        int increment = bias == null || bias == Position.Bias.Forward ? 1 : -1;
        int row = startingRow;
        do {
            TreePath path = tree.getPathForRow(row);
            String text = tree.convertValueToText(path.getLastPathComponent(), tree.isRowSelected(row), tree.isExpanded(row), true, row, false);
            if (this.ignoreCase) {
                text = text.toUpperCase();
            }
            if (text.indexOf(prefix) <= -1) continue;
            return path;
        } while ((row = (row + increment + max) % max) != startingRow);
        return null;
    }
}

