/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui.textpane;

import frost.fcp.FreenetKeys;
import frost.util.gui.SmileyCache;
import frost.util.gui.textpane.Decoder;
import frost.util.gui.textpane.LinkEditorKit;
import frost.util.gui.textpane.MessageElement;
import frost.util.gui.textpane.MessageTypes;
import frost.util.gui.textpane.Smileys;
import java.awt.Color;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledEditorKit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageDecoder
extends Decoder
implements Smileys,
MessageTypes {
    private final Logger logger = Logger.getLogger(MessageDecoder.class.getName());
    private boolean smileys = true;
    private boolean freenetKeys = true;
    private final List<String> hyperlinkedKeys = new LinkedList<String>();
    private final TreeSet<MessageElement> elements = new TreeSet();

    @Override
    public void decode(String message, JEditorPane parent) {
        this.elements.clear();
        this.hyperlinkedKeys.clear();
        if (this.smileys) {
            if (!(parent.getEditorKit() instanceof StyledEditorKit)) {
                parent.setEditorKit(new StyledEditorKit());
            }
            this.processSmileys(message, this.elements);
        }
        if (this.freenetKeys) {
            if (!(parent.getEditorKit() instanceof LinkEditorKit)) {
                parent.setEditorKit(new LinkEditorKit());
            }
            this.processFreenetKeys(message, this.elements);
        }
        DefaultStyledDocument doc = new DefaultStyledDocument();
        int begin = 0;
        try {
            for (MessageElement me : this.elements) {
                String s = message.substring(me.getPosition(), me.getPosition() + me.getLength());
                SimpleAttributeSet at = new SimpleAttributeSet();
                if (me.getPosition() <= begin) continue;
                doc.insertString(doc.getLength(), message.substring(begin, me.getPosition()), new SimpleAttributeSet());
                if (me.getType() == 1) {
                    StyleConstants.setIcon(at, this.getSmiley(me.getTypeIndex()));
                } else if (me.getType() == 0) {
                    at.addAttribute(LinkEditorKit.LINK, s);
                    at.addAttribute(StyleConstants.Underline, Boolean.TRUE);
                    at.addAttribute(StyleConstants.Foreground, Color.BLUE);
                }
                doc.insertString(doc.getLength(), s, at);
                begin = me.getPosition() + me.getLength();
            }
            doc.insertString(doc.getLength(), message.substring(begin), new SimpleAttributeSet());
        }
        catch (BadLocationException e) {
            this.logger.log(Level.SEVERE, "Excpetion during construction of message", e);
        }
        parent.setDocument(doc);
    }

    public void setFreenetKeysDecode(boolean value) {
        this.freenetKeys = value;
    }

    public boolean getFreenetKeysDecode() {
        return this.freenetKeys;
    }

    public void setSmileyDecode(boolean value) {
        this.smileys = value;
    }

    public boolean getSmileyDecode() {
        return this.smileys;
    }

    private void processFreenetKeys(String message, TreeSet<MessageElement> targetElements) {
        String[] FREENETKEYS = FreenetKeys.getFreenetKeyTypes();
        try {
            for (int i = 0; i < FREENETKEYS.length; ++i) {
                int pos;
                int offset = 0;
                String testMessage = new String(message);
                while ((pos = testMessage.indexOf(FREENETKEYS[i])) > -1) {
                    int length = testMessage.indexOf("\n", pos);
                    length = length < 0 ? testMessage.length() - pos : (length -= pos);
                    String aFileLink = testMessage.substring(pos, pos + length);
                    if (FreenetKeys.isValidKey(aFileLink)) {
                        targetElements.add(new MessageElement(new Integer(pos + offset), 0, i, length));
                        if (Character.isLetterOrDigit(testMessage.charAt(pos + length - 1)) && aFileLink.indexOf("/") > 0) {
                            this.hyperlinkedKeys.add(aFileLink);
                        }
                    }
                    offset += pos + length;
                    testMessage = testMessage.substring(pos + length);
                }
            }
        }
        catch (Throwable e) {
            e.printStackTrace();
            this.logger.log(Level.SEVERE, "Excption in processFreenetKeys", e);
        }
    }

    private void processSmileys(String message, TreeSet<MessageElement> targetElements) {
        for (int i = 0; i < SMILEYS.length; ++i) {
            for (int j = 0; j < SMILEYS[i].length; ++j) {
                int pos;
                int offset = 0;
                String testMessage = new String(message);
                while ((pos = testMessage.indexOf(SMILEYS[i][j])) > -1) {
                    if (this.isSmiley(pos, testMessage, SMILEYS[i][j])) {
                        targetElements.add(new MessageElement(new Integer(pos + offset), 1, i, SMILEYS[i][j].length()));
                    }
                    offset += pos + SMILEYS[i][j].length();
                    testMessage = testMessage.substring(pos + SMILEYS[i][j].length());
                }
            }
        }
    }

    private boolean isSmiley(int pos, String message, String smiley) {
        char c;
        boolean eol;
        boolean bol = pos == 0;
        boolean bl = eol = message.length() == smiley.length() + pos;
        if (!bol) {
            c = message.charAt(pos - 1);
            bol = Character.isWhitespace(c);
        }
        if (!eol) {
            c = message.charAt(pos + smiley.length());
            eol = Character.isWhitespace(c);
        }
        return bol && eol;
    }

    private Icon getSmiley(int i) {
        return SmileyCache.getCachedSmiley(i);
    }

    public List<String> getHyperlinkedKeys() {
        return this.hyperlinkedKeys;
    }
}

