/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui.translation;

import frost.MainFrame;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FrostResourceBundleReader {
    private static final Logger logger = Logger.getLogger(FrostResourceBundleReader.class.getName());

    public static Map<String, String> loadBundle(String jarResource) {
        InputStream input = MainFrame.class.getResourceAsStream(jarResource);
        if (input == null) {
            logger.severe("Resource not found in jar file: " + jarResource);
            return new HashMap<String, String>();
        }
        return FrostResourceBundleReader.loadBundle(input, jarResource);
    }

    public static Map<String, String> loadBundle(File fileResource) {
        FileInputStream input;
        try {
            input = new FileInputStream(fileResource);
        }
        catch (FileNotFoundException e) {
            logger.log(Level.SEVERE, "Could not open properties file: " + fileResource, e);
            return new HashMap<String, String>();
        }
        return FrostResourceBundleReader.loadBundle(input, fileResource.getPath());
    }

    private static Map<String, String> loadBundle(InputStream inStream, String resourceName) {
        HashMap<String, String> bundle = new HashMap<String, String>();
        try {
            String line;
            BufferedReader rdr = new BufferedReader(new InputStreamReader(inStream, "UTF-8"));
            String wholeLine = null;
            while ((line = rdr.readLine()) != null) {
                if (line.startsWith("#")) continue;
                if (FrostResourceBundleReader.isContinueLine(line)) {
                    line = line.substring(0, line.length() - 1);
                    if (wholeLine == null) {
                        wholeLine = line;
                        continue;
                    }
                    wholeLine = wholeLine + FrostResourceBundleReader.removeLeadingWhitespaces(line);
                    continue;
                }
                wholeLine = wholeLine != null ? wholeLine + FrostResourceBundleReader.removeLeadingWhitespaces(line) : line;
                line = wholeLine;
                wholeLine = null;
                if (line.length() == 0) continue;
                int pos = line.indexOf(61);
                if (pos < 1) {
                    logger.severe("Invalid line in " + resourceName + ": " + line);
                    continue;
                }
                String key = line.substring(0, pos).trim();
                String value = line.substring(pos + 1);
                if (key.length() == 0) {
                    logger.severe("Empty key in " + resourceName + ": " + line);
                    continue;
                }
                value = FrostResourceBundleReader.loadConvert(value);
                bundle.put(key, value);
            }
        }
        catch (Throwable t) {
            logger.log(Level.SEVERE, "Error reading resource: " + resourceName, t);
            return bundle;
        }
        return bundle;
    }

    private static String removeLeadingWhitespaces(String str) {
        int x;
        for (x = 0; x < str.length() - 1 && Character.isWhitespace(str.charAt(x)); ++x) {
        }
        return str.substring(x);
    }

    private static boolean isContinueLine(String line) {
        int backslashCount = 0;
        int index = line.length() - 1;
        while (index >= 0 && line.charAt(index--) == '\\') {
            ++backslashCount;
        }
        return backslashCount % 2 == 1;
    }

    private static String loadConvert(String str) {
        int len = str.length();
        StringBuilder result = new StringBuilder(len);
        int x = 0;
        while (x < len) {
            int aChar;
            if ((aChar = str.charAt(x++)) == 92) {
                if ((aChar = str.charAt(x++)) == 116) {
                    aChar = 9;
                } else if (aChar == 114) {
                    aChar = 13;
                } else if (aChar == 110) {
                    aChar = 10;
                } else if (aChar == 102) {
                    aChar = 12;
                }
                result.append((char)aChar);
                continue;
            }
            result.append((char)aChar);
        }
        return result.toString();
    }
}

