/*
 * Decompiled with CFR 0.152.
 */
package frost.util.gui.translation;

import frost.util.gui.translation.Language;
import frost.util.gui.translation.LanguageEvent;
import frost.util.gui.translation.LanguageListener;
import javax.swing.DefaultListModel;

public class TranslatableListModel
extends DefaultListModel
implements LanguageListener {
    private Language language = null;

    public TranslatableListModel(Language language) {
        this.language = language;
        language.addLanguageListener(this);
    }

    public void languageChanged(LanguageEvent event) {
        this.fireContentsChanged(this, 0, this.getSize() - 1);
    }

    public Object getElementAt(int index) {
        String key = super.getElementAt(index).toString();
        return this.language.getString(key);
    }

    public String getKeyAt(int selectedIndex) {
        return super.getElementAt(selectedIndex).toString();
    }

    public int indexOfKey(Object key) {
        return super.indexOf(key);
    }

    public int indexOf(Object elem) {
        int position = -1;
        for (int i = 0; i < this.getSize() - 1 || position != -1; ++i) {
            String localizedValue = this.language.getString(this.getKeyAt(i));
            if (!elem.equals(localizedValue)) continue;
            position = i;
        }
        return super.indexOf(elem);
    }
}

