/*
 * Decompiled with CFR 0.152.
 */
package mseries.Calendar;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Font;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import mseries.Calendar.MDateChanger;
import mseries.Calendar.MonthPopup;
import mseries.ui.MChangeEvent;
import mseries.ui.MChangeListener;
import mseries.ui.MDateSpinnerModel;
import mseries.ui.RollOverButton;

public class MButtonChanger
extends JPanel
implements MDateChanger {
    private JLabel date;
    private RollOverButton down;
    private RollOverButton up;
    private DateFormat df = new SimpleDateFormat("MMMMM yyyy");
    protected MDateSpinnerModel model;
    private static final int DOWN = -1;
    private static final int UP = 1;
    private AbstractAction upAction = new UpDownAction(1, 2);
    private AbstractAction downAction = new UpDownAction(-1, 2);
    private Calendar maxC = Calendar.getInstance();
    private Calendar minC = Calendar.getInstance();
    private int minMonth;
    private int minYear;
    protected Vector listeners = new Vector();
    int offset;
    MonthPopup mp = new MonthPopup();

    public MButtonChanger() {
        this.setLayout(new BorderLayout());
        this.down = new RollOverButton(7);
        this.down.addActionListener(this.downAction);
        this.up = new RollOverButton(3);
        this.up.addActionListener(this.upAction);
        this.add((Component)this.down, "West");
        this.add((Component)this.up, "East");
        this.minC.set(1900, 0, 1);
        this.minMonth = this.minC.get(2);
        this.minYear = this.minC.get(1);
        this.maxC.set(2037, 11, 31);
        this.date = new JLabel("Error");
        Font f = this.date.getFont();
        String name = f.getFontName();
        int style = f.isItalic() ? 3 : 1;
        int size = f.getSize();
        this.date.setFont(new Font(name, style, size));
        this.date.setHorizontalAlignment(0);
        this.mp.pack();
        this.date.addMouseListener(new MouseAdapter(){
            int x;
            int y;
            int d;

            public void mousePressed(MouseEvent e) {
                this.x = (MButtonChanger.this.getWidth() - MButtonChanger.this.mp.getWidth()) / 2;
                this.x += MButtonChanger.this.getLocationOnScreen().x;
                this.y = MButtonChanger.this.getLocationOnScreen().y;
                this.d = MButtonChanger.this.mp.getHeight() / 7;
                this.d *= 3;
                this.y = this.y - this.d > 0 ? this.y - this.d : 0;
                MButtonChanger.this.mp.setLocationOnScreen(this.x, this.y);
                MButtonChanger.this.mp.setVisible(true);
                MButtonChanger.this.mp.setValue((Date)MButtonChanger.this.model.getValue());
            }

            public void mouseReleased(MouseEvent e) {
                Object x = MButtonChanger.this.mp.getValue();
                if (x != null) {
                    Calendar modelCalendar = Calendar.getInstance();
                    modelCalendar.setTime((Date)MButtonChanger.this.model.getValue());
                    Calendar newCalendar = Calendar.getInstance();
                    newCalendar.setTime((Date)x);
                    int dayOfMonth = Math.min(newCalendar.getActualMaximum(5), modelCalendar.get(5));
                    newCalendar.set(5, dayOfMonth);
                    MButtonChanger.this.model.setValue(newCalendar.getTime());
                    MButtonChanger.this.setDisplay(newCalendar.getTime());
                    MButtonChanger.this.notifyListeners(0);
                }
                MButtonChanger.this.mp.setVisible(false);
                MButtonChanger.this.mp.dispose();
            }
        });
        this.date.addMouseMotionListener(new MouseMotionAdapter(){
            Point p;

            public void mouseDragged(MouseEvent e) {
                this.p = e.getPoint();
                MButtonChanger.this.mp.setSelectedPoint(SwingUtilities.convertPoint(MButtonChanger.this, this.p, MButtonChanger.this.mp));
            }
        });
        this.add((Component)this.date, "Center");
        this.model = new MDateSpinnerModel();
        this.installKeyboardActions();
    }

    private void installKeyboardActions() {
        this.registerKeyboardAction(new UpDownAction(1, 2), KeyStroke.getKeyStroke(33, 0), 2);
        this.registerKeyboardAction(new UpDownAction(-1, 2), KeyStroke.getKeyStroke(34, 0), 2);
        this.registerKeyboardAction(new UpDownAction(1, 1), KeyStroke.getKeyStroke(33, 1), 2);
        this.registerKeyboardAction(new UpDownAction(-1, 1), KeyStroke.getKeyStroke(34, 1), 2);
    }

    private void setDisplay(Date value) {
        this.date.setText(this.df.format(value));
    }

    public void setMinimum(Date min) {
        this.minC.setTime(min);
        this.minYear = this.minC.get(1);
        this.minMonth = this.minC.get(2);
        this.model.setMinimum(min);
        this.setValue(min);
    }

    public void setMaximum(Date max) {
        this.maxC.setTime(max);
        this.model.setMaximum(max);
        this.setValue(max);
    }

    public void setValue(Date newVal) {
        Calendar valC = Calendar.getInstance();
        valC.setTime(newVal);
        this.model.setValue(newVal);
        this.mp.setValue(newVal);
        this.setDisplay(newVal);
    }

    public int getValue() {
        Calendar valC = Calendar.getInstance();
        valC.setTime((Date)this.model.getValue());
        int y = valC.get(1);
        int m = valC.get(2);
        int newValue = (y - this.minYear) * 12 + m - this.minMonth;
        return newValue;
    }

    public void addMChangeListener(MChangeListener l) {
        this.listeners.addElement(l);
    }

    public void removeMChangeListener(MChangeListener l) {
        this.listeners.removeElement(l);
    }

    public boolean hasFocus() {
        return this.up.hasFocus() || this.down.hasFocus();
    }

    public void addFListener(FocusListener l) {
        this.up.addFocusListener(l);
        this.down.addFocusListener(l);
    }

    public void removeFListener(FocusListener l) {
        this.up.removeFocusListener(l);
        this.down.removeFocusListener(l);
    }

    private void notifyListeners(int type) {
        Vector list = (Vector)this.listeners.clone();
        for (int i = 0; i < list.size(); ++i) {
            MChangeListener l = (MChangeListener)this.listeners.elementAt(i);
            l.valueChanged(new MChangeEvent(this, new Integer(this.getValue()), type));
        }
    }

    class UpDownAction
    extends AbstractAction {
        int direction;
        int step;

        public UpDownAction(int direction, int step) {
            this.step = step;
            this.direction = direction;
        }

        public void actionPerformed(ActionEvent evt) {
            MButtonChanger.this.model.setStep(this.step);
            Object val = this.direction == 1 ? MButtonChanger.this.model.getNextValue() : MButtonChanger.this.model.getPreviousValue();
            MButtonChanger.this.setValue((Date)val);
            MButtonChanger.this.notifyListeners(0);
        }
    }
}

