/*
 * Decompiled with CFR 0.152.
 */
package mseries.plaf.Aqua;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.UIManager;

public class AquaArrowButton
extends JButton {
    int direction;

    public AquaArrowButton(int dir) {
        this.setDirection(dir);
        this.setRequestFocusEnabled(false);
        this.setIcon(new Triangle(dir, 4));
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int dir) {
        this.direction = dir;
    }

    class Triangle
    implements Icon {
        int size = 6;
        int dir = 1;

        public Triangle(int dir, int size) {
            this.dir = dir;
            this.size = size;
        }

        public void paintIcon(Component c, Graphics g, int x, int y) {
            Color oldColor = g.getColor();
            int j = 0;
            this.size = Math.max(this.size, 2);
            int mid = this.size / 2;
            g.translate(x, y);
            g.setColor(UIManager.getColor("textText"));
            switch (this.dir) {
                case 1: {
                    for (int i = 0; i < this.size; ++i) {
                        g.drawLine(mid - i, i, mid + i, i);
                    }
                    break;
                }
                case 5: {
                    j = 0;
                    for (int i = this.size - 1; i >= 0; --i) {
                        g.drawLine(mid - i, j, mid + i, j);
                        ++j;
                    }
                    break;
                }
                case 7: {
                    for (int i = 0; i < this.size; ++i) {
                        g.drawLine(i, mid - i, i, mid + i);
                    }
                    break;
                }
                case 3: {
                    j = 0;
                    for (int i = this.size - 1; i >= 0; --i) {
                        g.drawLine(j, mid - i, j, mid + i);
                        ++j;
                    }
                    break;
                }
            }
            g.translate(-x, -y);
            g.setColor(oldColor);
        }

        public int getIconWidth() {
            return this.size;
        }

        public int getIconHeight() {
            return this.size;
        }
    }
}

