/*
 * Decompiled with CFR 0.152.
 */
package mseries.ui;

import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JFormattedTextField;
import javax.swing.text.DateFormatter;
import mseries.Calendar.MDateSelector;
import mseries.Calendar.MDateSelectorConstraints;
import mseries.Calendar.MDefaultPullDownConstraints;
import mseries.ui.MDateFormat;
import mseries.ui.MDateFormatter;

public class MDateField
extends JFormattedTextField {
    private Date minDate = null;
    private Date maxDate = null;
    public MDateFormat df = MDateFormatter.getInstance();
    ResourceBundle rb;
    MouseListener mouseListener;
    MDateSelectorConstraints c = new MDefaultPullDownConstraints();
    private boolean hasPopup = false;
    private int h;
    private int m;
    private int s;
    private int ms;

    public MDateField(DateFormat df) {
        super(new DateFormatter(df));
        this.init();
    }

    public MDateField(int text) {
        this.init();
    }

    public MDateField() {
        super(new Date());
        this.init();
    }

    protected void init() {
        super.setValue(new Date());
        try {
            DateFormat df = DateFormat.getDateInstance(3, new Locale("en", "GB"));
            this.maxDate = df.parse("31/12/2037");
            this.minDate = df.parse("1/1/1970");
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    public void setDateFormatter(MDateFormat df) {
    }

    public JFormattedTextField.AbstractFormatter getDateFormatter(Object x) {
        return this.getFormatter();
    }

    public MDateFormat getDateFormatter() {
        return this.df;
    }

    public boolean hasPopup() {
        return this.hasPopup;
    }

    public void setConstraints(MDateSelectorConstraints c) {
        this.c = c;
    }

    public MDateSelectorConstraints getConstraints() {
        return this.c;
    }

    public void setPopup(boolean hasPopup) {
        this.pSetPopup(hasPopup);
    }

    private void pSetPopup(boolean hasPopup) {
        if (hasPopup && this.hasPopup) {
            return;
        }
        if (!hasPopup && !this.hasPopup) {
            return;
        }
        if (!hasPopup && this.hasPopup) {
            this.removeMouseListener(this.mouseListener);
            this.hasPopup = false;
        }
        this.mouseListener = new MouseAdapter(){

            public void mouseReleased(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.doPopup(e.getPoint());
                }
            }

            public void mousePressed(MouseEvent e) {
                if (e.isPopupTrigger()) {
                    this.doPopup(e.getPoint());
                }
            }

            private void doPopup(Point p) {
                MDateSelector popup = new MDateSelector(MDateField.this.minDate, MDateField.this.maxDate);
                popup.setConstraints(MDateField.this.c);
                p.x += MDateField.this.getBounds(null).x;
                p.y += MDateField.this.getBounds(null).y;
                popup.show(MDateField.this.getParent(), p, MDateField.this.getValue(null));
                MDateField.this.setValue(popup.getValue());
                popup = null;
                MDateField.this.requestFocus();
            }
        };
        this.addMouseListener(this.mouseListener);
        this.hasPopup = hasPopup;
    }

    public void setMinimum(Date date) {
        this.minDate = date;
    }

    public void setMaximum(Date date) {
        this.maxDate = date;
    }

    public Date getMinimum() {
        return this.minDate;
    }

    public Date getMaximum() {
        return this.maxDate;
    }

    public Date getValue(Date defaultValue) {
        String v = this.getText();
        JFormattedTextField.AbstractFormatter f = this.getFormatter();
        Date date = null;
        try {
            date = (Date)f.stringToValue(v);
            Calendar cal = Calendar.getInstance();
            cal.setTime(date);
            cal.set(11, this.h);
            cal.set(12, this.m);
            cal.set(13, this.s);
            cal.set(14, this.ms);
            return cal.getTime();
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public void setValue(Date date) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
            this.h = cal.get(11);
            this.m = cal.get(12);
            this.s = cal.get(13);
            this.ms = cal.get(14);
        }
        super.setValue(date);
    }
}

