/*
 * Decompiled with CFR 0.152.
 */
package freenet;

import freenet.crypt.Digest;
import freenet.support.Fields;
import freenet.support.io.ReadInputStream;
import freenet.support.io.WriteOutputStream;
import freenet.support.sort.ArraySorter;
import freenet.support.sort.QuickSorter;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FieldSet {
    private static Logger logger = Logger.getLogger(FieldSet.class.getName());
    public static final byte HASH_SUBSET = -3;
    public static final byte HASH_EQUALS = -2;
    public static final byte HASH_NEWLINE = -1;
    public static final long MAX_PARSE_SIZE = 524288L;
    protected final Hashtable fields;
    private static final Filter voidF = new VoidFilter();

    public FieldSet() {
        this.fields = new Hashtable();
    }

    public FieldSet(ReadInputStream in) throws IOException {
        this();
        this.parseFields(in);
    }

    protected FieldSet(FieldSet fs) {
        this.fields = fs.fields;
    }

    public String get(String s) {
        Object o = this.fields.get(s);
        if (o == null || !(o instanceof String)) {
            return null;
        }
        String value = (String)this.fields.get(s);
        return value;
    }

    public FieldSet getSet(String s) {
        Object o = this.fields.get(s);
        if (o == null || !(o instanceof FieldSet)) {
            return null;
        }
        return (FieldSet)o;
    }

    public FieldSet makeSet(String s) {
        Object o = this.fields.get(s);
        if (o == null) {
            o = this.newFieldSet();
            this.fields.put(s, o);
        }
        if (!(o instanceof FieldSet)) {
            return null;
        }
        return (FieldSet)o;
    }

    public final Object remove(String s) {
        return this.fields.remove(s);
    }

    public final void clearElements() {
        Enumeration k = this.fields.keys();
        while (k.hasMoreElements()) {
            Object x = k.nextElement();
            Object y = this.fields.get(x);
            if (!(y instanceof FieldSet)) {
                this.fields.remove(x);
                continue;
            }
            ((FieldSet)y).clearElements();
        }
    }

    public final void put(String name, String value) {
        this.fields.put(name, value);
    }

    public final void put(String name, FieldSet fs) {
        this.fields.put(name, fs);
    }

    public final void add(String name, String value) {
        this.put(name, value);
    }

    public final void add(String name, FieldSet fs) {
        this.put(name, fs);
    }

    public final boolean isString(String name) {
        return this.fields.get(name) != null && this.fields.get(name) instanceof String;
    }

    public final boolean isSet(String name) {
        return this.fields.get(name) != null && this.fields.get(name) instanceof FieldSet;
    }

    public final boolean isEmpty() {
        return this.fields.isEmpty();
    }

    public final Enumeration keys() {
        return this.fields.keys();
    }

    public final Enumeration elements() {
        return this.fields.elements();
    }

    public final int size() {
        return this.fields.size();
    }

    public boolean containsKey(String key) {
        return this.fields.containsKey(key);
    }

    public final void clear() {
        this.fields.clear();
    }

    public final void writeFields(WriteOutputStream w) throws IOException {
        this.writeFields(w, "End", '\n', '=', '.');
    }

    public final void writeFields(WriteOutputStream w, String end) throws IOException {
        this.writeFields(w, end, '\n', '=', '.');
    }

    public final void writeFields(WriteOutputStream w, String terminate, char sep, char equal, char subset) throws IOException {
        this.inWriteFields(w, "", sep, '\u0000', equal, subset, false);
        w.writeUTF(terminate, sep);
    }

    public final void writeFields(WriteOutputStream w, String terminate, char sep1, char sep2, char equal, char subset) throws IOException {
        this.inWriteFields(w, "", sep1, sep2, equal, subset, true);
    }

    private void inWriteFields(WriteOutputStream w, String pre, char sep1, char sep2, char equal, char subset, boolean usesep2) throws IOException {
        Enumeration e = this.keys();
        while (e.hasMoreElements()) {
            String name = (String)e.nextElement();
            if (this.isSet(name)) {
                this.getSet(name).inWriteFields(w, pre + name + subset, sep1, sep2, equal, subset, usesep2);
                continue;
            }
            if (!this.isString(name)) continue;
            w.writeUTF(pre);
            w.writeUTF(name, equal);
            if (usesep2) {
                w.writeUTF(this.get(name), sep1, sep2);
                continue;
            }
            w.writeUTF(this.get(name), sep1);
        }
    }

    public final String parseFields(ReadInputStream in) throws IOException {
        return this.parseFields(in, '\n', '\r', '=', '.');
    }

    public final String parseFields(ReadInputStream in, char sep, char equal, char subset) throws IOException {
        return this.privParse(in, sep, '\u0000', equal, subset, false, voidF, voidF);
    }

    public final String parseFields(ReadInputStream in, char sep, char ignore, char equal, char subset) throws IOException {
        return this.privParse(in, sep, ignore, equal, subset, true, voidF, voidF);
    }

    public final String parseFields(ReadInputStream in, char sep, char ignore, char equal, char subset, Filter nameFilter, Filter valueFilter) throws IOException {
        return this.privParse(in, sep, ignore, equal, subset, true, nameFilter, valueFilter);
    }

    public final String parseFields(ReadInputStream in, char sep, char equal, char subset, Filter nameFilter, Filter valueFilter) throws IOException {
        return this.privParse(in, sep, '\u0000', equal, subset, false, nameFilter, valueFilter);
    }

    private String privParse(ReadInputStream in, char sep, char ignore, char equal, char subset, boolean useignore, Filter nameFilter, Filter valueFilter) throws IOException {
        String s;
        block3: {
            long read = 0L;
            do {
                try {
                    s = useignore ? in.readToEOF(sep, ignore) : in.readToEOF(sep);
                }
                catch (EOFException e) {
                    return null;
                }
                read += (long)s.length();
                int n = s.indexOf(equal);
                if (n < 0) break block3;
                String name = s.substring(0, n);
                String data = valueFilter.filter(s.substring(n + 1));
                this.readField(name, data, subset, nameFilter);
            } while (read <= 524288L);
            throw new IOException("Message too large");
        }
        return s;
    }

    private final byte[] getStringBytes(String c) {
        try {
            return c.getBytes("UTF8");
        }
        catch (UnsupportedEncodingException e) {
            logger.log(Level.SEVERE, "Exception thrown in getStringBytes(String c)", e);
            return null;
        }
    }

    public final void hashUpdate(Digest ctx) {
        this.hashUpdate(ctx, new String[0]);
    }

    public final void hashUpdate(Digest ctx, String[] ignore) {
        this.hashUpdate(ctx, ignore, new byte[0]);
    }

    private void hashUpdate(Digest ctx, String[] ignore, byte[] prefix) {
        Object[] fieldNames = new String[this.size()];
        int i = 0;
        Enumeration keys = this.keys();
        block0: while (keys.hasMoreElements()) {
            String s = (String)keys.nextElement();
            for (int j = 0; j < ignore.length; ++j) {
                if (ignore[j].equals(s)) continue block0;
            }
            fieldNames[i++] = s;
        }
        QuickSorter.quickSort(new ArraySorter(fieldNames, new Fields.StringComparator(), 0, i));
        for (int j = 0; j < i; ++j) {
            byte[] f = this.getStringBytes((String)fieldNames[j]);
            Object data = this.fields.get(fieldNames[j]);
            if (data instanceof FieldSet) {
                byte[] newPrefix = new byte[prefix.length + f.length + 1];
                System.arraycopy(prefix, 0, newPrefix, 0, prefix.length);
                System.arraycopy(f, 0, newPrefix, prefix.length, f.length);
                newPrefix[newPrefix.length - 1] = -3;
                ((FieldSet)data).hashUpdate(ctx, new String[0], newPrefix);
                continue;
            }
            ctx.update(prefix);
            ctx.update(f);
            ctx.update((byte)-2);
            ctx.update(this.getStringBytes((String)data));
            ctx.update((byte)-1);
        }
    }

    public String toString() {
        try {
            ByteArrayOutputStream sw = new ByteArrayOutputStream();
            WriteOutputStream pr = new WriteOutputStream(sw);
            this.inWriteFields(pr, "", ',', '\u0000', '=', '.', false);
            pr.flush();
            return "{" + sw.toString("UTF8") + "}";
        }
        catch (IOException e) {
            return null;
        }
    }

    protected void readField(String name, String value, char sep, Filter f) {
        int dot = name.indexOf(sep);
        if (dot < 0) {
            this.fields.put(f.filter(name), value);
        } else {
            FieldSet fs;
            String fname = f.filter(name.substring(0, dot));
            Object o = this.fields.get(fname);
            if (o == null || !(o instanceof FieldSet)) {
                fs = this.newFieldSet();
                this.fields.put(fname, fs);
            } else {
                fs = (FieldSet)o;
            }
            fs.readField(name.substring(dot + 1), value, sep, f);
        }
    }

    protected FieldSet newFieldSet() {
        return new FieldSet();
    }

    private static class VoidFilter
    implements Filter {
        private VoidFilter() {
        }

        public String filter(String s) {
            return s;
        }
    }

    public static interface Filter {
        public String filter(String var1);
    }
}

