/*
 * Decompiled with CFR 0.152.
 */
package freenet.client;

import freenet.Key;
import freenet.KeyException;
import freenet.Storables;
import freenet.client.ClientCHK;
import freenet.client.ClientKey;
import freenet.client.Document;
import freenet.client.FreenetURI;
import freenet.crypt.BlockCipher;
import freenet.crypt.ProgressiveHashOutputStream;
import freenet.crypt.SHA1;
import freenet.crypt.SHA1Factory;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.Util;
import freenet.support.Bucket;
import freenet.support.io.DataNotValidIOException;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;

public abstract class AbstractClientKey
implements ClientKey {
    public static final String DEFAULT_CIPHER = "Twofish";
    protected String cipherName;
    protected BlockCipher cipher;
    protected Document doc;
    protected Storables storables;

    public static ClientKey createFromInsertURI(Random r, FreenetURI uri) throws KeyException {
        return AbstractClientKey.createClientKey(uri.getKeyType(), "createFromInsertURI", new Class[]{Random.class, FreenetURI.class}, new Object[]{r, uri});
    }

    public static ClientKey createFromRequestURI(FreenetURI uri) throws KeyException {
        return AbstractClientKey.createClientKey(uri.getKeyType(), "createFromRequestURI", new Class[]{FreenetURI.class}, new Object[]{uri});
    }

    private static ClientKey createClientKey(String keyType, String method, Class[] c, Object[] o) throws KeyException {
        try {
            Class<?> ckClass = Class.forName("freenet.client.Client" + keyType);
            if (!AbstractClientKey.class.isAssignableFrom(ckClass)) {
                throw new ClassNotFoundException();
            }
            return (ClientKey)ckClass.getDeclaredMethod(method, c).invoke(null, o);
        }
        catch (ClassNotFoundException e) {
            throw new KeyException("Unknown keytype");
        }
        catch (InvocationTargetException e) {
            if (e.getTargetException() instanceof KeyException) {
                throw (KeyException)e.getTargetException();
            }
            throw new KeyException(e.toString());
        }
        catch (NoSuchMethodException e) {
            throw new KeyException("Key not constructable from URI");
        }
        catch (IllegalAccessException e) {
            throw new KeyException("Illegal access");
        }
    }

    protected AbstractClientKey() throws KeyException {
        try {
            this.setCipher(DEFAULT_CIPHER);
        }
        catch (UnsupportedCipherException e) {
            throw new KeyException("" + e);
        }
    }

    public void setCipher(String cipherName) throws UnsupportedCipherException {
        BlockCipher cipher;
        if (cipherName == null) {
            cipherName = DEFAULT_CIPHER;
        }
        if ((cipher = Util.getCipherByName(cipherName)) == null) {
            throw new UnsupportedCipherException("Unsupported cipher " + cipherName);
        }
        this.cipherName = cipherName;
        this.cipher = cipher;
    }

    public String getCipher() {
        return this.cipherName;
    }

    protected InputStream encode(InputStream plain, long length, long metaLength, Bucket ctBucket) throws IOException {
        this.doc = new Document(this.cipher, this.getCryptoKey(), length, metaLength);
        long partSize = this.getPartSize();
        long paddingLen = this.getPaddedLength() - length;
        ProgressiveHashOutputStream out = new ProgressiveHashOutputStream(partSize, new SHA1Factory(), ctBucket);
        SHA1 ctx = new SHA1();
        OutputStream ctStream = this.doc.encipheringOutputStream(out);
        byte[] buf = new byte[4096];
        while (length > 0L) {
            int i = plain.read(buf, 0, length < (long)buf.length ? (int)length : buf.length);
            if (i > 0) {
                ctx.update(buf, 0, i);
                ctStream.write(buf, 0, i);
                length -= (long)i;
                continue;
            }
            if (i != -1) continue;
            throw new EOFException();
        }
        Util.rollingHashPad(ctStream, paddingLen, ctx);
        ctStream.flush();
        out.close();
        this.storables = new Storables();
        this.storables.setSymmetricCipher(this.cipherName);
        this.storables.setPartSize(partSize);
        this.storables.setDocumentHeader(this.doc.getDocumentHeader());
        this.storables.setInitialDigest(out.getInitialDigest());
        return out.getInputStream();
    }

    public Document decode(Storables sto, long transLength) throws KeyException, DataNotValidIOException {
        String cipherName = sto.getSymmetricCipher();
        byte[] header = sto.getDocumentHeader();
        if (cipherName == null || header == null) {
            throw new DataNotValidIOException(197);
        }
        try {
            this.setCipher(cipherName);
        }
        catch (UnsupportedCipherException e) {
            throw new DataNotValidIOException(195);
        }
        this.doc = new Document(this.cipher, this.getCryptoKey(), header);
        if (transLength != this.getTotalLength()) {
            DataNotValidIOException e = new DataNotValidIOException(196);
            throw e;
        }
        this.storables = sto;
        return this.doc;
    }

    public Document getDocument() {
        return this.doc;
    }

    public Storables getStorables() {
        return this.storables;
    }

    public long getPlainLength() {
        return this.doc == null ? 0L : this.doc.length();
    }

    public long getPaddedLength() {
        return this.getPaddedLength(this.getPlainLength());
    }

    public long getPaddedLength(long plainLength) {
        return Math.max(1024, 1 << Util.log2(plainLength));
    }

    public long getTotalLength() {
        return this.getTotalLength(this.getPaddedLength(), this.getPartSize());
    }

    public long getTotalLength(long plainLength) {
        return this.getTotalLength(this.getPaddedLength(plainLength), this.getPartSize(plainLength));
    }

    public long getTotalLength(long paddedLength, long partSize) {
        return Key.getTransmissionLength(paddedLength, partSize);
    }

    public long getPartSize() {
        return this.getPartSize(this.getPaddedLength());
    }

    public long getPartSize(long paddedLength) {
        return Key.getPartSize(paddedLength);
    }

    public int getControlLength() {
        return Key.getControlLength();
    }

    public String getDocumentName() {
        return null;
    }

    public String toString() {
        return this.getURI() == null ? "new " + this.keyType() : this.getURI().toString();
    }

    public FreenetURI getURI() {
        return this.getKey() == null || this.getCryptoKey() == null ? null : new FreenetURI(this.keyType(), this.getDocumentName(), this.getKey().getVal(), this.getCryptoKey());
    }

    public abstract String keyType();

    public abstract byte[] getCryptoKey() throws KeyException;

    public abstract InputStream encode(Bucket var1, long var2, Bucket var4) throws KeyException, IOException;

    public abstract InputStream encode(Bucket var1, Bucket var2, Bucket var3) throws KeyException, IOException;

    public abstract Key getKey();

    static {
        ClientCHK.class.toString();
    }
}

