/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.CryptoKey;
import freenet.crypt.DSAGroup;
import freenet.crypt.DSAPublicKey;
import freenet.crypt.Global;
import freenet.crypt.Util;
import freenet.crypt.Yarrow;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.util.Random;

public class DSAPrivateKey
extends CryptoKey {
    private final BigInteger x;

    public DSAPrivateKey(BigInteger x) {
        this.x = x;
    }

    public DSAPrivateKey(DSAGroup g, Random r) {
        BigInteger x;
        while ((x = new BigInteger(160, r)).compareTo(g.getQ()) > -1) {
        }
        this.x = x;
    }

    public String keyType() {
        return "DSA.s";
    }

    public BigInteger getX() {
        return this.x;
    }

    public static CryptoKey read(InputStream i) throws IOException {
        return new DSAPrivateKey(Util.readMPI(i));
    }

    public void write(OutputStream out) throws IOException {
        DataOutputStream o = this.write(out, this.getClass().getName());
        Util.writeMPI(this.x, out);
    }

    public String writeAsField() {
        return this.x.toString(16);
    }

    public byte[] asBytes() {
        return Util.MPIbytes(this.x);
    }

    public byte[] fingerprint() {
        return this.fingerprint(new BigInteger[]{this.x});
    }

    public static void main(String[] args) throws Exception {
        Yarrow y = new Yarrow();
        DSAPrivateKey p = new DSAPrivateKey(Global.DSAgroupC, y);
        DSAPublicKey pk = new DSAPublicKey(Global.DSAgroupC, p);
        p.write(System.out);
    }
}

