/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt;

import freenet.crypt.EntropySource;
import freenet.crypt.RandomSource;
import freenet.crypt.Yarrow;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class RandStream
extends RandomSource {
    private RandomSource fallBack;
    protected DataInputStream stream;
    static final int[][] bitTable = new int[][]{{0, 0}, {1, 1}, {1, 3}, {1, 7}, {1, 15}, {1, 31}, {1, 63}, {1, 127}, {1, 255}, {2, 511}, {2, 1023}, {2, 2047}, {2, 4095}, {2, 8191}, {2, 16383}, {2, Short.MAX_VALUE}, {2, 65535}, {3, 131071}, {3, 262143}, {3, 524287}, {3, 1048575}, {3, 0x1FFFFF}, {3, 0x3FFFFF}, {3, 0x7FFFFF}, {3, 0xFFFFFF}, {4, 0x1FFFFFF}, {4, 0x3FFFFFF}, {4, 0x7FFFFFF}, {4, 0xFFFFFFF}, {4, 0x1FFFFFFF}, {4, 0x3FFFFFFF}, {4, Integer.MAX_VALUE}, {4, -1}};

    public RandStream() {
    }

    public RandStream(InputStream is) {
        this(is, new Yarrow());
    }

    public RandStream(InputStream is, RandomSource fallBack) {
        this.stream = new DataInputStream(is);
        this.fallBack = fallBack;
    }

    protected int next(int bits) {
        int[] parameters = bitTable[bits];
        byte[] buffer = new byte[parameters[0]];
        try {
            this.stream.readFully(buffer);
        }
        catch (IOException e) {
            // empty catch block
        }
        int val = buffer[0];
        if (parameters[0] == 4) {
            val += (buffer[1] << 24) + (buffer[2] << 16) + (buffer[3] << 8);
        } else if (parameters[0] == 3) {
            val += (buffer[1] << 16) + (buffer[2] << 8);
        } else if (parameters[0] == 2) {
            val += buffer[2] << 8;
        }
        return val & parameters[1];
    }

    public void nextBytes(byte[] bytes) {
        try {
            this.stream.readFully(bytes);
        }
        catch (Exception c) {
            this.fallBack.nextBytes(bytes);
        }
    }

    public int nextInt() {
        try {
            return this.stream.readInt();
        }
        catch (Exception c) {
            return this.fallBack.nextInt();
        }
    }

    public long nextLong() {
        try {
            return this.stream.readLong();
        }
        catch (Exception c) {
            return this.fallBack.nextLong();
        }
    }

    public float nextFloat() {
        try {
            return this.stream.readFloat();
        }
        catch (Exception c) {
            return this.fallBack.nextFloat();
        }
    }

    public double nextDouble() {
        try {
            return this.stream.readDouble();
        }
        catch (Exception c) {
            return this.fallBack.nextDouble();
        }
    }

    public int acceptEntropy(EntropySource source, long data, int entropyBits) {
        return entropyBits;
    }

    public int acceptTimerEntropy(EntropySource timer) {
        return 32;
    }

    public void close() {
        try {
            this.stream.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

