/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt.ciphers;

import freenet.crypt.BlockCipher;
import freenet.crypt.UnsupportedCipherException;
import freenet.crypt.ciphers.Rijndael_Algorithm;
import freenet.support.Fields;
import java.security.InvalidKeyException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class Rijndael
implements BlockCipher {
    private static Logger logger = Logger.getLogger(Rijndael.class.getName());
    private Object sessionKey;
    private int keysize;
    private int blocksize;

    public Rijndael(Integer keysize) throws UnsupportedCipherException {
        this((int)keysize);
    }

    public Rijndael(int keysize) throws UnsupportedCipherException {
        this(keysize, 128);
    }

    public Rijndael(int keysize, int blocksize) throws UnsupportedCipherException {
        if (keysize != 128 && keysize != 192 && keysize != 256) {
            throw new UnsupportedCipherException("Invalid keysize");
        }
        if (blocksize != 128 && blocksize != 192 && blocksize != 256) {
            throw new UnsupportedCipherException("Invalid blocksize");
        }
        this.keysize = keysize;
        this.blocksize = blocksize;
    }

    public Rijndael() {
        this.keysize = 128;
        this.blocksize = 128;
    }

    public final int getBlockSize() {
        return this.blocksize;
    }

    public final int getKeySize() {
        return this.keysize;
    }

    public final void initialize(byte[] key) {
        try {
            byte[] nkey = new byte[this.keysize >> 3];
            System.arraycopy(key, 0, nkey, 0, nkey.length);
            this.sessionKey = Rijndael_Algorithm.makeKey(nkey);
        }
        catch (InvalidKeyException e) {
            logger.log(Level.SEVERE, "Exception thrown in initialize(byte[] key)", e);
        }
    }

    public final void encipher(byte[] block, byte[] result) {
        Rijndael_Algorithm.blockEncrypt(block, result, 0, this.sessionKey);
    }

    public final void decipher(byte[] block, byte[] result) {
        Rijndael_Algorithm.blockDecrypt(block, result, 0, this.sessionKey);
    }

    public static void main(String[] args) throws UnsupportedCipherException {
        System.out.println("KEYSIZE=128\n");
        Rijndael.monteCarlo(128);
        System.out.println("=========================\n");
        System.out.println("KEYSIZE=192\n");
        Rijndael.monteCarlo(192);
        System.out.println("=========================\n");
        System.out.println("KEYSIZE=256\n");
        Rijndael.monteCarlo(256);
    }

    static void monteCarlo(int keySize) throws UnsupportedCipherException {
        Rijndael ctx = new Rijndael(keySize);
        int kb = keySize / 8;
        byte[] P = new byte[16];
        byte[] C = new byte[16];
        byte[] CL = new byte[16];
        byte[] KEY = new byte[kb];
        for (int i = 0; i < 400; ++i) {
            int x;
            System.out.println("I=" + i);
            System.out.println("KEY=" + Fields.bytesToHex(KEY, 0, kb));
            System.out.println("PT=" + Fields.bytesToHex(P, 0, 16));
            ctx.initialize(KEY);
            for (int j = 0; j < 10000; ++j) {
                System.arraycopy(C, 0, CL, 0, C.length);
                ctx.encipher(P, C);
                System.arraycopy(C, 0, P, 0, P.length);
            }
            System.out.println("CT=" + Fields.bytesToHex(C, 0, 16));
            for (x = 0; x < kb; ++x) {
                if (keySize == 192) {
                    if (x < 8) {
                        int n = x;
                        KEY[n] = (byte)(KEY[n] ^ CL[8 + x]);
                        continue;
                    }
                    int n = x;
                    KEY[n] = (byte)(KEY[n] ^ C[x - 8]);
                    continue;
                }
                if (keySize == 256) {
                    if (x < 16) {
                        int n = x;
                        KEY[n] = (byte)(KEY[n] ^ CL[x]);
                        continue;
                    }
                    int n = x;
                    KEY[n] = (byte)(KEY[n] ^ C[x - 16]);
                    continue;
                }
                int n = x;
                KEY[n] = (byte)(KEY[n] ^ C[x]);
            }
            if (keySize == 192) {
                for (x = 0; x < 8; ++x) {
                    int n = x + 16;
                    KEY[n] = (byte)(KEY[n] ^ CL[x + 8]);
                }
            } else if (keySize == 256) {
                for (x = 0; x < 16; ++x) {
                    int n = x + 16;
                    KEY[n] = (byte)(KEY[n] ^ CL[x]);
                }
            }
            System.out.println();
        }
    }
}

