/*
 * Decompiled with CFR 0.152.
 */
package freenet.crypt.ciphers;

import java.io.InputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;

public class Twofish_Properties {
    static final boolean GLOBAL_DEBUG = false;
    static final String ALGORITHM = "Twofish";
    static final double VERSION = 0.2;
    static final String FULL_NAME = "Twofish ver. 0.2";
    static final String NAME = "Twofish_Properties";
    static final Properties properties;
    private static final String[][] DEFAULT_PROPERTIES;

    public static String getProperty(String key) {
        return properties.getProperty(key);
    }

    public static String getProperty(String key, String value) {
        return properties.getProperty(key, value);
    }

    public static void list(PrintStream out) {
        Twofish_Properties.list(new PrintWriter(out, true));
    }

    public static void list(PrintWriter out) {
        out.println("#");
        out.println("# ----- Begin Twofish properties -----");
        out.println("#");
        Enumeration<?> enumeration = properties.propertyNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = Twofish_Properties.getProperty(key);
            out.println(key + " = " + value);
        }
        out.println("#");
        out.println("# ----- End Twofish properties -----");
    }

    public static Enumeration propertyNames() {
        return properties.propertyNames();
    }

    static boolean isTraceable(String label) {
        String s = Twofish_Properties.getProperty("Trace." + label);
        if (s == null) {
            return false;
        }
        return new Boolean(s);
    }

    static int getLevel(String label) {
        String s = Twofish_Properties.getProperty("Debug.Level." + label);
        if (s == null && (s = Twofish_Properties.getProperty("Debug.Level.*")) == null) {
            return 0;
        }
        try {
            return Integer.parseInt(s);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    static PrintWriter getOutput() {
        String name = Twofish_Properties.getProperty("Output");
        PrintWriter pw = name != null && name.equals("out") ? new PrintWriter(System.out, true) : new PrintWriter(System.err, true);
        return pw;
    }

    static {
        boolean ok;
        properties = new Properties();
        DEFAULT_PROPERTIES = new String[][]{{"Trace.Twofish_Algorithm", "true"}, {"Debug.Level.*", "1"}, {"Debug.Level.Twofish_Algorithm", "9"}};
        String it = "Twofish.properties";
        InputStream is = Twofish_Properties.class.getResourceAsStream(it);
        boolean bl = ok = is != null;
        if (ok) {
            try {
                properties.load(is);
                is.close();
            }
            catch (Exception x) {
                ok = false;
            }
        }
        if (!ok) {
            int n = DEFAULT_PROPERTIES.length;
            for (int i = 0; i < n; ++i) {
                properties.put(DEFAULT_PROPERTIES[i][0], DEFAULT_PROPERTIES[i][1]);
            }
        }
    }
}

