/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Comparator;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public abstract class Fields {
    private static Logger logger = Logger.getLogger(Fields.class.getName());

    public static void main(String[] args) {
        System.out.println(Long.toHexString(Fields.stringToLong(args[0])));
        System.out.println(Long.toHexString(Long.parseLong(args[0], 16)));
    }

    public static final long stringToLong(String hex) throws NumberFormatException {
        return Fields.hexToLong(hex);
    }

    public static final String longToString(long l) {
        return Fields.longToHex(l);
    }

    public static final long hexToLong(String hex) throws NumberFormatException {
        int len = hex.length();
        if (len > 16) {
            throw new NumberFormatException();
        }
        long l = 0L;
        for (int i = 0; i < len; ++i) {
            l <<= 4;
            int c = Character.digit(hex.charAt(i), 16);
            if (c < 0) {
                throw new NumberFormatException();
            }
            l |= (long)c;
        }
        return l;
    }

    public static final int hexToInt(String hex) throws NumberFormatException {
        int len = hex.length();
        if (len > 16) {
            throw new NumberFormatException();
        }
        int l = 0;
        for (int i = 0; i < len; ++i) {
            l <<= 4;
            int c = Character.digit(hex.charAt(i), 16);
            if (c < 0) {
                throw new NumberFormatException();
            }
            l |= c;
        }
        return l;
    }

    public static final String longToHex(long l) {
        StringBuffer sb = new StringBuffer(17);
        Fields.longToHex(l, sb);
        return sb.toString();
    }

    public static final void longToHex(long l, StringBuffer sb) {
        do {
            sb.append(Character.forDigit((int)l & 0xF, 16));
        } while ((l >>>= 4) != 0L);
        sb.reverse();
    }

    public static final String intToHex(int l) {
        StringBuffer sb = new StringBuffer(9);
        do {
            sb.append(Character.forDigit(l & 0xF, 16));
        } while ((l >>>= 4) != 0);
        return sb.reverse().toString();
    }

    public static final boolean stringToBool(String s, boolean def) {
        return def ? !s.equalsIgnoreCase("false") : s.equalsIgnoreCase("true");
    }

    public static final String boolToString(boolean b) {
        return b ? "true" : "false";
    }

    public static final byte[] hexToBytes(String s) {
        return Fields.hexToBytes(s, 0);
    }

    public static final byte[] hexToBytes(String s, int off) {
        byte[] bs = new byte[off + (1 + s.length()) / 2];
        Fields.hexToBytes(s, bs, off);
        return bs;
    }

    public static final void hexToBytes(String s, byte[] out, int off) throws NumberFormatException, IndexOutOfBoundsException {
        if (s.length() % 2 != 0) {
            s = '0' + s;
        }
        if (out.length < off + s.length() / 2) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = 0; i < s.length(); ++i) {
            byte b = (byte)Character.digit(s.charAt(i), 16);
            if (b < 0) {
                throw new NumberFormatException();
            }
            out[off + i / 2] = i % 2 == 0 ? (byte)(b << 4) : (byte)(out[off + i / 2] | b);
        }
    }

    public static final String bytesToHex(byte[] bs, int off, int length) {
        StringBuffer sb = new StringBuffer(length * 2);
        Fields.bytesToHexAppend(bs, off, length, sb);
        return sb.toString();
    }

    public static final void bytesToHexAppend(byte[] bs, int off, int length, StringBuffer sb) {
        for (int i = off; i < off + length && i < bs.length; ++i) {
            sb.append(Character.forDigit(bs[i] >>> 4 & 0xF, 16));
            sb.append(Character.forDigit(bs[i] & 0xF, 16));
        }
    }

    public static final String bytesToHex(byte[] bs) {
        return Fields.bytesToHex(bs, 0, bs.length);
    }

    public static final String[] commaList(String ls) {
        StringTokenizer st = new StringTokenizer(ls, ",");
        String[] r = new String[st.countTokens()];
        for (int i = 0; i < r.length; ++i) {
            r[i] = st.nextToken().trim();
        }
        return r;
    }

    public static final String commaList(String[] ls) {
        return Fields.textList(ls, ',');
    }

    public static final String textList(String[] ls, char ch) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < ls.length; ++i) {
            sb.append(ls[i]);
            if (i == ls.length - 1) continue;
            sb.append(ch);
        }
        return sb.toString();
    }

    public static final long[] numberList(String ls) throws NumberFormatException {
        StringTokenizer st = new StringTokenizer(ls, ",");
        long[] r = new long[st.countTokens()];
        for (int i = 0; i < r.length; ++i) {
            r[i] = Fields.stringToLong(st.nextToken());
        }
        return r;
    }

    public static final String numberList(long[] ls) {
        StringBuffer sb = new StringBuffer(ls.length * 18);
        for (int i = 0; i < ls.length; ++i) {
            sb.append(Fields.longToString(ls[i]));
            if (i == ls.length - 1) continue;
            sb.append(',');
        }
        return sb.toString();
    }

    public static final long dateTime(String date) throws NumberFormatException {
        int dash = date.indexOf(45);
        if (!(dash == -1 && date.length() == 8 || dash == 8 && date.length() == 17)) {
            throw new NumberFormatException("Date time: " + date + " not correct.");
        }
        int year = Integer.parseInt(date.substring(0, 4));
        int month = Integer.parseInt(date.substring(4, 6));
        int day = Integer.parseInt(date.substring(6, 8));
        int hour = dash == -1 ? 0 : Integer.parseInt(date.substring(9, 11));
        int minute = dash == -1 ? 0 : Integer.parseInt(date.substring(12, 14));
        int second = dash == -1 ? 0 : Integer.parseInt(date.substring(15, 17));
        try {
            return new GregorianCalendar(year, month - 1, day, hour, minute, second).getTime().getTime();
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "Exception thrown in dateTime(String date)", e);
            throw new NumberFormatException("Invalid date " + date + ": " + e);
        }
    }

    public static final String secToDateTime(long time) {
        SimpleDateFormat f = new SimpleDateFormat("yyyyMMdd-HH:mm:ss");
        String dateString = f.format(new Date(time * 1000L));
        if (dateString.endsWith("-00:00:00")) {
            dateString = dateString.substring(0, 8);
        }
        return dateString;
    }

    public static final int compareBytes(byte[] b1, byte[] b2) {
        int len = Math.max(b1.length, b2.length);
        for (int i = 0; i < len; ++i) {
            if (i == b1.length) {
                return i == b2.length ? 0 : -1;
            }
            if (i == b2.length) {
                return 1;
            }
            if ((0xFF & b1[i]) > (0xFF & b2[i])) {
                return 1;
            }
            if ((0xFF & b1[i]) >= (0xFF & b2[i])) continue;
            return -1;
        }
        return 0;
    }

    public static final int compareBytes(byte[] a, byte[] b, int aoff, int boff, int len) {
        for (int i = 0; i < len; ++i) {
            if (i + aoff == a.length) {
                return i + boff == b.length ? 0 : -1;
            }
            if (i + boff == b.length) {
                return 1;
            }
            if ((0xFF & a[i + aoff]) > (0xFF & b[i + boff])) {
                return 1;
            }
            if ((0xFF & a[i + aoff]) >= (0xFF & b[i + boff])) continue;
            return -1;
        }
        return 0;
    }

    public static final boolean byteArrayEqual(byte[] a, byte[] b) {
        if (a.length != b.length) {
            return false;
        }
        for (int i = 0; i < a.length; ++i) {
            if (a[i] == b[i]) continue;
            return false;
        }
        return true;
    }

    public static final boolean byteArrayEqual(byte[] a, byte[] b, int aoff, int boff, int len) {
        if (a.length < aoff + len || b.length < boff + len) {
            return false;
        }
        for (int i = 0; i < len; ++i) {
            if (a[i + aoff] == b[i + boff]) continue;
            return false;
        }
        return true;
    }

    public static final int hashCode(byte[] b) {
        int h = 0;
        for (int i = b.length - 1; i >= 0; --i) {
            int x = b[i] & 0xFF;
            h ^= x << ((i & 3) << 3);
        }
        return h;
    }

    public static final long longHashCode(byte[] b) {
        long h = 0L;
        for (int i = b.length - 1; i >= 0; --i) {
            int x = b[i] & 0xFF;
            h ^= (long)x << ((i & 7) << 3);
        }
        return h;
    }

    public static final class ByteArrayComparator
    implements Comparator {
        public final int compare(Object o1, Object o2) {
            return ByteArrayComparator.compare((byte[])o1, (byte[])o2);
        }

        public static final int compare(byte[] o1, byte[] o2) {
            return Fields.compareBytes(o1, o2);
        }
    }

    public static final class StringLengthComparator
    implements Comparator {
        public final int compare(Object o1, Object o2) {
            return StringLengthComparator.compare((String)o1, (String)o2);
        }

        public static final int compare(String o1, String o2) {
            return o1.length() == o2.length() ? 0 : (o1.length() > o2.length() ? 1 : -1);
        }
    }

    public static final class StringComparator
    implements Comparator {
        public final int compare(Object o1, Object o2) {
            return StringComparator.compare((String)o1, (String)o2);
        }

        public static final int compare(String o1, String o2) {
            return o1.compareTo(o2);
        }
    }
}

