/*
 * Decompiled with CFR 0.152.
 */
package freenet.support.sort;

import freenet.support.Comparable;
import freenet.support.Comparator;
import freenet.support.sort.Sortable;

public final class ArraySorter
implements Sortable {
    private final Object[] target;
    private final Comparator comp;
    private final int offset;
    private final int size;

    public ArraySorter(Object[] target) {
        this(target, null, 0, target.length);
    }

    public ArraySorter(Object[] target, int offset, int size) {
        this(target, null, offset, size);
    }

    public ArraySorter(Object[] target, Comparator comp) {
        this(target, comp, 0, target.length);
    }

    public ArraySorter(Object[] target, Comparator comp, int offset, int size) {
        this.target = target;
        this.comp = comp;
        this.offset = offset;
        this.size = size;
    }

    public final int compare(int index1, int index2) {
        return this.comp == null ? ((Comparable)this.target[this.offset + index1]).compareTo(this.target[this.offset + index2]) : this.comp.compare(this.target[this.offset + index1], this.target[this.offset + index2]);
    }

    public final void swap(int index1, int index2) {
        Object t = this.target[this.offset + index1];
        this.target[this.offset + index1] = this.target[this.offset + index2];
        this.target[this.offset + index2] = t;
    }

    public final int size() {
        return this.size;
    }
}

