/*
 * Decompiled with CFR 0.152.
 */
package com.onionnetworks.fec;

import com.onionnetworks.fec.FECCode;
import com.onionnetworks.fec.FECCodeFactory;
import com.onionnetworks.util.Tuple;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultFECCodeFactory
extends FECCodeFactory {
    private static Logger logger = Logger.getLogger(DefaultFECCodeFactory.class.getName());
    public static final int DEFAULT_CACHE_TIME = 120000;
    protected ArrayList eightBitCodes = new ArrayList();
    protected ArrayList sixteenBitCodes = new ArrayList();
    protected Properties fecProperties;

    public DefaultFECCodeFactory() {
        try {
            this.fecProperties = new Properties();
            this.fecProperties.load(ClassLoader.getSystemClassLoader().getResourceAsStream(System.getProperty("com.onionnetworks.fec.defaultfeccodefactorypropertiesfile", "lib/fec.properties")));
        }
        catch (IOException e) {
            logger.log(Level.SEVERE, "Unable to load /lib/fec.properties", e);
            throw new IllegalStateException("Unable to load /lib/fec.properties");
        }
        StringTokenizer st = new StringTokenizer(this.getProperty("com.onionnetworks.fec.keys"), ",");
        while (st.hasMoreTokens()) {
            String key = st.nextToken();
            try {
                Constructor<?> con = Class.forName(this.getProperty("com.onionnetworks.fec." + key + ".class")).getConstructor(Integer.TYPE, Integer.TYPE);
                String numBits = this.getProperty("com.onionnetworks.fec." + key + ".bits");
                if ("8".equals(numBits)) {
                    this.eightBitCodes.add(con);
                    continue;
                }
                if ("16".equals(numBits)) {
                    this.sixteenBitCodes.add(con);
                    continue;
                }
                throw new IllegalArgumentException("Only 8 and 16 bit codes are currently supported");
            }
            catch (Throwable t) {
                logger.log(Level.SEVERE, "Exception thrown in constructor", t);
            }
        }
    }

    protected synchronized String getProperty(String key) {
        String result = System.getProperty(key);
        if (result == null) {
            result = this.fecProperties.getProperty(key);
        }
        return result;
    }

    public synchronized FECCode createFECCode(int k, int n) {
        Integer K = new Integer(k);
        Integer N = new Integer(n);
        Tuple t = new Tuple(K, N);
        FECCode result = null;
        if (result == null) {
            if (k < 1 || k > 65536 || n < k || n > 65536) {
                throw new IllegalArgumentException("k and n must be between 1 and 65536 and n must not be smaller than k: k=" + k + ",n=" + n);
            }
            Iterator it = n <= 256 && !this.eightBitCodes.isEmpty() ? this.eightBitCodes.iterator() : this.sixteenBitCodes.iterator();
            while (it.hasNext()) {
                try {
                    result = (FECCode)((Constructor)it.next()).newInstance(K, N);
                    break;
                }
                catch (Throwable doh) {
                }
            }
        }
        return result;
    }
}

