/*
 * Decompiled with CFR 0.152.
 */
package fecimpl;

import java.util.logging.Logger;

class SegmentationParams {
    private static Logger logger = Logger.getLogger(SegmentationParams.class.getName());
    public final int baseN;
    public final int baseK;
    public final int endN;
    public final int endK;
    public final int baseBlockSize;
    public final int endBlockSize;
    public final int baseStripeWidth;
    public final int endStripeWidth;
    public final int baseSegmentSize;
    public final int endSegmentSize;
    public final int segments;
    private static final int C_128K = 131072;
    private static final int C_256K = 262144;
    private static final int C_512K = 524288;
    private static final int C_1M = 0x100000;
    private static final int C_16M = 0x1000000;
    private static final int C_32M = 0x2000000;
    private static final int C_64M = 0x4000000;
    private static final int C_128M = 0x8000000;
    private static final long C_SEGLEN = 0x8000000L;
    private static final int C_MIN_SEGLEN = 786432;

    SegmentationParams(int baseN_, int baseK_, int endN_, int endK_, int baseBlockSize_, int endBlockSize_, int baseStripeWidth_, int endStripeWidth_, int baseSegmentSize_, int endSegmentSize_, int segments_) {
        this.baseN = baseN_;
        this.baseK = baseK_;
        this.endN = endN_;
        this.endK = endK_;
        this.baseBlockSize = baseBlockSize_;
        this.endBlockSize = endBlockSize_;
        this.baseStripeWidth = baseStripeWidth_;
        this.endStripeWidth = endStripeWidth_;
        this.baseSegmentSize = baseSegmentSize_;
        this.endSegmentSize = endSegmentSize_;
        this.segments = segments_;
    }

    SegmentationParams(long len, int redundancyNum, int redundancyDenom) {
        if (len < 1L || redundancyNum < 1 || redundancyDenom < 1) {
            throw new IllegalArgumentException("len=" + len + " redundancyNum=" + redundancyNum + " redundancyDenom=" + redundancyDenom);
        }
        int segCount = (int)(len / 0x8000000L);
        if (len % 0x8000000L != 0L) {
            ++segCount;
        }
        this.segments = segCount;
        long segLen = len;
        if (len > 0x8000000L) {
            segLen = 0x8000000L;
        }
        if (segLen < 786432L) {
            segLen = 786432L;
        }
        this.baseSegmentSize = (int)segLen;
        this.baseBlockSize = SegmentationParams.selectBlockSize(this.baseSegmentSize);
        this.baseK = SegmentationParams.calculateK(this.baseSegmentSize, this.baseBlockSize);
        this.baseN = SegmentationParams.calculateN(this.baseK, redundancyNum, redundancyDenom);
        this.baseStripeWidth = SegmentationParams.selectStripeWidth(this.baseSegmentSize, this.baseBlockSize);
        if (this.segments > 1) {
            segLen = len % (long)this.baseSegmentSize;
            if (segLen == 0L) {
                this.endSegmentSize = this.baseSegmentSize;
                this.endBlockSize = this.baseBlockSize;
                this.endK = this.baseK;
                this.endN = this.baseN;
                this.endStripeWidth = this.baseStripeWidth;
            } else {
                if (segLen > 0x8000000L) {
                    throw new RuntimeException("assertion failure: segLen <= 134217728");
                }
                if (segLen < 786432L) {
                    segLen = 786432L;
                }
                this.endSegmentSize = (int)segLen;
                this.endBlockSize = SegmentationParams.selectBlockSize(this.endSegmentSize);
                this.endK = SegmentationParams.calculateK(this.endSegmentSize, this.endBlockSize);
                this.endN = SegmentationParams.calculateN(this.endK, redundancyNum, redundancyDenom);
                this.endStripeWidth = SegmentationParams.selectStripeWidth(this.endSegmentSize, this.endBlockSize);
            }
        } else {
            this.endSegmentSize = this.baseSegmentSize;
            this.endBlockSize = this.baseBlockSize;
            this.endK = this.baseK;
            this.endN = this.baseN;
            this.endStripeWidth = this.baseStripeWidth;
        }
    }

    public final void dump() {
        logger.fine("----------------------------------------\nbaseN: " + this.baseN + "\n" + "baseK: " + this.baseK + "\n" + "endN: " + this.endN + "\n" + "endK: " + this.endK + "\n" + "baseBlockSize: " + this.baseBlockSize + "\n" + "endBlockSize: " + this.endBlockSize + "\n" + "baseStripeWidth: " + this.baseStripeWidth + "\n" + "endStripeWidth: " + this.endStripeWidth + "\n" + "baseSegmentSize: " + this.baseSegmentSize + "\n" + "endSegmentSize: " + this.endSegmentSize + "\n" + "segments: " + this.segments + "\n" + "----------------------------------------");
    }

    private static final int selectBlockSize(long segLen) {
        int blockSize = segLen < 0x100000L ? 131072 : (segLen < 0x2000000L ? 262144 : (segLen < 0x4000000L ? 524288 : 0x100000));
        return blockSize;
    }

    private static final int calculateK(long segLen, int blockSize) {
        int k = 0;
        if (segLen < 0x8000000L) {
            k = (int)(segLen / (long)blockSize);
            if (segLen % (long)blockSize != 0L) {
                ++k;
            }
        } else {
            k = (int)(0x8000000L / (long)blockSize);
        }
        return k;
    }

    private static final int calculateN(int k, int redundancyNum, int redundancyDenom) {
        if (k > 128) {
            throw new IllegalArgumentException("k > 128!");
        }
        if ((double)redundancyNum / (double)redundancyDenom > 0.5) {
            throw new IllegalArgumentException("Maximum allowed redundancy is 50%.");
        }
        int n = k + k * redundancyNum / redundancyDenom;
        if (n == k) {
            ++n;
        }
        return n;
    }

    private static final int selectStripeWidth(int segLen, int blockSize) {
        int stripeWidth = -1;
        if (segLen > 0x1000000) {
            int stripeCount = 1;
            while (segLen / stripeCount > 0x1000000) {
                stripeCount <<= 1;
            }
            stripeWidth = blockSize / stripeCount;
            if (blockSize % stripeCount != 0) {
                throw new RuntimeException("assertion failure: blockSize % stripeCount == 0");
            }
        }
        return stripeWidth;
    }
}

