/*
 * Decompiled with CFR 0.152.
 */
package freenet.support;

import freenet.support.Bucket;
import freenet.support.io.NullInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileBucket
implements Bucket {
    protected File file;
    protected boolean restart = true;
    protected boolean newFile;
    protected long length;
    protected long fileRestartCounter;
    protected static String tempDir;

    public FileBucket(File file) {
        this.file = file;
        this.newFile = false;
        this.fileRestartCounter = 0L;
        this.length = file.length();
    }

    public FileBucket() {
        this.file = new File("tempdir/" + System.currentTimeMillis());
        this.newFile = true;
        this.length = 0L;
        this.file.deleteOnExit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OutputStream getOutputStream() throws IOException {
        FileBucket fileBucket = this;
        synchronized (fileBucket) {
            boolean append;
            boolean bl = append = !this.restart;
            if (this.restart) {
                ++this.fileRestartCounter;
            }
            this.restart = false;
            return this.newFileBucketOutputStream(this.file.getPath(), append, this.fileRestartCounter);
        }
    }

    protected FileBucketOutputStream newFileBucketOutputStream(String s, boolean append, long restartCount) throws IOException {
        return new FileBucketOutputStream(s, append, restartCount);
    }

    protected void resetLength() {
        long oldLen = this.length;
        this.length = 0L;
    }

    public InputStream getInputStream() throws IOException {
        return this.file.exists() ? new FileBucketInputStream(this.file) : new NullInputStream();
    }

    public String getName() {
        return this.file.getName();
    }

    public void resetWrite() {
        this.restart = true;
    }

    public long size() {
        return this.length;
    }

    public File getFile() {
        return this.file;
    }

    protected void deleteFile() {
        this.file.delete();
    }

    public void finalize() throws Throwable {
        if (this.newFile && this.file.exists()) {
            this.deleteFile();
        }
    }

    public static final synchronized String getTempDir() {
        return tempDir;
    }

    public static final synchronized void setTempDir(String dirName) {
        File dir = new File(dirName);
        if (!(dir.exists() && dir.isDirectory() && dir.canWrite())) {
            throw new IllegalArgumentException("Bad Temp Directory: " + dir.getAbsolutePath());
        }
        tempDir = dirName;
    }

    static {
        String os;
        tempDir = null;
        tempDir = System.getProperty("java.io.tmpdir");
        if (tempDir == null && (os = System.getProperty("os.name")) != null) {
            String[] candidates = null;
            if (os.equalsIgnoreCase("Linux")) {
                String[] linuxCandidates;
                candidates = linuxCandidates = new String[]{"/tmp", "/var/tmp"};
            } else if (os.equalsIgnoreCase("Windows")) {
                String[] windowsCandidates = new String[]{"C:\\TEMP", "C:\\WINDOWS\\TEMP"};
                candidates = windowsCandidates;
            }
            if (candidates != null) {
                for (int i = 0; i < candidates.length; ++i) {
                    File path = new File(candidates[i]);
                    if (!path.exists() || !path.isDirectory() || !path.canWrite()) continue;
                    tempDir = candidates[i];
                    break;
                }
            }
        }
        if (tempDir == null) {
            tempDir = System.getProperty("user.dir");
        }
    }

    class FileBucketInputStream
    extends FileInputStream {
        Exception e;

        public FileBucketInputStream(File f) throws IOException {
            super(f);
        }
    }

    class FileBucketOutputStream
    extends FileOutputStream {
        long restartCount;
        Exception e;

        protected FileBucketOutputStream(String s, boolean append, long restartCount) throws FileNotFoundException {
            super(s, append);
            this.restartCount = restartCount;
            if (!append) {
                FileBucket.this.resetLength();
            }
        }

        protected void confirmWriteSynchronized() {
            if (FileBucket.this.fileRestartCounter > this.restartCount) {
                throw new IllegalStateException("writing to file after restart");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b) throws IOException {
            FileBucket fileBucket = FileBucket.this;
            synchronized (fileBucket) {
                this.confirmWriteSynchronized();
                super.write(b);
                FileBucket.this.length += (long)b.length;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(byte[] b, int off, int len) throws IOException {
            FileBucket fileBucket = FileBucket.this;
            synchronized (fileBucket) {
                this.confirmWriteSynchronized();
                super.write(b, off, len);
                FileBucket.this.length += (long)len;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void write(int b) throws IOException {
            FileBucket fileBucket = FileBucket.this;
            synchronized (fileBucket) {
                this.confirmWriteSynchronized();
                if (FileBucket.this.fileRestartCounter > this.restartCount) {
                    throw new IllegalStateException("writing to file after restart");
                }
                super.write(b);
                ++FileBucket.this.length;
            }
        }
    }
}

