/*
 * Decompiled with CFR 0.152.
 */
import fecimpl.OnionFECEncoder;
import freenet.support.Bucket;
import freenet.support.BucketFactory;
import freenet.support.RandomAccessFileBucket2;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class test {
    public static void main(String[] argv) throws Throwable {
        new test().run();
    }

    public void run() throws Throwable {
        System.out.println("Starting");
        File inputFile = new File("biginputfile.dat");
        long filesize = inputFile.length();
        OnionFECEncoder encoder = new OnionFECEncoder();
        FrostFECEncodeBucketFactory fecFactory = new FrostFECEncodeBucketFactory();
        encoder.init(filesize, fecFactory);
        int segmentCount = encoder.getSegmentCount();
        long checkBlocksFileSize = 0L;
        for (int z = 0; z < segmentCount; ++z) {
            int checkBlockSize = encoder.getCheckBlockSize(z);
            int checkBlockCount = encoder.getN(z) - encoder.getK(z);
            System.out.println("segment=" + z + "  checkblocks=" + checkBlockCount + "  checkblocksize=" + checkBlockSize);
            checkBlocksFileSize += (long)(checkBlockSize * checkBlockCount);
        }
        System.out.println("Preparing check blocks file, size=" + checkBlocksFileSize);
        fecFactory.init("biginputfile.checks", checkBlocksFileSize);
        System.out.println("Processing segments");
        long segmentStartOffset = 0L;
        RandomAccessFile raf = new RandomAccessFile(inputFile, "r");
        for (int actSegment = 0; actSegment < segmentCount; ++actSegment) {
            int blockCount = encoder.getK(actSegment);
            int blockSize = encoder.getBlockSize(actSegment);
            System.out.println("seg=" + actSegment + "  fsize=" + filesize + "  blocks=" + blockCount + "  bsize=" + blockSize);
            Bucket[] actSegmentsDataBlocks = RandomAccessFileBucket2.segment(inputFile, blockSize, segmentStartOffset, blockCount, true, raf);
            System.out.println("lastb=" + actSegmentsDataBlocks[actSegmentsDataBlocks.length - 1].size());
            encoder.encode(actSegment, actSegmentsDataBlocks, null);
            segmentStartOffset += (long)encoder.getSegmentSize(actSegment);
        }
    }

    class FrostFECEncodeBucketFactory
    implements BucketFactory {
        int checkBlockCounter = 0;
        File checkBlocksFile;
        long actFileOffset = 0L;
        RandomAccessFile raf = null;

        FrostFECEncodeBucketFactory() {
        }

        public void init(String checkBlocksFileName, long checkBlocksFileSize) throws IOException {
            this.checkBlocksFile = new File(checkBlocksFileName);
            this.checkBlocksFile.delete();
            this.raf = new RandomAccessFile(this.checkBlocksFile, "rw");
            this.raf.setLength(checkBlocksFileSize);
        }

        public Bucket makeBucket(long size) throws IOException {
            RandomAccessFileBucket2 b = new RandomAccessFileBucket2(this.checkBlocksFile, this.actFileOffset, size, false, this.raf);
            this.actFileOffset += size;
            return b;
        }

        public void freeBucket(Bucket b) throws IOException {
            System.out.println("FreeBucket");
        }
    }
}

