/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.garret.perst.Assert;
import org.garret.perst.ICloneable;
import org.garret.perst.IPersistent;
import org.garret.perst.Storage;
import org.garret.perst.StorageError;

public class Persistent
implements IPersistent,
ICloneable {
    transient Storage storage;
    transient int oid;
    transient int state;
    private static final int RAW = 1;
    private static final int DIRTY = 2;
    private static final int DELETED = 4;

    public synchronized void load() {
        if (this.oid != 0 && (this.state & 1) != 0) {
            this.storage.loadObject(this);
        }
    }

    public synchronized void loadAndModify() {
        this.load();
        this.modify();
    }

    public final boolean isRaw() {
        return (this.state & 1) != 0;
    }

    public final boolean isModified() {
        return (this.state & 2) != 0;
    }

    public final boolean isDeleted() {
        return (this.state & 4) != 0;
    }

    public final boolean isPersistent() {
        return this.oid != 0;
    }

    public void makePersistent(Storage storage) {
        if (this.oid == 0) {
            storage.makePersistent(this);
        }
    }

    public void store() {
        if ((this.state & 1) != 0) {
            throw new StorageError(14);
        }
        if (this.storage != null) {
            this.storage.storeObject(this);
            this.state &= 0xFFFFFFFD;
        }
    }

    public void modify() {
        if ((this.state & 2) == 0 && this.oid != 0) {
            if ((this.state & 1) != 0) {
                throw new StorageError(14);
            }
            Assert.that((this.state & 4) == 0);
            this.storage.modifyObject(this);
            this.state |= 2;
        }
    }

    public Persistent() {
    }

    public Persistent(Storage storage) {
        this.storage = storage;
    }

    public final int getOid() {
        return this.oid;
    }

    public void deallocate() {
        if (this.oid != 0) {
            this.storage.deallocateObject(this);
        }
    }

    public boolean recursiveLoading() {
        return true;
    }

    public final Storage getStorage() {
        return this.storage;
    }

    public boolean equals(Object o) {
        if (this.oid == 0) {
            return super.equals(o);
        }
        return o instanceof IPersistent && ((IPersistent)o).getOid() == this.oid;
    }

    public int hashCode() {
        return this.oid;
    }

    public void onLoad() {
    }

    public void onStore() {
    }

    public void invalidate() {
        this.state &= 0xFFFFFFFD;
        this.state |= 1;
    }

    protected void finalize() {
        if ((this.state & 2) != 0 && this.oid != 0) {
            this.storage.storeFinalizedObject(this);
        }
        this.state = 4;
    }

    public void assignOid(Storage storage, int oid, boolean raw) {
        this.oid = oid;
        this.storage = storage;
        this.state = raw ? (this.state |= 1) : (this.state &= 0xFFFFFFFE);
    }

    protected void clearState() {
        this.state = 0;
        this.oid = 0;
    }

    public Object clone() throws CloneNotSupportedException {
        Persistent p = (Persistent)super.clone();
        p.oid = 0;
        p.state = 0;
        return p;
    }

    public void readExternal(ObjectInput s) throws IOException, ClassNotFoundException {
        this.oid = s.readInt();
    }

    public void writeExternal(ObjectOutput s) throws IOException {
        s.writeInt(this.oid);
    }
}

