/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.garret.perst.IPersistent;
import org.garret.perst.Index;
import org.garret.perst.IterableIterator;
import org.garret.perst.Key;
import org.garret.perst.StorageError;
import org.garret.perst.impl.AltBtree;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AltBtreeCompoundIndex<T extends IPersistent>
extends AltBtree<T>
implements Index<T> {
    int[] types;

    AltBtreeCompoundIndex() {
    }

    AltBtreeCompoundIndex(Class[] keyTypes, boolean unique) {
        this.unique = unique;
        this.type = 12;
        this.types = new int[keyTypes.length];
        for (int i = 0; i < keyTypes.length; ++i) {
            this.types[i] = AltBtreeCompoundIndex.getCompoundKeyComponentType(keyTypes[i]);
        }
    }

    static int getCompoundKeyComponentType(Class c) {
        if (c.equals(Boolean.class)) {
            return 0;
        }
        if (c.equals(Byte.class)) {
            return 1;
        }
        if (c.equals(Character.class)) {
            return 2;
        }
        if (c.equals(Short.class)) {
            return 3;
        }
        if (c.equals(Integer.class)) {
            return 4;
        }
        if (c.equals(Long.class)) {
            return 5;
        }
        if (c.equals(Float.class)) {
            return 6;
        }
        if (c.equals(Double.class)) {
            return 7;
        }
        if (c.equals(String.class)) {
            return 8;
        }
        if (c.equals(Date.class)) {
            return 9;
        }
        if (IPersistent.class.isAssignableFrom(c)) {
            return 10;
        }
        if (Comparable.class.isAssignableFrom(c)) {
            return 12;
        }
        throw new StorageError(8, c);
    }

    @Override
    public Class[] getKeyTypes() {
        Class[] keyTypes = new Class[this.types.length];
        for (int i = 0; i < keyTypes.length; ++i) {
            keyTypes[i] = AltBtreeCompoundIndex.mapKeyType(this.types[i]);
        }
        return keyTypes;
    }

    private Key convertKey(Key key) {
        if (key == null) {
            return null;
        }
        if (key.type != 30) {
            throw new StorageError(9);
        }
        Object[] keyComponents = (Object[])key.oval;
        if (keyComponents.length > this.types.length) {
            throw new StorageError(9);
        }
        boolean isCopy = false;
        for (int i = 0; i < keyComponents.length; ++i) {
            int type = this.types[i];
            if (type != 10 && type != 0) continue;
            if (!isCopy) {
                Object[] newKeyComponents = new Object[keyComponents.length];
                System.arraycopy(keyComponents, 0, newKeyComponents, 0, keyComponents.length);
                keyComponents = newKeyComponents;
                isCopy = true;
            }
            keyComponents[i] = type == 10 ? (Number)new Integer(keyComponents[i] == null ? 0 : ((IPersistent)keyComponents[i]).getOid()) : (Number)new Byte((byte)((Boolean)keyComponents[i] != false ? 1 : 0));
        }
        return new Key(new CompoundKey(keyComponents), key.inclusion != 0);
    }

    @Override
    public ArrayList<T> getList(Key from, Key till) {
        return super.getList(this.convertKey(from), this.convertKey(till));
    }

    @Override
    public T get(Key key) {
        return (T)super.get(this.convertKey(key));
    }

    @Override
    public T remove(Key key) {
        return super.remove(this.convertKey(key));
    }

    @Override
    public void remove(Key key, T obj) {
        super.remove(this.convertKey(key), obj);
    }

    @Override
    public T set(Key key, T obj) {
        return super.set(this.convertKey(key), obj);
    }

    @Override
    public boolean put(Key key, T obj) {
        return super.put(this.convertKey(key), obj);
    }

    @Override
    public IterableIterator<T> iterator(Key from, Key till, int order) {
        return super.iterator(this.convertKey(from), this.convertKey(till), order);
    }

    @Override
    public IterableIterator<Map.Entry<Object, T>> entryIterator(Key from, Key till, int order) {
        return super.entryIterator(this.convertKey(from), this.convertKey(till), order);
    }

    static class CompoundKey
    implements Comparable {
        Object[] keys;

        public int compareTo(Object o) {
            CompoundKey c = (CompoundKey)o;
            int n = this.keys.length < c.keys.length ? this.keys.length : c.keys.length;
            for (int i = 0; i < n; ++i) {
                int diff = ((Comparable)this.keys[i]).compareTo(c.keys[i]);
                if (diff == 0) continue;
                return diff;
            }
            return 0;
        }

        CompoundKey(Object[] keys) {
            this.keys = keys;
        }
    }
}

