/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import org.garret.perst.Assert;
import org.garret.perst.IPersistent;
import org.garret.perst.Index;
import org.garret.perst.IterableIterator;
import org.garret.perst.Key;
import org.garret.perst.StorageError;
import org.garret.perst.impl.Btree;
import org.garret.perst.impl.BtreePage;
import org.garret.perst.impl.ByteBuffer;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.Page;
import org.garret.perst.impl.StorageImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class BtreeCompoundIndex<T extends IPersistent>
extends Btree<T>
implements Index<T> {
    int[] types;

    BtreeCompoundIndex() {
    }

    BtreeCompoundIndex(Class[] keyTypes, boolean unique) {
        this.unique = unique;
        this.type = 21;
        this.types = new int[keyTypes.length];
        for (int i = 0; i < keyTypes.length; ++i) {
            this.types[i] = BtreeCompoundIndex.getCompoundKeyComponentType(keyTypes[i]);
        }
    }

    BtreeCompoundIndex(int[] types, boolean unique) {
        this.types = types;
        this.unique = unique;
    }

    static int getCompoundKeyComponentType(Class c) {
        if (c.equals(Boolean.class)) {
            return 0;
        }
        if (c.equals(Byte.class)) {
            return 1;
        }
        if (c.equals(Character.class)) {
            return 2;
        }
        if (c.equals(Short.class)) {
            return 3;
        }
        if (c.equals(Integer.class)) {
            return 4;
        }
        if (c.equals(Long.class)) {
            return 5;
        }
        if (c.equals(Float.class)) {
            return 6;
        }
        if (c.equals(Double.class)) {
            return 7;
        }
        if (c.equals(String.class)) {
            return 8;
        }
        if (c.equals(Date.class)) {
            return 9;
        }
        if (c.equals(byte[].class)) {
            return 21;
        }
        if (IPersistent.class.isAssignableFrom(c)) {
            return 10;
        }
        throw new StorageError(8, c);
    }

    @Override
    public Class[] getKeyTypes() {
        Class[] keyTypes = new Class[this.types.length];
        for (int i = 0; i < keyTypes.length; ++i) {
            keyTypes[i] = BtreeCompoundIndex.mapKeyType(this.types[i]);
        }
        return keyTypes;
    }

    @Override
    int compareByteArrays(byte[] key, byte[] item, int offs, int lengtn) {
        int o1 = 0;
        int o2 = offs;
        byte[] a1 = key;
        byte[] a2 = item;
        for (int i = 0; i < this.types.length && o1 < key.length; ++i) {
            int diff = 0;
            switch (this.types[i]) {
                case 0: 
                case 1: {
                    diff = a1[o1++] - a2[o2++];
                    break;
                }
                case 3: {
                    diff = Bytes.unpack2(a1, o1) - Bytes.unpack2(a2, o2);
                    o1 += 2;
                    o2 += 2;
                    break;
                }
                case 2: {
                    diff = (char)Bytes.unpack2(a1, o1) - (char)Bytes.unpack2(a2, o2);
                    o1 += 2;
                    o2 += 2;
                    break;
                }
                case 4: 
                case 10: 
                case 14: {
                    int i1 = Bytes.unpack4(a1, o1);
                    int i2 = Bytes.unpack4(a2, o2);
                    diff = i1 < i2 ? -1 : (i1 == i2 ? 0 : 1);
                    o1 += 4;
                    o2 += 4;
                    break;
                }
                case 5: 
                case 9: {
                    long l1 = Bytes.unpack8(a1, o1);
                    long l2 = Bytes.unpack8(a2, o2);
                    diff = l1 < l2 ? -1 : (l1 == l2 ? 0 : 1);
                    o1 += 8;
                    o2 += 8;
                    break;
                }
                case 6: {
                    float f1 = Float.intBitsToFloat(Bytes.unpack4(a1, o1));
                    float f2 = Float.intBitsToFloat(Bytes.unpack4(a2, o2));
                    diff = f1 < f2 ? -1 : (f1 == f2 ? 0 : 1);
                    o1 += 4;
                    o2 += 4;
                    break;
                }
                case 7: {
                    double d1 = Double.longBitsToDouble(Bytes.unpack8(a1, o1));
                    double d2 = Double.longBitsToDouble(Bytes.unpack8(a2, o2));
                    diff = d1 < d2 ? -1 : (d1 == d2 ? 0 : 1);
                    o1 += 8;
                    o2 += 8;
                    break;
                }
                case 8: {
                    int len;
                    int len1 = Bytes.unpack4(a1, o1);
                    int len2 = Bytes.unpack4(a2, o2);
                    o1 += 4;
                    o2 += 4;
                    int n = len = len1 < len2 ? len1 : len2;
                    while (--len >= 0) {
                        diff = (char)Bytes.unpack2(a1, o1) - (char)Bytes.unpack2(a2, o2);
                        if (diff != 0) {
                            return diff;
                        }
                        o1 += 2;
                        o2 += 2;
                    }
                    diff = len1 - len2;
                    break;
                }
                case 21: {
                    int len;
                    int len1 = Bytes.unpack4(a1, o1);
                    int len2 = Bytes.unpack4(a2, o2);
                    o1 += 4;
                    o2 += 4;
                    int n = len = len1 < len2 ? len1 : len2;
                    while (--len >= 0) {
                        if ((diff = a1[o1++] - a2[o2++]) == 0) continue;
                        return diff;
                    }
                    diff = len1 - len2;
                    break;
                }
                default: {
                    Assert.failed("Invalid type");
                }
            }
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    @Override
    Object unpackByteArrayKey(Page pg, int pos) {
        int offs = 4 + BtreePage.getKeyStrOffs(pg, pos);
        byte[] data = pg.data;
        Object[] values = new Object[this.types.length];
        for (int i = 0; i < this.types.length; ++i) {
            Object v = null;
            switch (this.types[i]) {
                case 0: {
                    v = data[offs++] != 0;
                    break;
                }
                case 1: {
                    v = new Byte(data[offs++]);
                    break;
                }
                case 3: {
                    v = new Short(Bytes.unpack2(data, offs));
                    offs += 2;
                    break;
                }
                case 2: {
                    v = new Character((char)Bytes.unpack2(data, offs));
                    offs += 2;
                    break;
                }
                case 4: {
                    v = new Integer(Bytes.unpack4(data, offs));
                    offs += 4;
                    break;
                }
                case 10: {
                    int oid = Bytes.unpack4(data, offs);
                    v = oid == 0 ? null : ((StorageImpl)this.getStorage()).lookupObject(oid, null);
                    offs += 4;
                    break;
                }
                case 5: {
                    v = new Long(Bytes.unpack8(data, offs));
                    offs += 8;
                    break;
                }
                case 9: {
                    long msec = Bytes.unpack8(data, offs);
                    v = msec == -1L ? null : new Date(msec);
                    offs += 8;
                    break;
                }
                case 6: {
                    v = new Float(Float.intBitsToFloat(Bytes.unpack4(data, offs)));
                    offs += 4;
                    break;
                }
                case 7: {
                    v = new Double(Double.longBitsToDouble(Bytes.unpack8(data, offs)));
                    offs += 8;
                    break;
                }
                case 8: {
                    int len = Bytes.unpack4(data, offs);
                    offs += 4;
                    char[] sval = new char[len];
                    for (int j = 0; j < len; ++j) {
                        sval[j] = (char)Bytes.unpack2(data, offs);
                        offs += 2;
                    }
                    v = new String(sval);
                    break;
                }
                case 21: {
                    int len = Bytes.unpack4(data, offs);
                    byte[] bval = new byte[len];
                    System.arraycopy(data, offs += 4, bval, 0, len);
                    offs += len;
                    break;
                }
                default: {
                    Assert.failed("Invalid type");
                }
            }
            values[i] = v;
        }
        return values;
    }

    private Key convertKey(Key key) {
        if (key == null) {
            return null;
        }
        if (key.type != 30) {
            throw new StorageError(9);
        }
        Object[] values = (Object[])key.oval;
        ByteBuffer buf = new ByteBuffer();
        int dst = 0;
        block15: for (int i = 0; i < values.length; ++i) {
            Object v = values[i];
            switch (this.types[i]) {
                case 0: {
                    buf.extend(dst + 1);
                    buf.arr[dst++] = (byte)((Boolean)v != false ? 1 : 0);
                    continue block15;
                }
                case 1: {
                    buf.extend(dst + 1);
                    buf.arr[dst++] = ((Number)v).byteValue();
                    continue block15;
                }
                case 3: {
                    buf.extend(dst + 2);
                    Bytes.pack2(buf.arr, dst, ((Number)v).shortValue());
                    dst += 2;
                    continue block15;
                }
                case 2: {
                    buf.extend(dst + 2);
                    Bytes.pack2(buf.arr, dst, v instanceof Number ? ((Number)v).shortValue() : (short)((Character)v).charValue());
                    dst += 2;
                    continue block15;
                }
                case 4: {
                    buf.extend(dst + 4);
                    Bytes.pack4(buf.arr, dst, ((Number)v).intValue());
                    dst += 4;
                    continue block15;
                }
                case 10: {
                    buf.extend(dst + 4);
                    Bytes.pack4(buf.arr, dst, v == null ? 0 : ((IPersistent)v).getOid());
                    dst += 4;
                    continue block15;
                }
                case 5: {
                    buf.extend(dst + 8);
                    Bytes.pack8(buf.arr, dst, ((Number)v).longValue());
                    dst += 8;
                    continue block15;
                }
                case 9: {
                    buf.extend(dst + 8);
                    Bytes.pack8(buf.arr, dst, v == null ? -1L : ((Date)v).getTime());
                    dst += 8;
                    continue block15;
                }
                case 6: {
                    buf.extend(dst + 4);
                    Bytes.pack4(buf.arr, dst, Float.floatToIntBits(((Number)v).floatValue()));
                    dst += 4;
                    continue block15;
                }
                case 7: {
                    buf.extend(dst + 8);
                    Bytes.pack8(buf.arr, dst, Double.doubleToLongBits(((Number)v).doubleValue()));
                    dst += 8;
                    continue block15;
                }
                case 14: {
                    buf.extend(dst + 4);
                    Bytes.pack4(buf.arr, dst, ((Enum)v).ordinal());
                    dst += 4;
                    continue block15;
                }
                case 8: {
                    int len;
                    buf.extend(dst + 4);
                    if (v != null) {
                        String str = (String)v;
                        len = str.length();
                        Bytes.pack4(buf.arr, dst, len);
                        buf.extend((dst += 4) + len * 2);
                        for (int j = 0; j < len; ++j) {
                            Bytes.pack2(buf.arr, dst, (short)str.charAt(j));
                            dst += 2;
                        }
                        continue block15;
                    }
                    Bytes.pack4(buf.arr, dst, 0);
                    dst += 4;
                    continue block15;
                }
                case 21: {
                    int len;
                    buf.extend(dst + 4);
                    if (v != null) {
                        byte[] arr = (byte[])v;
                        len = arr.length;
                        Bytes.pack4(buf.arr, dst, len);
                        buf.extend((dst += 4) + len);
                        System.arraycopy(arr, 0, buf.arr, dst, len);
                        dst += len;
                        continue block15;
                    }
                    Bytes.pack4(buf.arr, dst, 0);
                    dst += 4;
                    continue block15;
                }
                default: {
                    Assert.failed("Invalid type");
                }
            }
        }
        return new Key(buf.toArray(), key.inclusion != 0);
    }

    @Override
    public ArrayList<T> getList(Key from, Key till) {
        return super.getList(this.convertKey(from), this.convertKey(till));
    }

    @Override
    public T get(Key key) {
        return (T)super.get(this.convertKey(key));
    }

    @Override
    public T remove(Key key) {
        return super.remove(this.convertKey(key));
    }

    @Override
    public void remove(Key key, T obj) {
        super.remove(this.convertKey(key), obj);
    }

    @Override
    public T set(Key key, T obj) {
        return super.set(this.convertKey(key), obj);
    }

    @Override
    public boolean put(Key key, T obj) {
        return super.put(this.convertKey(key), obj);
    }

    @Override
    public IterableIterator<T> iterator(Key from, Key till, int order) {
        return super.iterator(this.convertKey(from), this.convertKey(till), order);
    }

    @Override
    public IterableIterator<Map.Entry<Object, T>> entryIterator(Key from, Key till, int order) {
        return super.entryIterator(this.convertKey(from), this.convertKey(till), order);
    }
}

