/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.util.Date;
import org.garret.perst.impl.BinOpNode;
import org.garret.perst.impl.FilterIterator;
import org.garret.perst.impl.Node;

class CompareNode
extends Node {
    Node o1;
    Node o2;
    Node o3;

    public boolean equals(Object o) {
        return o instanceof CompareNode && super.equals(o) && ((CompareNode)o).o1.equals(this.o1) && ((CompareNode)o).o2.equals(this.o2) && CompareNode.equalObjects(((CompareNode)o).o3, this.o3);
    }

    boolean evaluateBool(FilterIterator t) {
        switch (this.tag) {
            case 137: {
                Object val = this.o1.evaluateObj(t);
                return BinOpNode.compare(val, this.o2.evaluateObj(t)) >= 0 && BinOpNode.compare(val, this.o3.evaluateObj(t)) <= 0;
            }
            case 17: {
                long val = this.o1.evaluateInt(t);
                return val >= this.o2.evaluateInt(t) && val <= this.o3.evaluateInt(t);
            }
            case 24: {
                double val = this.o1.evaluateReal(t);
                return val >= this.o2.evaluateReal(t) && val <= this.o3.evaluateReal(t);
            }
            case 31: {
                String val = this.o1.evaluateStr(t);
                return val.compareTo(this.o2.evaluateStr(t)) >= 0 && val.compareTo(this.o3.evaluateStr(t)) <= 0;
            }
            case 151: {
                Date val = this.o1.evaluateDate(t);
                return val.compareTo(this.o2.evaluateDate(t)) >= 0 && val.compareTo(this.o3.evaluateDate(t)) <= 0;
            }
            case 32: {
                String str = this.o1.evaluateStr(t);
                String pat = this.o2.evaluateStr(t);
                int pi = 0;
                int si = 0;
                int pn = pat.length();
                int sn = str.length();
                int wildcard = -1;
                int strpos = -1;
                while (true) {
                    if (pi < pn && pat.charAt(pi) == '%') {
                        wildcard = ++pi;
                        strpos = si;
                        continue;
                    }
                    if (si == sn) {
                        return pi == pn;
                    }
                    if (pi < pn && (str.charAt(si) == pat.charAt(pi) || pat.charAt(pi) == '_')) {
                        ++si;
                        ++pi;
                        continue;
                    }
                    if (wildcard < 0) break;
                    si = ++strpos;
                    pi = wildcard;
                }
                return false;
            }
            case 33: {
                String str = this.o1.evaluateStr(t);
                String pat = this.o2.evaluateStr(t);
                char escape = this.o3.evaluateStr(t).charAt(0);
                int pi = 0;
                int si = 0;
                int pn = pat.length();
                int sn = str.length();
                int wildcard = -1;
                int strpos = -1;
                while (true) {
                    if (pi < pn && pat.charAt(pi) == '%') {
                        wildcard = ++pi;
                        strpos = si;
                        continue;
                    }
                    if (si == sn) {
                        return pi == pn;
                    }
                    if (pi + 1 < pn && pat.charAt(pi) == escape && pat.charAt(pi + 1) == str.charAt(si)) {
                        ++si;
                        pi += 2;
                        continue;
                    }
                    if (pi < pn && pat.charAt(pi) != escape && (str.charAt(si) == pat.charAt(pi) || pat.charAt(pi) == '_')) {
                        ++si;
                        ++pi;
                        continue;
                    }
                    if (wildcard < 0) break;
                    si = ++strpos;
                    pi = wildcard;
                }
                return false;
            }
        }
        throw new Error("Invalid tag " + this.tag);
    }

    CompareNode(int tag, Node a, Node b, Node c) {
        super(0, tag);
        this.o1 = a;
        this.o2 = b;
        this.o3 = c;
    }
}

