/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StreamTokenizer;
import org.garret.perst.IFile;
import org.garret.perst.StorageError;
import org.garret.perst.impl.OSFile;

public class MultiFile
implements IFile {
    MultiFileSegment[] segment;
    long fixedSize;
    int currSeg;
    boolean noFlush;

    long seek(long pos) {
        this.currSeg = 0;
        while (pos >= this.segment[this.currSeg].size) {
            pos -= this.segment[this.currSeg].size;
            ++this.currSeg;
        }
        return pos;
    }

    public void write(long pos, byte[] b) {
        pos = this.seek(pos);
        this.segment[this.currSeg].f.write(pos, b);
    }

    public int read(long pos, byte[] b) {
        pos = this.seek(pos);
        return this.segment[this.currSeg].f.read(pos, b);
    }

    public void sync() {
        if (!this.noFlush) {
            int i = this.segment.length;
            while (--i >= 0) {
                this.segment[i].f.sync();
            }
        }
    }

    public boolean tryLock(boolean shared) {
        return this.segment[0].f.tryLock(shared);
    }

    public void lock(boolean shared) {
        this.segment[0].f.lock(shared);
    }

    public void unlock() {
        this.segment[0].f.unlock();
    }

    public void close() {
        int i = this.segment.length;
        while (--i >= 0) {
            this.segment[i].f.close();
        }
    }

    public MultiFile(String[] segmentPath, long[] segmentSize, boolean readOnly, boolean noFlush) {
        this.noFlush = noFlush;
        this.segment = new MultiFileSegment[segmentPath.length];
        for (int i = 0; i < this.segment.length; ++i) {
            MultiFileSegment seg = new MultiFileSegment();
            seg.f = new OSFile(segmentPath[i], readOnly, noFlush);
            seg.size = segmentSize[i];
            this.fixedSize += seg.size;
            this.segment[i] = seg;
        }
        this.fixedSize -= this.segment[this.segment.length - 1].size;
        this.segment[this.segment.length - 1].size = Long.MAX_VALUE;
    }

    public MultiFile(MultiFileSegment[] segments) {
        this.segment = segments;
        for (int i = 0; i < segments.length; ++i) {
            this.fixedSize += segments[i].size;
        }
        this.fixedSize -= this.segment[this.segment.length - 1].size;
        this.segment[this.segment.length - 1].size = Long.MAX_VALUE;
    }

    public MultiFile(String filePath, boolean readOnly, boolean noFlush) {
        try {
            StreamTokenizer in = new StreamTokenizer(new BufferedReader(new FileReader(filePath)));
            File dir = new File(filePath).getParentFile();
            this.noFlush = noFlush;
            this.segment = new MultiFileSegment[0];
            int tkn = in.nextToken();
            do {
                File f;
                MultiFileSegment seg = new MultiFileSegment();
                if (tkn != -3 && tkn != 34) {
                    throw new StorageError(3, "Multifile segment name expected");
                }
                String path = in.sval;
                tkn = in.nextToken();
                if (tkn != -1) {
                    if (tkn != -2) {
                        throw new StorageError(3, "Multifile segment size expected");
                    }
                    seg.size = (long)in.nval * 1024L;
                    tkn = in.nextToken();
                }
                this.fixedSize += seg.size;
                if (dir != null && !(f = new File(path)).isAbsolute()) {
                    f = new File(dir, path);
                    path = f.getPath();
                }
                seg.f = new OSFile(path, readOnly, noFlush);
                MultiFileSegment[] newSegment = new MultiFileSegment[this.segment.length + 1];
                System.arraycopy(this.segment, 0, newSegment, 0, this.segment.length);
                newSegment[this.segment.length] = seg;
                this.segment = newSegment;
            } while (tkn != -1);
            this.fixedSize -= this.segment[this.segment.length - 1].size;
            this.segment[this.segment.length - 1].size = Long.MAX_VALUE;
        }
        catch (IOException x) {
            throw new StorageError(3);
        }
    }

    public long length() {
        return this.fixedSize + this.segment[this.segment.length - 1].f.length();
    }

    public static class MultiFileSegment {
        IFile f;
        long size;
    }
}

