/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import org.garret.perst.Assert;
import org.garret.perst.IPersistent;
import org.garret.perst.IPersistentList;
import org.garret.perst.Link;
import org.garret.perst.Persistent;
import org.garret.perst.PersistentCollection;
import org.garret.perst.PersistentIterator;
import org.garret.perst.Storage;
import org.garret.perst.impl.SubList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PersistentListImpl<E extends IPersistent>
extends PersistentCollection<E>
implements IPersistentList<E> {
    int nElems;
    ListPage root;
    transient int modCount;
    static final int nLeafPageItems = 1020;
    static final int nIntermediatePageItems = 509;

    @Override
    public E get(int i) {
        if (i < 0 || i >= this.nElems) {
            throw new IndexOutOfBoundsException("index=" + i + ", size=" + this.nElems);
        }
        return (E)((IPersistent)this.root.get(i));
    }

    E getPosition(TreePosition pos, int i) {
        if (i < 0 || i >= this.nElems) {
            throw new IndexOutOfBoundsException("index=" + i + ", size=" + this.nElems);
        }
        if (pos.page != null && i >= pos.index && i < pos.index + pos.page.nItems) {
            return (E)pos.page.items.get(i - pos.index);
        }
        pos.index = i;
        return (E)this.root.getPosition(pos, i);
    }

    IPersistent getRawPosition(TreePosition pos, int i) {
        if (i < 0 || i >= this.nElems) {
            throw new IndexOutOfBoundsException("index=" + i + ", size=" + this.nElems);
        }
        if (pos.page != null && i >= pos.index && i < pos.index + pos.page.nItems) {
            return pos.page.items.getRaw(i - pos.index);
        }
        pos.index = i;
        return this.root.getRawPosition(pos, i);
    }

    @Override
    public E set(int i, E obj) {
        if (i < 0 || i >= this.nElems) {
            throw new IndexOutOfBoundsException("index=" + i + ", size=" + this.nElems);
        }
        return (E)((IPersistent)this.root.set(i, obj));
    }

    @Override
    public Object[] toArray() {
        int n = this.nElems;
        Object[] arr = new Object[n];
        ListIterator<E> iterator = this.listIterator(0);
        for (int i = 0; i < n; ++i) {
            arr[i] = iterator.next();
        }
        return arr;
    }

    @Override
    public <T> T[] toArray(T[] arr) {
        int n = this.nElems;
        if (arr.length < n) {
            arr = (Object[])Array.newInstance(arr.getClass().getComponentType(), n);
        }
        ListIterator<E> iterator = this.listIterator(0);
        for (int i = 0; i < n; ++i) {
            arr[i] = iterator.next();
        }
        return arr;
    }

    @Override
    public boolean isEmpty() {
        return this.nElems == 0;
    }

    @Override
    public int size() {
        return this.nElems;
    }

    @Override
    public boolean contains(Object o) {
        Iterator<E> e = this.iterator();
        if (o == null) {
            while (e.hasNext()) {
                if (e.next() != null) continue;
                return true;
            }
        } else {
            while (e.hasNext()) {
                if (!o.equals(e.next())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean add(E o) {
        this.add(this.nElems, o);
        return true;
    }

    @Override
    public void add(int i, E o) {
        if (i < 0 || i > this.nElems) {
            throw new IndexOutOfBoundsException("index=" + i + ", size=" + this.nElems);
        }
        E obj = o;
        ListPage overflow = this.root.add(i, (IPersistent)obj);
        if (overflow != null) {
            ListIntermediatePage pg = new ListIntermediatePage(this.getStorage());
            pg.setItem(0, overflow);
            pg.items.setObject(1, this.root);
            pg.nChildren[1] = Integer.MAX_VALUE;
            pg.nItems = 2;
            this.root = pg;
        }
        ++this.nElems;
        ++this.modCount;
        this.modify();
    }

    @Override
    public E remove(int i) {
        if (i < 0 || i >= this.nElems) {
            throw new IndexOutOfBoundsException("index=" + i + ", size=" + this.nElems);
        }
        IPersistent obj = this.root.remove(i);
        if (this.root.nItems == 1 && this.root instanceof ListIntermediatePage) {
            ListPage newRoot = (ListPage)this.root.items.get(0);
            this.root.deallocate();
            this.root = newRoot;
        }
        --this.nElems;
        ++this.modCount;
        this.modify();
        return (E)obj;
    }

    @Override
    public void clear() {
        ++this.modCount;
        this.root.prune();
        this.root = new ListPage(this.getStorage());
        this.nElems = 0;
        this.modify();
    }

    @Override
    public int indexOf(Object o) {
        ListIterator<E> e = this.listIterator();
        if (o == null) {
            while (e.hasNext()) {
                if (e.next() != null) continue;
                return e.previousIndex();
            }
        } else {
            while (e.hasNext()) {
                if (!o.equals(e.next())) continue;
                return e.previousIndex();
            }
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        ListIterator<E> e = this.listIterator(this.size());
        if (o == null) {
            while (e.hasPrevious()) {
                if (e.previous() != null) continue;
                return e.nextIndex();
            }
        } else {
            while (e.hasPrevious()) {
                if (!o.equals(e.previous())) continue;
                return e.nextIndex();
            }
        }
        return -1;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        boolean modified = false;
        Iterator<E> e = c.iterator();
        while (e.hasNext()) {
            this.add(index++, (E)((IPersistent)e.next()));
            modified = true;
        }
        return modified;
    }

    @Override
    public Iterator<E> iterator() {
        return new Itr();
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException("Index: " + index);
        }
        return new ListItr(index);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new SubList(this, fromIndex, toIndex);
    }

    protected void removeRange(int fromIndex, int toIndex) {
        while (fromIndex < toIndex) {
            this.remove(fromIndex);
            --toIndex;
        }
    }

    PersistentListImpl() {
    }

    PersistentListImpl(Storage storage) {
        super(storage);
        this.root = new ListPage(storage);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ListItr
    extends Itr
    implements ListIterator<E> {
        ListItr(int index) {
            this.cursor = index;
        }

        @Override
        public boolean hasPrevious() {
            return this.cursor != 0;
        }

        @Override
        public E previous() {
            this.checkForComodification();
            try {
                int i = this.cursor - 1;
                Object previous = PersistentListImpl.this.getPosition(this, i);
                this.lastRet = this.cursor = i;
                return previous;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public int nextIndex() {
            return this.cursor;
        }

        @Override
        public int previousIndex() {
            return this.cursor - 1;
        }

        @Override
        public void set(E o) {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                PersistentListImpl.this.set(this.lastRet, o);
                this.expectedModCount = PersistentListImpl.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void add(E o) {
            this.checkForComodification();
            try {
                PersistentListImpl.this.add(this.cursor++, o);
                this.lastRet = -1;
                this.page = null;
                this.expectedModCount = PersistentListImpl.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Itr
    extends TreePosition
    implements PersistentIterator,
    Iterator<E> {
        int cursor = 0;
        int lastRet = -1;
        int expectedModCount;

        private Itr() {
            this.expectedModCount = PersistentListImpl.this.modCount;
        }

        @Override
        public boolean hasNext() {
            return this.cursor != PersistentListImpl.this.size();
        }

        @Override
        public int nextOid() {
            this.checkForComodification();
            try {
                int oid = PersistentListImpl.this.getRawPosition(this, this.cursor).getOid();
                this.lastRet = this.cursor++;
                return oid;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public E next() {
            this.checkForComodification();
            try {
                Object next = PersistentListImpl.this.getPosition(this, this.cursor);
                this.lastRet = this.cursor++;
                return next;
            }
            catch (IndexOutOfBoundsException e) {
                this.checkForComodification();
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            if (this.lastRet == -1) {
                throw new IllegalStateException();
            }
            this.checkForComodification();
            try {
                PersistentListImpl.this.remove(this.lastRet);
                if (this.lastRet < this.cursor) {
                    --this.cursor;
                }
                this.page = null;
                this.lastRet = -1;
                this.expectedModCount = PersistentListImpl.this.modCount;
            }
            catch (IndexOutOfBoundsException e) {
                throw new ConcurrentModificationException();
            }
        }

        final void checkForComodification() {
            if (PersistentListImpl.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }
    }

    static class ListIntermediatePage
    extends ListPage {
        int[] nChildren;

        IPersistent getPosition(TreePosition pos, int i) {
            int j = 0;
            while (i >= this.nChildren[j]) {
                i -= this.nChildren[j];
                ++j;
            }
            return ((ListPage)this.items.get(j)).getPosition(pos, i);
        }

        IPersistent getRawPosition(TreePosition pos, int i) {
            int j = 0;
            while (i >= this.nChildren[j]) {
                i -= this.nChildren[j];
                ++j;
            }
            return ((ListPage)this.items.get(j)).getRawPosition(pos, i);
        }

        Object get(int i) {
            int j = 0;
            while (i >= this.nChildren[j]) {
                i -= this.nChildren[j];
                ++j;
            }
            return ((ListPage)this.items.get(j)).get(i);
        }

        Object set(int i, Object obj) {
            int j = 0;
            while (i >= this.nChildren[j]) {
                i -= this.nChildren[j];
                ++j;
            }
            return ((ListPage)this.items.get(j)).set(i, obj);
        }

        ListPage add(int i, IPersistent obj) {
            int j = 0;
            while (i >= this.nChildren[j]) {
                i -= this.nChildren[j];
                ++j;
            }
            ListPage pg = (ListPage)this.items.get(j);
            ListPage overflow = pg.add(i, obj);
            if (overflow != null) {
                this.countChildren(j, pg);
                overflow = super.add(j, overflow);
            } else {
                this.modify();
                if (this.nChildren[j] != Integer.MAX_VALUE) {
                    int n = j;
                    this.nChildren[n] = this.nChildren[n] + 1;
                }
            }
            return overflow;
        }

        IPersistent remove(int i) {
            int j = 0;
            while (i >= this.nChildren[j]) {
                i -= this.nChildren[j];
                ++j;
            }
            ListPage pg = (ListPage)this.items.get(j);
            IPersistent obj = pg.remove(i);
            this.modify();
            if (pg.underflow()) {
                this.handlePageUnderflow(pg, j);
            } else if (this.nChildren[j] != Integer.MAX_VALUE) {
                int n = j;
                this.nChildren[n] = this.nChildren[n] - 1;
            }
            return obj;
        }

        void countChildren(int i, ListPage pg) {
            if (this.nChildren[i] != Integer.MAX_VALUE) {
                this.nChildren[i] = pg.size();
            }
        }

        void prune() {
            for (int i = 0; i < this.nItems; ++i) {
                ((ListPage)this.items.get(i)).prune();
            }
            this.deallocate();
        }

        void handlePageUnderflow(ListPage a, int r) {
            int an = a.nItems;
            int max = a.getMaxItems();
            if (r + 1 < this.nItems) {
                ListPage b = (ListPage)this.items.get(r + 1);
                int bn = b.nItems;
                Assert.that(bn >= an);
                if (an + bn > max) {
                    int i = bn - (an + bn >> 1);
                    b.modify();
                    a.copy(an, b, 0, i);
                    b.copy(0, b, i, bn - i);
                    b.clear(bn - i, i);
                    b.nItems -= i;
                    a.nItems += i;
                    this.nChildren[r] = a.size();
                    this.countChildren(r + 1, b);
                } else {
                    a.copy(an, b, 0, bn);
                    a.nItems += bn;
                    --this.nItems;
                    this.nChildren[r] = this.nChildren[r + 1];
                    this.copy(r + 1, this, r + 2, this.nItems - r - 1);
                    this.countChildren(r, a);
                    this.items.set(this.nItems, null);
                    b.deallocate();
                }
            } else {
                ListPage b = (ListPage)this.items.get(r - 1);
                int bn = b.nItems;
                Assert.that(bn >= an);
                b.modify();
                if (an + bn > max) {
                    int i = bn - (an + bn >> 1);
                    a.copy(i, a, 0, an);
                    a.copy(0, b, bn - i, i);
                    b.clear(bn - i, i);
                    b.nItems -= i;
                    a.nItems += i;
                    this.nChildren[r - 1] = b.size();
                    this.countChildren(r, a);
                } else {
                    b.copy(bn, a, 0, an);
                    b.nItems += an;
                    --this.nItems;
                    this.nChildren[r - 1] = this.nChildren[r];
                    this.countChildren(r - 1, b);
                    this.items.set(r, null);
                    a.deallocate();
                }
            }
        }

        void copy(int dstOffs, ListPage src, int srcOffs, int len) {
            super.copy(dstOffs, src, srcOffs, len);
            System.arraycopy(((ListIntermediatePage)src).nChildren, srcOffs, this.nChildren, dstOffs, len);
        }

        int getMaxItems() {
            return 509;
        }

        void setItem(int i, IPersistent obj) {
            super.setItem(i, obj);
            this.nChildren[i] = ((ListPage)obj).size();
        }

        int size() {
            if (this.nChildren[this.nItems - 1] == Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            int n = 0;
            for (int i = 0; i < this.nItems; ++i) {
                n += this.nChildren[i];
            }
            return n;
        }

        ListPage clonePage() {
            return new ListIntermediatePage(this.getStorage());
        }

        ListIntermediatePage() {
        }

        ListIntermediatePage(Storage storage) {
            super(storage);
            this.nChildren = new int[509];
        }
    }

    static class ListPage
    extends Persistent {
        int nItems;
        Link items;

        Object get(int i) {
            return this.items.get(i);
        }

        IPersistent getPosition(TreePosition pos, int i) {
            pos.page = this;
            pos.index -= i;
            return this.items.get(i);
        }

        IPersistent getRawPosition(TreePosition pos, int i) {
            pos.page = this;
            pos.index -= i;
            return this.items.getRaw(i);
        }

        Object set(int i, Object obj) {
            return this.items.set(i, (IPersistent)obj);
        }

        void clear(int i, int len) {
            while (--len >= 0) {
                this.items.setObject(i++, null);
            }
        }

        void prune() {
            this.deallocate();
        }

        void copy(int dstOffs, ListPage src, int srcOffs, int len) {
            System.arraycopy(src.items.toRawArray(), srcOffs, this.items.toRawArray(), dstOffs, len);
        }

        int getMaxItems() {
            return 1020;
        }

        void setItem(int i, IPersistent obj) {
            this.items.setObject(i, obj);
        }

        int size() {
            return this.nItems;
        }

        ListPage clonePage() {
            return new ListPage(this.getStorage());
        }

        ListPage() {
        }

        ListPage(Storage storage) {
            super(storage);
            int max = this.getMaxItems();
            this.items = storage.createLink(max);
            this.items.setSize(max);
        }

        IPersistent remove(int i) {
            Object obj = this.items.get(i);
            --this.nItems;
            this.copy(i, this, i + 1, this.nItems - i);
            this.items.setObject(this.nItems, null);
            this.modify();
            return obj;
        }

        boolean underflow() {
            return this.nItems < this.getMaxItems() / 2;
        }

        ListPage add(int i, IPersistent obj) {
            int max = this.getMaxItems();
            this.modify();
            if (this.nItems < max) {
                this.copy(i + 1, this, i, this.nItems - i);
                this.setItem(i, obj);
                ++this.nItems;
                return null;
            }
            ListPage b = this.clonePage();
            int m = max / 2;
            if (i < m) {
                b.copy(0, this, 0, i);
                b.copy(i + 1, this, i, m - i - 1);
                this.copy(0, this, m - 1, max - m + 1);
                b.setItem(i, obj);
            } else {
                b.copy(0, this, 0, m);
                this.copy(0, this, m, i - m);
                this.copy(i - m + 1, this, i, max - i);
                this.setItem(i - m, obj);
            }
            this.clear(max - m + 1, m - 1);
            this.nItems = max - m + 1;
            b.nItems = m;
            return b;
        }
    }

    static class TreePosition {
        ListPage page;
        int index;

        TreePosition() {
        }
    }
}

