/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import org.garret.perst.IFile;
import org.garret.perst.IResource;
import org.garret.perst.PersistentResource;
import org.garret.perst.ReplicationSlaveStorage;
import org.garret.perst.StorageError;
import org.garret.perst.impl.Bytes;
import org.garret.perst.impl.Page;
import org.garret.perst.impl.StorageImpl;

public abstract class ReplicationSlaveStorageImpl
extends StorageImpl
implements ReplicationSlaveStorage,
Runnable {
    static final int REPL_CLOSE = -1;
    static final int REPL_SYNC = -2;
    protected static final int DB_HDR_CURR_INDEX_OFFSET = 0;
    protected static final int DB_HDR_DIRTY_OFFSET = 1;
    protected static final int DB_HDR_INITIALIZED_OFFSET = 2;
    protected static final int PAGE_DATA_OFFSET = 8;
    public static int LINGER_TIME = 10;
    protected InputStream in;
    protected OutputStream out;
    protected Socket socket;
    protected boolean outOfSync;
    protected boolean initialized;
    protected boolean listening;
    protected Object sync;
    protected Object init;
    protected Object done;
    protected Object commit;
    protected int prevIndex;
    protected IResource lock;
    protected Thread thread;

    public void open(IFile file, int pagePoolSize) {
        if (this.opened) {
            throw new StorageError(2);
        }
        this.initialize(file, pagePoolSize);
        this.lock = new PersistentResource();
        this.init = new Object();
        this.sync = new Object();
        this.done = new Object();
        this.commit = new Object();
        this.listening = true;
        this.connect();
        this.thread = new Thread(this);
        this.thread.start();
        this.waitSynchronizationCompletion();
        this.waitInitializationCompletion();
        this.opened = true;
        this.beginThreadTransaction(3);
        this.reloadScheme();
        this.endThreadTransaction();
    }

    public boolean isConnected() {
        return this.socket != null;
    }

    public void beginThreadTransaction(int mode) {
        if (mode != 3) {
            throw new IllegalArgumentException("Illegal transaction mode");
        }
        this.lock.sharedLock();
        Page pg = this.pool.getPage(0L);
        this.header.unpack(pg.data);
        this.pool.unfix(pg);
        this.currIndex = 1 - this.header.curr;
        this.committedIndexSize = this.currIndexSize = this.header.root[1 - this.currIndex].indexUsed;
        this.usedSize = this.header.root[this.currIndex].size;
        this.objectCache.clear();
    }

    public void endThreadTransaction(int maxDelay) {
        this.lock.unlock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitSynchronizationCompletion() {
        try {
            Object object = this.sync;
            synchronized (object) {
                while (this.outOfSync) {
                    this.sync.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitInitializationCompletion() {
        try {
            Object object = this.init;
            synchronized (object) {
                while (!this.initialized) {
                    this.init.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForModification() {
        try {
            Object object = this.commit;
            synchronized (object) {
                if (this.socket != null) {
                    this.commit.wait();
                }
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public boolean handleError() {
        return this.listener != null ? this.listener.replicationError(null) : false;
    }

    void connect() {
        try {
            this.socket = this.getSocket();
            try {
                this.socket.setSoLinger(true, LINGER_TIME);
            }
            catch (NoSuchMethodError er) {
                // empty catch block
            }
            try {
                this.socket.setTcpNoDelay(true);
            }
            catch (Exception x) {
                // empty catch block
            }
            this.in = this.socket.getInputStream();
            if (this.replicationAck) {
                this.out = this.socket.getOutputStream();
            }
        }
        catch (IOException x) {
            this.socket = null;
            this.in = null;
        }
    }

    abstract Socket getSocket() throws IOException;

    void cancelIO() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        byte[] buf = new byte[4104];
        while (this.listening) {
            Object object;
            int offs = 0;
            do {
                int rc;
                try {
                    rc = this.in.read(buf, offs, buf.length - offs);
                }
                catch (IOException x) {
                    rc = -1;
                }
                Object object2 = this.done;
                synchronized (object2) {
                    if (!this.listening) {
                        return;
                    }
                }
                if (rc < 0) {
                    if (this.handleError()) {
                        this.connect();
                        continue;
                    }
                    return;
                }
                offs += rc;
            } while (offs < buf.length);
            long pos = Bytes.unpack8(buf, 0);
            boolean transactionCommit = false;
            if (pos == 0L) {
                if (this.replicationAck) {
                    try {
                        this.out.write(buf, 0, 1);
                    }
                    catch (IOException x) {
                        this.handleError();
                    }
                }
                if (buf[8] != this.prevIndex) {
                    this.prevIndex = buf[8];
                    this.lock.exclusiveLock();
                    transactionCommit = true;
                }
            } else {
                Object x;
                if (pos == -2L) {
                    x = this.sync;
                    synchronized (x) {
                        this.outOfSync = false;
                        this.sync.notify();
                        continue;
                    }
                }
                if (pos == -1L) {
                    x = this.commit;
                    synchronized (x) {
                        this.hangup();
                        this.commit.notifyAll();
                    }
                    return;
                }
            }
            Page pg = this.pool.putPage(pos);
            System.arraycopy(buf, 8, pg.data, 0, 4096);
            this.pool.unfix(pg);
            if (pos != 0L) continue;
            if (!this.initialized && buf[10] != 0) {
                object = this.init;
                synchronized (object) {
                    this.initialized = true;
                    this.init.notify();
                }
            }
            if (!transactionCommit) continue;
            this.lock.unlock();
            object = this.commit;
            synchronized (object) {
                this.commit.notifyAll();
            }
            this.pool.flush();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        Object object = this.done;
        synchronized (object) {
            this.listening = false;
        }
        this.cancelIO();
        try {
            this.thread.interrupt();
            this.thread.join();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.hangup();
        this.pool.flush();
        super.close();
    }

    protected void hangup() {
        if (this.socket != null) {
            try {
                this.in.close();
                if (this.out != null) {
                    this.out.close();
                }
                this.socket.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            this.in = null;
            this.socket = null;
        }
    }

    protected boolean isDirty() {
        return false;
    }
}

