/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.io.IOException;
import java.net.ServerSocket;
import java.net.Socket;
import org.garret.perst.IFile;
import org.garret.perst.StorageError;
import org.garret.perst.impl.ReplicationSlaveStorageImpl;

public class ReplicationStaticSlaveStorageImpl
extends ReplicationSlaveStorageImpl {
    protected ServerSocket acceptor;
    protected int port;

    public ReplicationStaticSlaveStorageImpl(int port) {
        this.port = port;
    }

    public void open(IFile file, int pagePoolSize) {
        try {
            this.acceptor = new ServerSocket(this.port);
        }
        catch (IOException x) {
            throw new StorageError(28);
        }
        byte[] rootPage = new byte[4096];
        int rc = file.read(0L, rootPage);
        if (rc == 4096) {
            this.prevIndex = rootPage[0];
            this.initialized = rootPage[2] != 0;
        } else {
            this.initialized = false;
            this.prevIndex = -1;
        }
        this.outOfSync = false;
        super.open(file, pagePoolSize);
    }

    Socket getSocket() throws IOException {
        return this.acceptor.accept();
    }

    void cancelIO() {
        try {
            Socket s = new Socket("localhost", this.port);
            s.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

