/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import org.garret.perst.IPersistent;
import org.garret.perst.impl.OidHashTable;

public class StrongHashTable
implements OidHashTable {
    Entry[] table;
    static final float loadFactor = 0.75f;
    int count;
    int threshold;
    boolean flushing;
    static final int MODIFIED_BUFFER_SIZE = 1024;
    IPersistent[] modified;
    int nModified;

    public StrongHashTable(int initialCapacity) {
        this.threshold = (int)((float)initialCapacity * 0.75f);
        if (initialCapacity != 0) {
            this.table = new Entry[initialCapacity];
        }
        this.modified = new IPersistent[1024];
    }

    public synchronized boolean remove(int oid) {
        Entry[] tab = this.table;
        int index = (oid & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        Entry prev = null;
        while (e != null) {
            if (e.oid == oid) {
                e.obj = null;
                --this.count;
                if (prev != null) {
                    prev.next = e.next;
                } else {
                    tab[index] = e.next;
                }
                return true;
            }
            prev = e;
            e = e.next;
        }
        return false;
    }

    public synchronized void put(int oid, IPersistent obj) {
        Entry[] tab = this.table;
        int index = (oid & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.oid == oid) {
                e.obj = obj;
                return;
            }
            e = e.next;
        }
        if (this.count >= this.threshold && !this.flushing) {
            this.rehash();
            tab = this.table;
            index = (oid & Integer.MAX_VALUE) % tab.length;
        }
        tab[index] = new Entry(oid, obj, tab[index]);
        ++this.count;
    }

    public synchronized IPersistent get(int oid) {
        Entry[] tab = this.table;
        int index = (oid & Integer.MAX_VALUE) % tab.length;
        Entry e = tab[index];
        while (e != null) {
            if (e.oid == oid) {
                return e.obj;
            }
            e = e.next;
        }
        return null;
    }

    void rehash() {
        int oldCapacity = this.table.length;
        Entry[] oldMap = this.table;
        int newCapacity = oldCapacity * 2 + 1;
        Entry[] newMap = new Entry[newCapacity];
        this.threshold = (int)((float)newCapacity * 0.75f);
        this.table = newMap;
        int i = oldCapacity;
        while (--i >= 0) {
            Entry old = oldMap[i];
            while (old != null) {
                Entry e = old;
                old = old.next;
                int index = (e.oid & Integer.MAX_VALUE) % newCapacity;
                e.next = newMap[index];
                newMap[index] = e;
            }
        }
    }

    public synchronized void flush() {
        if (this.nModified < 1024) {
            IPersistent[] mod = this.modified;
            int i = this.nModified;
            while (--i >= 0) {
                IPersistent obj = mod[i];
                if (!obj.isModified()) continue;
                obj.store();
            }
        } else {
            Entry[] tab = this.table;
            this.flushing = true;
            for (int i = 0; i < tab.length; ++i) {
                Entry e = tab[i];
                while (e != null) {
                    if (e.obj.isModified()) {
                        e.obj.store();
                    }
                    e = e.next;
                }
            }
            this.flushing = false;
            if (this.count >= this.threshold) {
                this.rehash();
            }
        }
        this.nModified = 0;
    }

    public synchronized void clear() {
        Entry[] tab = this.table;
        for (int i = 0; i < tab.length; ++i) {
            tab[i] = null;
        }
        this.count = 0;
        this.nModified = 0;
    }

    public synchronized void invalidate() {
        for (int i = 0; i < this.table.length; ++i) {
            Entry e = this.table[i];
            while (e != null) {
                if (e.obj.isModified()) {
                    e.obj.invalidate();
                }
                e = e.next;
            }
            this.table[i] = null;
        }
        this.count = 0;
        this.nModified = 0;
    }

    public synchronized void setDirty(IPersistent obj) {
        if (this.nModified < 1024) {
            this.modified[this.nModified++] = obj;
        }
    }

    public void clearDirty(IPersistent obj) {
    }

    public int size() {
        return this.count;
    }

    public void preprocess() {
    }

    static class Entry {
        Entry next;
        IPersistent obj;
        int oid;

        Entry(int oid, IPersistent obj, Entry chain) {
            this.next = chain;
            this.oid = oid;
            this.obj = obj;
        }
    }
}

