/*
 * Decompiled with CFR 0.152.
 */
package org.garret.perst.impl;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.garret.perst.IPersistent;
import org.garret.perst.IterableIterator;
import org.garret.perst.PersistentCollection;
import org.garret.perst.PersistentComparator;
import org.garret.perst.PersistentIterator;
import org.garret.perst.SortedCollection;
import org.garret.perst.StorageError;
import org.garret.perst.impl.TtreePage;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ttree<T extends IPersistent>
extends PersistentCollection<T>
implements SortedCollection<T> {
    private PersistentComparator<T> comparator;
    private boolean unique;
    private TtreePage root;
    private int nMembers;
    static final IPersistent[] emptySelection = new IPersistent[0];

    private Ttree() {
    }

    Ttree(PersistentComparator<T> comparator, boolean unique) {
        this.comparator = comparator;
        this.unique = unique;
    }

    @Override
    public PersistentComparator<T> getComparator() {
        return this.comparator;
    }

    @Override
    public boolean recursiveLoading() {
        return false;
    }

    @Override
    public T get(Object key) {
        if (this.root != null) {
            ArrayList list = new ArrayList();
            this.root.find(this.comparator, key, 1, key, 1, list);
            if (list.size() > 1) {
                throw new StorageError(4);
            }
            if (list.size() == 0) {
                return null;
            }
            return (T)((IPersistent)list.get(0));
        }
        return null;
    }

    @Override
    public ArrayList<T> getList(Object from, Object till) {
        ArrayList list = new ArrayList();
        if (this.root != null) {
            this.root.find(this.comparator, from, 1, till, 1, list);
        }
        return list;
    }

    @Override
    public ArrayList<T> getList(Object from, boolean fromInclusive, Object till, boolean tillInclusive) {
        ArrayList list = new ArrayList();
        if (this.root != null) {
            this.root.find(this.comparator, from, fromInclusive ? 1 : 0, till, tillInclusive ? 1 : 0, list);
        }
        return list;
    }

    @Override
    public IPersistent[] get(Object from, Object till) {
        ArrayList<IPersistent> list = this.getList(from, till);
        return list.toArray(new IPersistent[list.size()]);
    }

    @Override
    public IPersistent[] get(Object from, boolean fromInclusive, Object till, boolean tillInclusive) {
        ArrayList<IPersistent> list = this.getList(from, fromInclusive, till, tillInclusive);
        return list.toArray(new IPersistent[list.size()]);
    }

    @Override
    public boolean add(T obj) {
        TtreePage newRoot;
        if (this.root == null) {
            newRoot = new TtreePage((IPersistent)obj);
        } else {
            TtreePage.PageReference ref = new TtreePage.PageReference(this.root);
            if (this.root.insert(this.comparator, (IPersistent)obj, this.unique, ref) == 1) {
                return false;
            }
            newRoot = ref.pg;
        }
        this.root = newRoot;
        ++this.nMembers;
        this.modify();
        return true;
    }

    @Override
    public boolean containsObject(T member) {
        return this.root != null && member != null ? this.root.containsObject(this.comparator, (IPersistent)member) : false;
    }

    @Override
    public boolean contains(T member) {
        return this.root != null && member != null ? this.root.contains(this.comparator, (IPersistent)member) : false;
    }

    @Override
    public void remove(T obj) {
        if (this.root == null) {
            throw new StorageError(5);
        }
        TtreePage.PageReference ref = new TtreePage.PageReference(this.root);
        if (this.root.remove(this.comparator, (IPersistent)obj, ref) == 2) {
            throw new StorageError(5);
        }
        this.root = ref.pg;
        --this.nMembers;
        this.modify();
    }

    @Override
    public int size() {
        return this.nMembers;
    }

    @Override
    public void clear() {
        if (this.root != null) {
            this.root.prune();
            this.root = null;
            this.nMembers = 0;
            this.modify();
        }
    }

    @Override
    public void deallocate() {
        if (this.root != null) {
            this.root.prune();
        }
        super.deallocate();
    }

    @Override
    public IPersistent[] toPersistentArray() {
        if (this.root == null) {
            return emptySelection;
        }
        IPersistent[] arr = new IPersistent[this.nMembers];
        this.root.toArray(arr, 0);
        return arr;
    }

    @Override
    public Object[] toArray() {
        return this.toPersistentArray();
    }

    @Override
    public <E> E[] toArray(E[] arr) {
        if (arr.length < this.nMembers) {
            arr = (Object[])Array.newInstance(arr.getClass().getComponentType(), this.nMembers);
        }
        if (this.root != null) {
            this.root.toArray((IPersistent[])arr, 0);
        }
        if (arr.length > this.nMembers) {
            arr[this.nMembers] = null;
        }
        return arr;
    }

    @Override
    public Iterator<T> iterator() {
        return this.iterator(null, null);
    }

    @Override
    public IterableIterator<T> iterator(Object from, Object till) {
        return this.iterator(from, true, till, true);
    }

    @Override
    public IterableIterator<T> iterator(Object from, boolean fromInclusive, Object till, boolean tillInclusive) {
        ArrayList list = new ArrayList();
        if (this.root != null) {
            this.root.find(this.comparator, from, fromInclusive ? 1 : 0, till, tillInclusive ? 1 : 0, list);
        }
        return new TtreeIterator(this, list);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class TtreeIterator<T extends IPersistent>
    extends IterableIterator<T>
    implements PersistentIterator {
        int i;
        ArrayList list;
        boolean removed;
        Ttree tree;

        TtreeIterator(Ttree tree, ArrayList list) {
            this.tree = tree;
            this.list = list;
            this.i = -1;
        }

        @Override
        public T next() {
            if (this.i + 1 >= this.list.size()) {
                throw new NoSuchElementException();
            }
            this.removed = false;
            return (T)((IPersistent)this.list.get(++this.i));
        }

        @Override
        public int nextOid() {
            return this.next().getOid();
        }

        @Override
        public void remove() {
            if (this.removed || this.i < 0 || this.i >= this.list.size()) {
                throw new IllegalStateException();
            }
            this.tree.remove((IPersistent)this.list.get(this.i));
            this.list.remove(this.i--);
            this.removed = true;
        }

        @Override
        public boolean hasNext() {
            return this.i + 1 < this.list.size();
        }
    }
}

