/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.DCPButton;
import ftjava.std.GameEngine;
import ftjava.std.Ship;
import ftjava.std.ShipSystem;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class DamageControlDialog {
    private Ship ship;
    private ArrayList taskList;
    private JDialog dialog = new JDialog();

    DamageControlDialog(GameEngine engine, Ship inship, boolean reset) {
        this.dialog.setTitle(inship.getName() + " Damage Control");
        this.dialog.setModal(false);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        int screenHeight = d.height;
        int screenWidth = d.width;
        this.dialog.setLocation(screenWidth / 4, screenHeight / 2);
        this.ship = inship;
        this.taskList = new ArrayList();
        ArrayList repairList = this.ship.getRepairList();
        int numberOfDCP = this.ship.getHull().getRemainingDamageControl();
        JPanel table = new JPanel();
        table.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.dialog.getContentPane().add((Component)table, "Center");
        int left = 17;
        int center = 10;
        c.weightx = 1.0;
        c.gridx = 0;
        c.gridy = 0;
        c.anchor = left;
        table.add((Component)new JLabel(""), c);
        c.weightx = 0.0;
        c.anchor = center;
        for (int i = 0; i < numberOfDCP; ++i) {
            ++c.gridx;
            int teamID = i + 1;
            table.add(new JLabel("  Team " + teamID + "  "));
        }
        if (repairList.size() == 0) {
            c.weightx = 1.0;
            ++c.gridy;
            c.gridx = 0;
            c.anchor = left;
            table.add((Component)new JLabel("  All systems operational"), c);
            ++c.gridy;
            table.add((Component)new JLabel("  "), c);
        } else {
            ArrayList ids = this.ship.getDamageControlIds();
            int allocated = ids.size();
            c.weightx = 1.0;
            c.gridx = 0;
            c.anchor = left;
            for (int j = 0; j < repairList.size(); ++j) {
                ShipSystem ss = (ShipSystem)repairList.get(j);
                ++c.gridy;
                table.add((Component)new JLabel("  " + ss.getSystemName()), c);
            }
            ++c.gridy;
            table.add((Component)new JLabel("  "), c);
            for (int i = 0; i < numberOfDCP; ++i) {
                int preset = -1;
                if (i < allocated) {
                    preset = (Integer)ids.get(i);
                }
                c.weightx = 0.0;
                ++c.gridx;
                c.gridy = 0;
                c.anchor = center;
                ButtonGroup bg = new ButtonGroup();
                for (int j = 0; j < repairList.size(); ++j) {
                    ShipSystem ss = (ShipSystem)repairList.get(j);
                    DCPButton radiobutton = new DCPButton(ss);
                    radiobutton.addActionListener(new ActionListener(){

                        public void actionPerformed(ActionEvent e) {
                            DamageControlDialog.this.checkForThree();
                        }
                    });
                    this.taskList.add(radiobutton);
                    bg.add(radiobutton);
                    if (!reset && preset == ss.getId()) {
                        bg.setSelected(radiobutton.getModel(), true);
                    } else {
                        bg.setSelected(radiobutton.getModel(), false);
                    }
                    ++c.gridy;
                    table.add((Component)radiobutton, c);
                }
            }
            if (!reset) {
                this.checkForThree();
            }
        }
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0));
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DamageControlDialog.this.OKPressed();
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DamageControlDialog.this.CancelPressed();
            }
        });
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        this.dialog.getRootPane().setDefaultButton(ok);
        this.dialog.getContentPane().add((Component)buttonPanel, "South");
        this.dialog.pack();
        this.dialog.setVisible(false);
    }

    public JDialog getDialog() {
        return this.dialog;
    }

    public void CancelPressed() {
        this.dialog.setVisible(false);
        this.ship.setDamageControlIds(new ArrayList());
    }

    public void OKPressed() {
        this.dialog.setVisible(false);
        ArrayList<Integer> ids = new ArrayList<Integer>();
        for (int i = 0; i < this.taskList.size(); ++i) {
            DCPButton db = (DCPButton)this.taskList.get(i);
            if (!db.isSelected()) continue;
            Integer m = new Integer(db.getId());
            ids.add(m);
        }
        this.ship.setDamageControlIds(ids);
    }

    public void checkForThree() {
        DCPButton db;
        int i;
        int listSize = this.ship.getRepairList().size();
        int[] count = new int[listSize];
        for (i = 0; i < this.taskList.size(); ++i) {
            db = (DCPButton)this.taskList.get(i);
            if (!db.isSelected()) continue;
            int n = i % listSize;
            count[n] = count[n] + 1;
        }
        for (i = 0; i < this.taskList.size(); ++i) {
            db = (DCPButton)this.taskList.get(i);
            if (!db.isSelected() && count[i % listSize] >= 3) {
                db.setEnabled(false);
                continue;
            }
            db.setEnabled(true);
        }
    }
}

