/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.ClientProgram;
import ftjava.gui.GUIAdapter;
import ftjava.gui.MapPanel;
import ftjava.gui.SpaceObjectGUIAdapter;
import ftjava.gui.StarMap;
import ftjava.gui.StatusDisplay;
import ftjava.gui.TextSpaceObjectLog;
import ftjava.std.AntiMatterTorpedo;
import ftjava.std.FighterGroup;
import ftjava.std.FighterOrders;
import ftjava.std.GameEngine;
import ftjava.std.Missile;
import ftjava.std.MissileSalvo;
import ftjava.std.PlasmaBolt;
import ftjava.std.Player;
import ftjava.std.Ship;
import ftjava.std.SpaceObject;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.util.ArrayList;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;

public class FighterStatusDisplay
extends StatusDisplay {
    private static final long serialVersionUID = 1L;
    private ClientProgram client;
    private FighterGroup fighter;
    private GameEngine engine;
    private Player activePlayer;
    private TextSpaceObjectLog textLog;
    private JLabel StatusLabel;
    private JLabel ActionLabel;
    private JLabel PositionLabel;
    private JLabel MessageLabel = new JLabel(" ");
    private JComboBox OrdersBox = new JComboBox();
    private JComboBox TargetBox = new JComboBox();
    private JButton moveButton = new JButton();
    private JButton resetButton = new JButton();
    private JCheckBox SecMoveBox = new JCheckBox();
    private final int DEFAULT = 0;
    private final int FRIENDLYSHIPS = 1;
    private final int CARRIERSHIPS = 2;
    private final int ENEMYSHIPS = 3;
    private final int ENEMYFIGHTERS = 4;
    private int tableChoice = 0;
    private int tableIndex = -1;
    private DecimalFormat format;
    private SpaceObjectGUIAdapter adapter;
    private final FighterStatusDisplay thisPanel = this;
    private DefaultComboBoxModel emptyModel;
    private DefaultComboBoxModel enemyShips;
    private DefaultComboBoxModel friendlyShips;
    private DefaultComboBoxModel enemyFighters;
    private DefaultComboBoxModel carrierShips;
    private DefaultComboBoxModel rangedWeapons;

    public FighterStatusDisplay(ClientProgram inClient, GameEngine inEngine, SpaceObjectGUIAdapter inAdapter) {
        Player p;
        String className = "";
        boolean ActivePlayerView = false;
        boolean GameMaster2 = false;
        this.client = inClient;
        this.engine = inEngine;
        this.adapter = inAdapter;
        this.fighter = (FighterGroup)this.adapter.getSpaceObject();
        this.format = new DecimalFormat(".0");
        this.activePlayer = p = this.engine.getActivePlayer();
        if (p == null) {
            GameMaster2 = true;
        }
        if (this.fighter.getPlayer() == p) {
            ActivePlayerView = true;
        }
        this.emptyModel = new DefaultComboBoxModel();
        this.enemyShips = this.getEnemyShipList();
        this.friendlyShips = this.getFriendlyShipList();
        this.enemyFighters = this.getEnemyFighterList();
        this.carrierShips = this.getCarrierList();
        this.rangedWeapons = this.getRangedWeaponsList();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 6, 0, 6);
        c.gridy = 0;
        c.gridx = 0;
        c.fill = 2;
        c.anchor = 17;
        c.ipadx = 2;
        c.ipady = 2;
        this.add((Component)new JLabel("Name:       "), c);
        ++c.gridx;
        c.gridwidth = 3;
        String labelTitle = " ";
        labelTitle = labelTitle.indexOf("Bogey") != -1 ? labelTitle + this.fighter.getName() : this.fighter.getName();
        this.add((Component)new JLabel(labelTitle), c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Team:       "), c);
        ++c.gridx;
        this.add((Component)new JLabel(this.fighter.getTeam()), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Class:      "), c);
        ++c.gridx;
        c.gridwidth = 3;
        className = className + this.fighter.getRace() + " " + this.fighter.getType() + " Fighter Group";
        this.add((Component)new JLabel(className), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Status:     "), c);
        ++c.gridx;
        this.StatusLabel = new JLabel(this.fighter.getStatus());
        this.add((Component)this.StatusLabel, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Action:     "), c);
        ++c.gridx;
        c.gridwidth = 3;
        this.ActionLabel = new JLabel(this.fighter.getAction());
        this.add((Component)this.ActionLabel, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.add((Component)new JLabel("     "), c);
        this.add((Component)new JLabel("Player:     "), c);
        ++c.gridx;
        String playerName = "";
        if (this.fighter.getPlayer() != null) {
            playerName = this.fighter.getPlayer().getName();
        }
        this.add((Component)new JLabel(playerName), c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("     "), c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Position:         "), c);
        ++c.gridx;
        this.PositionLabel = new JLabel();
        this.add((Component)this.PositionLabel, c);
        ++c.gridx;
        this.add((Component)new JLabel("Speed:               "), c);
        ++c.gridx;
        this.add((Component)new JLabel("" + this.fighter.getSpeed()), c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Quality:          "), c);
        ++c.gridx;
        this.add((Component)new JLabel(this.fighter.getPilotQuality()), c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Count:      "), c);
        ++c.gridx;
        this.add((Component)new JLabel("" + this.fighter.getCount()), c);
        ++c.gridx;
        this.add((Component)new JLabel("Endurance:           "), c);
        ++c.gridx;
        this.add((Component)new JLabel("" + this.fighter.getCombatEndurance()), c);
        this.updateData();
        if (!GameMaster2 && !ActivePlayerView) {
            c.gridx = 0;
            ++c.gridy;
            this.add((Component)new JLabel("     "), c);
            c.gridx = 0;
            ++c.gridy;
            this.add((Component)new JLabel("     "), c);
            return;
        }
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("     "), c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Orders:      "), c);
        ArrayList ordersList = FighterGroup.orderChoices;
        DefaultComboBoxModel<FighterOrders> dcbm = new DefaultComboBoxModel<FighterOrders>();
        int currentOrdersIndex = -1;
        for (int i = 0; i < ordersList.size(); ++i) {
            FighterOrders currentOrders = (FighterOrders)ordersList.get(i);
            if (this.fighter.getFighterOrders() == currentOrders) {
                currentOrdersIndex = i;
            }
            dcbm.addElement(currentOrders);
        }
        this.OrdersBox = new JComboBox(dcbm);
        if (currentOrdersIndex != -1) {
            this.OrdersBox.setSelectedIndex(currentOrdersIndex);
        }
        this.OrdersBox.addActionListener(new UpdateOrdersAction());
        ++c.gridx;
        this.add((Component)this.OrdersBox, c);
        ++c.gridx;
        this.TargetBox = new JComboBox();
        this.initializeTargets();
        c.gridwidth = 2;
        this.add((Component)this.TargetBox, c);
        c.gridwidth = 1;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Secondary Movement:"), c);
        this.SecMoveBox = new JCheckBox();
        ++c.gridx;
        this.add((Component)this.SecMoveBox, c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("   "), c);
        c.gridx = 0;
        ++c.gridy;
        this.moveButton = new JButton("Move to Mark");
        MoveFighterAction mAct = new MoveFighterAction(this.engine, this.fighter, this);
        mAct.setMessageLabel(this.MessageLabel);
        this.moveButton.addActionListener(mAct);
        this.add((Component)this.moveButton, c);
        ++c.gridx;
        this.resetButton = new JButton("Reset");
        ResetFighterAction rAct = new ResetFighterAction(this.engine, this.fighter, this);
        rAct.setMessageLabel(this.MessageLabel);
        this.resetButton.addActionListener(rAct);
        this.add((Component)this.resetButton, c);
        ++c.gridx;
        this.add((Component)this.MessageLabel, c);
        c.gridx = 0;
        ++c.gridy;
        JButton logButton = new JButton("Fighter Log");
        this.add((Component)logButton, c);
        logButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                FighterStatusDisplay.this.fighterLog();
                FighterStatusDisplay.this.thisPanel.getParent().requestFocus();
            }
        });
        this.validateOrdersGUI();
    }

    private void validateOrdersGUI() {
        boolean disableOrdersBoxes;
        this.OrdersBox.setEnabled(true);
        this.TargetBox.setEnabled(true);
        this.SecMoveBox.setEnabled(true);
        this.moveButton.setEnabled(true);
        this.resetButton.setEnabled(true);
        this.SecMoveBox.setEnabled(true);
        boolean combatPhase = this.engine.isCombatPhase();
        boolean zeroFighterCount = this.fighter.getCount() == 0;
        boolean zeroEndurance = this.fighter.getCombatEndurance() == 0;
        boolean isFighterOnBoard = this.fighter.isOnBoard();
        boolean isFighterLaunching = false;
        boolean bl = disableOrdersBoxes = combatPhase || zeroFighterCount || isFighterLaunching || isFighterOnBoard;
        if (disableOrdersBoxes) {
            this.OrdersBox.setEnabled(false);
            this.SecMoveBox.setEnabled(false);
            this.moveButton.setEnabled(false);
            this.resetButton.setEnabled(false);
        }
        if (zeroEndurance) {
            this.SecMoveBox.setEnabled(false);
        }
    }

    public GUIAdapter getAdapter() {
        return this.adapter;
    }

    public boolean canUseSecondaryMovement() {
        return this.SecMoveBox.isSelected();
    }

    public void updateData() {
        String posText = "";
        posText = posText + "( " + this.format.format(this.fighter.getXPosition());
        posText = posText + ", " + this.format.format(this.fighter.getYPosition()) + ") ";
        this.PositionLabel.setText(posText);
        int selected = this.OrdersBox.getSelectedIndex();
        int pastChoice = this.tableChoice;
        int pastIndex = this.TargetBox.getSelectedIndex();
        FighterOrders fighterOrders = (FighterOrders)this.OrdersBox.getSelectedItem();
        switch (selected) {
            case 2: {
                this.TargetBox.setModel(this.friendlyShips);
                this.tableChoice = 1;
                this.tableIndex = 0;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                this.TargetBox.setModel(this.enemyShips);
                this.tableChoice = 3;
                this.tableIndex = 0;
                break;
            }
            case 6: {
                this.TargetBox.setModel(this.enemyFighters);
                this.tableChoice = 4;
                this.tableIndex = 0;
                break;
            }
            case 8: 
            case 9: {
                this.TargetBox.setModel(this.carrierShips);
                this.tableChoice = 2;
                this.tableIndex = 0;
                break;
            }
            case 7: {
                this.TargetBox.setModel(this.rangedWeapons);
                this.tableChoice = 0;
                this.tableIndex = -1;
                break;
            }
            default: {
                this.TargetBox.setModel(this.emptyModel);
                this.tableChoice = 0;
                this.tableIndex = -1;
            }
        }
        if (this.tableChoice == pastChoice && this.tableIndex == 0) {
            this.tableIndex = pastIndex;
            this.TargetBox.setSelectedIndex(this.tableIndex);
        }
        if (this.SecMoveBox.isEnabled() && !this.engine.isCombatPhase()) {
            switch (selected) {
                case 0: {
                    break;
                }
                case 1: {
                    this.SecMoveBox.setSelected(true);
                    break;
                }
                case 2: {
                    this.SecMoveBox.setSelected(false);
                    break;
                }
                case 3: {
                    break;
                }
                case 4: {
                    this.SecMoveBox.setSelected(true);
                    break;
                }
                case 5: {
                    this.SecMoveBox.setSelected(false);
                    break;
                }
                case 6: {
                    break;
                }
                case 7: {
                    break;
                }
                case 8: {
                    break;
                }
                case 9: {
                    break;
                }
                default: {
                    this.SecMoveBox.setSelected(false);
                }
            }
        }
        if (fighterOrders != null) {
            Object o = this.TargetBox.getSelectedItem();
            if (o == null) {
                this.fighter.setTarget(null);
                this.fighter.setTargetId(0);
            } else if (o.toString().equals("<None>")) {
                this.fighter.setTarget(null);
                this.fighter.setTargetId(0);
            } else if (o.toString().equals("Any Enemy Ship")) {
                this.fighter.setTarget(null);
                this.fighter.setTargetId(-1);
            } else if (o.toString().equals("Any Enemy Fighter")) {
                this.fighter.setTarget(null);
                this.fighter.setTargetId(-2);
            } else if (o.toString().equals("Any Friendly Ship")) {
                this.fighter.setTarget(null);
                this.fighter.setTargetId(-3);
            } else {
                SpaceObject so = this.engine.getObjectByName(o.toString());
                if (so == null) {
                    this.fighter.setTarget(null);
                    this.fighter.setTargetId(0);
                } else {
                    this.fighter.setTarget(so);
                    this.fighter.setTargetId(so.getId());
                }
            }
            this.fighter.setMayUseSecondaryMove(this.SecMoveBox.isSelected());
            this.fighter.setFighterOrders(fighterOrders);
        }
        this.ActionLabel.setText(this.fighter.getAction());
        this.validateOrdersGUI();
    }

    public String toString() {
        return this.fighter.toString();
    }

    public void fighterLog() {
        if (this.textLog == null) {
            this.textLog = new TextSpaceObjectLog(this.fighter);
        }
        this.textLog.pack();
        this.textLog.setVisible(true);
    }

    private DefaultComboBoxModel getEnemyShipList() {
        DefaultComboBoxModel<String> result = new DefaultComboBoxModel<String>();
        ArrayList allShips = this.engine.getShips();
        if (!this.engine.isCombatPhase()) {
            result.addElement("Any Enemy Ship");
        }
        if (this.activePlayer != null) {
            for (int i = 0; i < allShips.size(); ++i) {
                Ship s = (Ship)allShips.get(i);
                String name = s.getClassAbbrev() + " " + s.getName();
                if (s.isDestroyed() || s.hasJumped() || !s.hasArrived() || this.activePlayer.getTeam().equals(s.getPlayer().getTeam()) || this.engine.isCombatPhase() && !name.equals(this.getTargetName())) continue;
                result.addElement(name);
            }
        }
        if (result.getSize() == 1 && !this.engine.isCombatPhase()) {
            result = new DefaultComboBoxModel();
            result.addElement("<None>");
        } else if (this.engine.isCombatPhase()) {
            result.addElement("<None>");
        }
        return result;
    }

    private DefaultComboBoxModel getFriendlyShipList() {
        DefaultComboBoxModel<String> result = new DefaultComboBoxModel<String>();
        ArrayList allShips = this.engine.getShips();
        if (!this.engine.isCombatPhase()) {
            result.addElement("Any Friendly Ship");
        }
        if (this.activePlayer != null) {
            for (int i = 0; i < allShips.size(); ++i) {
                Ship s = (Ship)allShips.get(i);
                String name = s.getClassAbbrev() + " " + s.getName();
                if (s.isDestroyed() || s.hasJumped() || !s.hasArrived() || this.engine.isCombatPhase() && !name.equals(this.getTargetName()) || !this.activePlayer.getTeam().equals(s.getPlayer().getTeam())) continue;
                result.addElement(s.getClassAbbrev() + " " + s.getName());
            }
        }
        if (result.getSize() == 1 && !this.engine.isCombatPhase()) {
            result = new DefaultComboBoxModel();
            result.addElement("<None>");
        } else if (this.engine.isCombatPhase()) {
            result.addElement("<None>");
        }
        return result;
    }

    private DefaultComboBoxModel getEnemyFighterList() {
        DefaultComboBoxModel<String> result = new DefaultComboBoxModel<String>();
        ArrayList allObjs = this.engine.getActiveObjects();
        if (!this.engine.isCombatPhase()) {
            result.addElement("Any Enemy Fighter");
        }
        if (this.activePlayer != null) {
            for (int i = 0; i < allObjs.size(); ++i) {
                FighterGroup fg;
                SpaceObject so = (SpaceObject)allObjs.get(i);
                if (!(so instanceof FighterGroup) || (fg = (FighterGroup)so).getCount() == 0 || this.activePlayer.getTeam().equals(so.getPlayer().getTeam()) || this.engine.isCombatPhase() && !so.getName().equals(this.getTargetName())) continue;
                result.addElement(so.getName());
            }
        }
        if (result.getSize() == 1 && !this.engine.isCombatPhase()) {
            result = new DefaultComboBoxModel();
            result.addElement("<None>");
        } else if (this.engine.isCombatPhase()) {
            result.addElement("<None>");
        }
        return result;
    }

    private DefaultComboBoxModel getRangedWeaponsList() {
        DefaultComboBoxModel<String> result = new DefaultComboBoxModel<String>();
        ArrayList allObjs = this.engine.getActiveObjects();
        if (this.activePlayer != null) {
            for (int i = 0; i < allObjs.size(); ++i) {
                SpaceObject so = (SpaceObject)allObjs.get(i);
                if (!(so instanceof PlasmaBolt) && !(so instanceof MissileSalvo) && !(so instanceof Missile) && !(so instanceof AntiMatterTorpedo) || this.activePlayer.getTeam().equals(so.getPlayer().getTeam()) && !(so instanceof PlasmaBolt) || this.engine.isCombatPhase() && this.fighter.rangeTo(so) > this.fighter.getOptions().getFighterRange()) continue;
                result.addElement(so.getName());
            }
        }
        if (result.getSize() == 1 && !this.engine.isCombatPhase()) {
            result = new DefaultComboBoxModel();
            result.addElement("<None>");
        } else if (this.engine.isCombatPhase()) {
            result.addElement("<None>");
        }
        return result;
    }

    private DefaultComboBoxModel getCarrierList() {
        DefaultComboBoxModel<String> result = new DefaultComboBoxModel<String>();
        ArrayList allShips = this.engine.getShips();
        if (this.activePlayer == null) {
            return result;
        }
        for (int i = 0; i < allShips.size(); ++i) {
            Ship s = (Ship)allShips.get(i);
            String name = s.getClassAbbrev() + " " + s.getName();
            if (s.isDestroyed() || s.hasJumped() || !s.hasArrived() || this.engine.isCombatPhase() && this.fighter.rangeTo(s) > this.fighter.getOptions().getFighterRange() && !name.equals(this.getTargetName()) || !this.activePlayer.getTeam().equals(s.getPlayer().getTeam()) || !s.hasFighterBay()) continue;
            result.addElement(s.getClassAbbrev() + " " + s.getName());
        }
        if (result.getSize() == 0 && !this.engine.isCombatPhase()) {
            result = new DefaultComboBoxModel();
            result.addElement("<None>");
        } else if (this.engine.isCombatPhase()) {
            result.addElement("<None>");
        }
        return result;
    }

    private void initializeTargets() {
        SpaceObject so;
        DefaultComboBoxModel currentModel;
        int selected = this.OrdersBox.getSelectedIndex();
        String targetName = this.getTargetName();
        switch (selected) {
            case 2: {
                currentModel = this.friendlyShips;
                this.tableChoice = 1;
                break;
            }
            case 3: 
            case 4: 
            case 5: {
                currentModel = this.enemyShips;
                this.tableChoice = 3;
                break;
            }
            case 6: {
                currentModel = this.enemyFighters;
                this.tableChoice = 4;
                break;
            }
            case 8: 
            case 9: {
                currentModel = this.carrierShips;
                this.tableChoice = 2;
                break;
            }
            case 7: {
                currentModel = this.rangedWeapons;
                this.tableChoice = 0;
                break;
            }
            default: {
                currentModel = this.emptyModel;
                this.tableChoice = 0;
            }
        }
        if (this.engine.isCombatPhase() && (so = this.engine.getObjectById(this.fighter.getTargetId())) instanceof FighterGroup && this.tableChoice != 4) {
            currentModel.addElement(targetName);
        }
        this.TargetBox.setModel(currentModel);
        for (int i = 0; i < currentModel.getSize(); ++i) {
            Object o = currentModel.getElementAt(i);
            if (!o.toString().equals(targetName)) continue;
            this.TargetBox.setSelectedIndex(i);
            this.tableIndex = i;
            break;
        }
    }

    private String getTargetName() {
        SpaceObject so = this.engine.getObjectById(this.fighter.getTargetId());
        if (so == null) {
            return "";
        }
        if (so instanceof Ship) {
            Ship s = (Ship)so;
            return s.getClassAbbrev() + " " + s.getName();
        }
        return so.getName();
    }

    public class ResetFighterAction
    implements ActionListener {
        GameEngine gEngine;
        FighterGroup fGroup;
        JLabel messageLabel;
        FighterStatusDisplay parent;

        ResetFighterAction(GameEngine ge, FighterGroup fg, FighterStatusDisplay fsd) {
            this.gEngine = ge;
            this.fGroup = fg;
            this.parent = fsd;
            this.messageLabel = null;
        }

        public void setMessageLabel(JLabel inLabel) {
            this.messageLabel = inLabel;
        }

        public void publishMessage(String msg) {
            if (this.messageLabel != null) {
                this.messageLabel.setText(msg);
                this.parent.updateData();
            }
        }

        public void actionPerformed(ActionEvent e) {
            StarMap map = FighterStatusDisplay.this.client.getStarMap();
            this.fGroup.resetOriginalPosition();
            this.publishMessage(" ");
            map.repaint();
        }
    }

    public class MoveFighterAction
    implements ActionListener {
        GameEngine gEngine;
        FighterGroup fGroup;
        JLabel messageLabel;
        FighterStatusDisplay parent;

        MoveFighterAction(GameEngine ge, FighterGroup fg, FighterStatusDisplay fsd) {
            this.gEngine = ge;
            this.fGroup = fg;
            this.parent = fsd;
            this.messageLabel = null;
        }

        public void setMessageLabel(JLabel inLabel) {
            this.messageLabel = inLabel;
        }

        public void publishMessage(String msg) {
            if (this.messageLabel != null) {
                this.messageLabel.setText(msg);
                this.parent.updateData();
            }
        }

        public void actionPerformed(ActionEvent e) {
            StarMap map = FighterStatusDisplay.this.client.getStarMap();
            MapPanel mPanel = map.getMapPanel();
            double[] msPos = new double[2];
            if (!mPanel.isMarkDefined()) {
                this.publishMessage("Mark is undefined");
                return;
            }
            FighterOrders fo = this.fGroup.getFighterOrders();
            boolean moveSecMoveMark = fo.toString().equals("Move") || fo.toString().equals("Return Home") || fo.toString().equals("Emergency Landing");
            double[] markPosition = mPanel.getCurrentMark();
            double distance = this.fGroup.getSpeed();
            if (this.parent.canUseSecondaryMovement() && moveSecMoveMark) {
                distance += FighterStatusDisplay.this.engine.getOptions().getFighterSecondaryRange();
            }
            msPos = this.fGroup.rangeBoundsAlongVectorPast(markPosition[0], markPosition[1], distance);
            int direction = this.fGroup.headingPastTo(msPos[0], msPos[1]);
            this.fGroup.setXPosition(msPos[0]);
            this.fGroup.setYPosition(msPos[1]);
            this.fGroup.setHeading(direction);
            this.publishMessage(" ");
            map.repaint();
        }
    }

    public class UpdateOrdersAction
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            FighterStatusDisplay.this.updateData();
        }
    }
}

