/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.std.Message;
import ftjava.std.Player;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextArea;

public class MessageReader
extends JFrame {
    private static final long serialVersionUID = 1L;

    MessageReader(Player player) {
        String sep = System.getProperty("line.separator");
        this.setTitle("Messages");
        this.setSize(500, 400);
        this.setResizable(true);
        this.setDefaultCloseOperation(2);
        Toolkit tk = Toolkit.getDefaultToolkit();
        Dimension d = tk.getScreenSize();
        int screenWidth = d.width;
        int frameWidth = this.getWidth();
        this.setLocation(screenWidth / 2 - frameWidth / 2, 0);
        Container cp = this.getContentPane();
        cp.setLayout(new BorderLayout());
        JPanel south = new JPanel();
        JButton closeBut = new JButton(" Close ");
        closeBut.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ae) {
                MessageReader.this.dispose();
            }
        });
        Box b = Box.createHorizontalBox();
        b.add(Box.createHorizontalGlue());
        b.add(closeBut);
        b.add(Box.createHorizontalGlue());
        south.add(b);
        JTabbedPane center = new JTabbedPane();
        ArrayList messages = player != null ? player.getIncomingMessageLog() : new ArrayList();
        if (messages.size() > 0) {
            for (int i = 0; i < messages.size(); ++i) {
                Message current = (Message)messages.get(i);
                StringBuffer sb = new StringBuffer();
                sb.append(sep);
                sb.append("To:   ");
                sb.append(current.getTo());
                sb.append(sep);
                sb.append("From: ");
                sb.append(current.getFrom());
                sb.append(sep);
                sb.append(sep);
                sb.append(current.getMessage());
                sb.append(sep);
                JTextArea jt = new JTextArea(sb.toString());
                jt.setEditable(false);
                jt.setFont(new Font("Dialog", 0, 12));
                JScrollPane scroller = new JScrollPane(jt);
                int count = i + 1;
                String si = "" + count;
                center.add(si, scroller);
            }
        } else {
            JTextArea jt = new JTextArea(sep + sep + sep + "             No messages");
            jt.setEditable(false);
            jt.setFont(new Font("Dialog", 0, 12));
            JScrollPane scroller = new JScrollPane(jt);
            String si = "0";
            center.add(si, scroller);
        }
        cp.add((Component)center, "Center");
        cp.add((Component)south, "South");
    }
}

