/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.ClientProgram;
import ftjava.gui.GUIAdapter;
import ftjava.gui.MapPanel;
import ftjava.gui.SpaceObjectGUIAdapter;
import ftjava.gui.StarMap;
import ftjava.gui.StatusDisplay;
import ftjava.gui.TextSpaceObjectLog;
import ftjava.std.GameEngine;
import ftjava.std.Missile;
import ftjava.std.Player;
import ftjava.std.Ship;
import ftjava.std.ShipSystem;
import ftjava.std.SpaceObject;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JSlider;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class MissileStatusDisplay
extends StatusDisplay {
    private static final long serialVersionUID = 1L;
    private ClientProgram client;
    private Missile missile;
    private GameEngine engine;
    private Player activePlayer;
    private TextSpaceObjectLog textLog;
    private JLabel StatusLabel;
    private JLabel ActionLabel;
    private JLabel PositionLabel;
    private JLabel MessageLabel = new JLabel(" ");
    private JComboBox TargetBox = new JComboBox();
    private JComboBox needleTargetBox = new JComboBox();
    private JSlider moveSlider;
    private JSlider turnSlider = new JSlider();
    private DecimalFormat format;
    private SpaceObjectGUIAdapter adapter;
    private final MissileStatusDisplay thisPanel = this;
    private DefaultComboBoxModel enemyShips;
    private static Hashtable labelDict = new Hashtable();

    public MissileStatusDisplay(ClientProgram inClient, GameEngine inEngine, SpaceObjectGUIAdapter inAdapter) {
        String className = "";
        boolean ActivePlayerView = false;
        boolean GameMaster2 = false;
        this.client = inClient;
        this.engine = inEngine;
        this.adapter = inAdapter;
        this.missile = (Missile)this.adapter.getSpaceObject();
        this.format = new DecimalFormat(".0");
        Player p = this.engine.getActivePlayer();
        Ship ship = this.engine.getShipById(this.missile.getLaunchingShipId());
        this.activePlayer = p;
        if (p == null) {
            GameMaster2 = true;
        }
        if (this.missile.getPlayer() == p) {
            ActivePlayerView = true;
        }
        this.enemyShips = this.getEnemyShipList();
        this.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        c.insets = new Insets(0, 6, 0, 6);
        c.gridy = 0;
        c.gridx = 0;
        c.fill = 2;
        c.anchor = 17;
        c.ipadx = 2;
        c.ipady = 2;
        this.add((Component)new JLabel("Name:       "), c);
        ++c.gridx;
        c.gridwidth = 3;
        String labelTitle = " ";
        labelTitle = labelTitle.indexOf("Bogey") != -1 ? labelTitle + this.missile.getName() : this.missile.getName();
        this.add((Component)new JLabel(labelTitle), c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Team:       "), c);
        ++c.gridx;
        this.add((Component)new JLabel(this.missile.getTeam()), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Class:      "), c);
        ++c.gridx;
        c.gridwidth = 3;
        className = className + (ship != null ? ship.getRace() : "") + " " + this.missile.getType() + " Missile";
        this.add((Component)new JLabel(className), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Action:     "), c);
        ++c.gridx;
        c.gridwidth = 3;
        this.ActionLabel = new JLabel(this.missile.getAction());
        this.add((Component)this.ActionLabel, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        this.add((Component)new JLabel("Player:     "), c);
        ++c.gridx;
        String playerName = "";
        if (this.missile.getPlayer() != null) {
            playerName = this.missile.getPlayer().getName();
        }
        this.add((Component)new JLabel(playerName), c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("     "), c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Position:         "), c);
        ++c.gridx;
        this.PositionLabel = new JLabel();
        this.add((Component)this.PositionLabel, c);
        ++c.gridx;
        this.add((Component)new JLabel("Endurance:           "), c);
        ++c.gridx;
        this.add((Component)new JLabel("" + this.missile.getEndurance()), c);
        if (!GameMaster2 && !ActivePlayerView) {
            c.gridx = 0;
            ++c.gridy;
            this.add((Component)new JLabel("     "), c);
            c.gridx = 0;
            ++c.gridy;
            this.add((Component)new JLabel("     "), c);
            this.updateData();
            return;
        }
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Movement: "), c);
        ++c.gridx;
        this.moveSlider = new JSlider(0, 0, 18, 0);
        this.moveSlider.setMajorTickSpacing(5);
        this.moveSlider.setMinorTickSpacing(1);
        this.moveSlider.setPaintTicks(true);
        this.moveSlider.setSnapToTicks(true);
        this.moveSlider.setPaintLabels(true);
        MoveMissileChange mAct = new MoveMissileChange(this.engine, this.missile, this);
        mAct.setMessageLabel(this.MessageLabel);
        this.moveSlider.addChangeListener(mAct);
        c.gridwidth = 4;
        this.add((Component)this.moveSlider, c);
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Turning: "), c);
        ++c.gridx;
        this.turnSlider = new JSlider(0, -2, 2, 0);
        this.turnSlider.setMajorTickSpacing(2);
        this.turnSlider.setMinorTickSpacing(1);
        this.turnSlider.setPaintTicks(true);
        this.turnSlider.setSnapToTicks(true);
        this.turnSlider.setPaintLabels(true);
        this.turnSlider.setLabelTable(labelDict);
        this.turnSlider.addChangeListener(mAct);
        c.gridwidth = 4;
        this.add((Component)this.turnSlider, c);
        c.gridwidth = 1;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("Target:     "), c);
        ++c.gridx;
        this.TargetBox = new JComboBox();
        this.initializeTargets();
        c.gridwidth = 2;
        this.add((Component)this.TargetBox, c);
        c.gridwidth = 1;
        c.gridx = 0;
        ++c.gridy;
        this.add((Component)new JLabel("   "), c);
        ++c.gridx;
        this.add((Component)this.MessageLabel, c);
        c.gridx = 0;
        ++c.gridy;
        if (this.showNeedleTargets()) {
            this.add((Component)new JLabel("Target System:"), c);
            this.needleTargetBox.setModel(this.getNeedleTargetList());
            ++c.gridx;
            c.gridwidth = 2;
            this.add((Component)this.needleTargetBox, c);
            c.gridwidth = 1;
        }
        this.validateOrdersGUI();
    }

    private void validateOrdersGUI() {
        boolean disableOrdersBoxes;
        this.TargetBox.setEnabled(true);
        if (this.moveSlider != null && this.turnSlider != null) {
            this.moveSlider.setEnabled(true);
            this.turnSlider.setEnabled(true);
        }
        boolean combatPhase = this.engine.isCombatPhase();
        boolean zeroEndurance = this.missile.getEndurance() == 0;
        boolean bl = disableOrdersBoxes = combatPhase || zeroEndurance;
        if (disableOrdersBoxes) {
            this.TargetBox.setEnabled(false);
            if (this.moveSlider != null && this.turnSlider != null) {
                this.moveSlider.setEnabled(false);
                this.turnSlider.setEnabled(false);
            }
        }
    }

    public GUIAdapter getAdapter() {
        return this.adapter;
    }

    public void updateData() {
        String posText = "";
        posText = posText + "( " + this.format.format(this.missile.getXPosition());
        posText = posText + ", " + this.format.format(this.missile.getYPosition()) + ") ";
        this.PositionLabel.setText(posText);
        Object o = this.TargetBox.getSelectedItem();
        if (o == null) {
            this.missile.setTarget(null);
            this.missile.setTargetId(0);
        } else if (o.toString().equals("<None>")) {
            this.missile.setTarget(null);
            this.missile.setTargetId(0);
        } else if (o.toString().equals("Any Enemy Ship")) {
            this.missile.setTarget(null);
            this.missile.setTargetId(-1);
        } else {
            SpaceObject so = this.engine.getObjectByName(o.toString());
            if (so == null) {
                this.missile.setTarget(null);
                this.missile.setTargetId(0);
            } else {
                this.missile.setTarget(so);
                this.missile.setTargetId(so.getId());
            }
        }
        if (this.showNeedleTargets()) {
            NeedleTargetItem nti = (NeedleTargetItem)this.needleTargetBox.getSelectedItem();
            if (nti.ss == null) {
                this.missile.setNeedleTargetId(0);
            } else {
                this.missile.setNeedleTargetId(nti.ss.getId());
            }
        }
        this.ActionLabel.setText(this.missile.getAction());
        this.validateOrdersGUI();
    }

    public String toString() {
        return this.missile.toString();
    }

    public void missileLog() {
        if (this.textLog == null) {
            this.textLog = new TextSpaceObjectLog(this.missile);
        }
        this.textLog.pack();
        this.textLog.setVisible(true);
    }

    private DefaultComboBoxModel getEnemyShipList() {
        DefaultComboBoxModel<String> result = new DefaultComboBoxModel<String>();
        ArrayList allShips = this.engine.getShips();
        if (!this.engine.isCombatPhase()) {
            result.addElement("Any Enemy Ship");
        }
        if (this.activePlayer != null) {
            for (int i = 0; i < allShips.size(); ++i) {
                Ship s = (Ship)allShips.get(i);
                String name = s.getClassAbbrev() + " " + s.getName();
                if (s.isDestroyed() || s.hasJumped() || !s.hasArrived() || this.activePlayer.getTeam().equals(s.getPlayer().getTeam()) || this.engine.isCombatPhase() && !name.equals(this.getTargetName())) continue;
                result.addElement(name);
            }
        }
        if (result.getSize() == 1 && !this.engine.isCombatPhase()) {
            result = new DefaultComboBoxModel();
            result.addElement("<None>");
        } else if (this.engine.isCombatPhase()) {
            result.addElement("<None>");
        }
        return result;
    }

    private DefaultComboBoxModel getNeedleTargetList() {
        DefaultComboBoxModel<NeedleTargetItem> result = new DefaultComboBoxModel<NeedleTargetItem>();
        Ship s = this.engine.getShipById(this.missile.getTargetId());
        result.addElement(new NeedleTargetItem(null));
        if (this.activePlayer != null && s != null) {
            ShipSystem ss;
            Iterator i = s.getElectronicsSystems().iterator();
            while (i.hasNext()) {
                ss = (ShipSystem)i.next();
                if (ss.isDestroyed() && ss.isExpended()) continue;
                result.addElement(new NeedleTargetItem(ss));
            }
            i = s.getDefenseSystems().iterator();
            while (i.hasNext()) {
                ss = (ShipSystem)i.next();
                if (ss.isDestroyed() && ss.isExpended()) continue;
                result.addElement(new NeedleTargetItem(ss));
            }
            i = s.getWeaponSystems().iterator();
            while (i.hasNext()) {
                ss = (ShipSystem)i.next();
                if (ss.isDestroyed() && ss.isExpended()) continue;
                result.addElement(new NeedleTargetItem(ss));
            }
            if (s.getMainDrive() != null && !(ss = s.getMainDrive()).isDestroyed()) {
                result.addElement(new NeedleTargetItem(ss));
            }
            if (s.getFTLDrive() != null && !(ss = s.getFTLDrive()).isDestroyed()) {
                result.addElement(new NeedleTargetItem(ss));
            }
        }
        return result;
    }

    private void initializeTargets() {
        String targetName = this.getTargetName();
        this.TargetBox.setModel(this.enemyShips);
        for (int i = 0; i < this.enemyShips.getSize(); ++i) {
            Object o = this.enemyShips.getElementAt(i);
            if (!o.toString().equals(targetName)) continue;
            this.TargetBox.setSelectedIndex(i);
            break;
        }
    }

    private String getTargetName() {
        SpaceObject so = this.engine.getObjectById(this.missile.getTargetId());
        if (so == null) {
            return "";
        }
        if (so instanceof Ship) {
            Ship s = (Ship)so;
            return s.getClassAbbrev() + " " + s.getName();
        }
        return so.getName();
    }

    private boolean showNeedleTargets() {
        return this.missile.getType().equals("Needle") && this.missile.getTarget() != null && this.missile.getTarget() instanceof Ship && this.missile.canAttack((Ship)this.missile.getTarget(), this.engine.getOptions().getMissileLockOnRange()) && this.engine.isCombatPhase();
    }

    static {
        labelDict.put(new Integer(-2), new JLabel("P2"));
        labelDict.put(new Integer(-1), new JLabel("P1"));
        labelDict.put(new Integer(0), new JLabel("0"));
        labelDict.put(new Integer(1), new JLabel("S1"));
        labelDict.put(new Integer(2), new JLabel("S2"));
    }

    class NeedleTargetItem {
        ShipSystem ss;

        NeedleTargetItem(ShipSystem theSystem) {
            this.ss = theSystem;
        }

        public String toString() {
            if (this.ss == null) {
                return "<None>";
            }
            return this.ss.getSystemName();
        }
    }

    public class MoveMissileChange
    implements ChangeListener {
        GameEngine gEngine;
        Missile m;
        JLabel messageLabel;
        MissileStatusDisplay parent;

        MoveMissileChange(GameEngine ge, Missile mm, MissileStatusDisplay msd) {
            this.gEngine = ge;
            this.m = mm;
            this.parent = msd;
            this.messageLabel = null;
        }

        public void setMessageLabel(JLabel inLabel) {
            this.messageLabel = inLabel;
        }

        public void publishMessage(String msg) {
            if (this.messageLabel != null) {
                this.messageLabel.setText(msg);
                this.parent.updateData();
            }
        }

        public void stateChanged(ChangeEvent e) {
            StarMap map = MissileStatusDisplay.this.client.getStarMap();
            MapPanel mPanel = map.getMapPanel();
            this.m.setMove(this.parent.moveSlider.getValue());
            this.m.setTurn(this.parent.turnSlider.getValue());
            this.publishMessage(" ");
            map.repaint();
        }
    }
}

