/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.std.MainDrive;
import ftjava.std.Ship;
import ftjava.util.MathUtil;
import ftjava.util.PointContainer;

public class PlotEnvelope {
    public static PointContainer getPlotEnvelopeCinematic(Ship ship) {
        double[] yp;
        double[] xp;
        double x = ship.getXPosition();
        double y = ship.getYPosition();
        int h = ship.getHeading();
        int v = ship.getSpeed();
        int t = 0;
        boolean isAdvanced = false;
        MainDrive md = ship.getMainDrive();
        if (md != null) {
            t = ship.getMainDrive().getCurrentThrust();
            isAdvanced = ship.getMainDrive().getType().equals("Advanced");
        }
        int i = 0;
        switch (t) {
            case 0: {
                xp = new double[3];
                yp = new double[3];
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, 0);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, 0);
                xp[i] = x;
                yp[i++] = y;
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, 0);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, 0);
                break;
            }
            case 1: {
                xp = new double[8];
                yp = new double[8];
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, 1);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, 1);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -1, 0);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -1, 0);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, -1);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, -1);
                xp[i] = x;
                yp[i++] = y;
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, 0);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, 0);
                xp[i] = x;
                yp[i++] = y;
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, -1);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, -1);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 1, 0);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 1, 0);
                break;
            }
            case 2: {
                if (isAdvanced) {
                    xp = new double[12];
                    yp = new double[12];
                } else {
                    xp = new double[10];
                    yp = new double[10];
                }
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, 2);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, 2);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -1, 1);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -1, 1);
                if (isAdvanced) {
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -2, 0);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -2, 0);
                }
                xp[i] = PlotEnvelope.projected_x(x, h, v, -1, -1);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -1, -1);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, -2);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, -2);
                xp[i] = x;
                yp[i++] = y;
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, 0);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, 0);
                xp[i] = x;
                yp[i++] = y;
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, -2);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, -2);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 1, -1);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 1, -1);
                if (isAdvanced) {
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 2, 0);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 2, 0);
                }
                xp[i] = PlotEnvelope.projected_x(x, h, v, 1, 1);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 1, 1);
                break;
            }
            case 3: {
                if (isAdvanced) {
                    xp = new double[16];
                    yp = new double[16];
                } else {
                    xp = new double[10];
                    yp = new double[10];
                }
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, 3);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, 3);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -1, 2);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -1, 2);
                if (isAdvanced) {
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -2, 1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -2, 1);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -3, 0);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -3, 0);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -2, -1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -2, -1);
                }
                xp[i] = PlotEnvelope.projected_x(x, h, v, -1, -2);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -1, -2);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, -3);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, -3);
                xp[i] = x;
                yp[i++] = y;
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, 0);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, 0);
                xp[i] = x;
                yp[i++] = y;
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, -3);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, -3);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 1, -2);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 1, -2);
                if (isAdvanced) {
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 2, -1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 2, -1);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 3, 0);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 3, 0);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 2, 1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 2, 1);
                }
                xp[i] = PlotEnvelope.projected_x(x, h, v, 1, 2);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 1, 2);
                break;
            }
            case 4: {
                if (isAdvanced) {
                    xp = new double[20];
                    yp = new double[20];
                } else {
                    xp = new double[14];
                    yp = new double[14];
                }
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, 4);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, 4);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -1, 3);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -1, 3);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -2, 2);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -2, 2);
                if (isAdvanced) {
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -3, 1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -3, 1);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -4, 0);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -4, 0);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -3, -1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -3, -1);
                }
                xp[i] = PlotEnvelope.projected_x(x, h, v, -2, -2);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -2, -2);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -1, -3);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -1, -3);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, -4);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, -4);
                xp[i] = x;
                yp[i++] = y;
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, 0);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, 0);
                xp[i] = x;
                yp[i++] = y;
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, -4);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, -4);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 1, -3);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 1, -3);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 2, -2);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 2, -2);
                if (isAdvanced) {
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 3, -1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 3, -1);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 4, 0);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 4, 0);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 3, 1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 3, 1);
                }
                xp[i] = PlotEnvelope.projected_x(x, h, v, 2, 2);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 2, 2);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 1, 3);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 1, 3);
                break;
            }
            case 5: {
                if (isAdvanced) {
                    xp = new double[24];
                    yp = new double[24];
                } else {
                    xp = new double[14];
                    yp = new double[14];
                }
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, 5);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, 5);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -1, 4);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -1, 4);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -2, 3);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -2, 3);
                if (isAdvanced) {
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -3, 2);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -3, 2);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -4, 1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -4, 1);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -5, 0);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -5, 0);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -4, -1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -4, -1);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -3, -2);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -3, -2);
                }
                xp[i] = PlotEnvelope.projected_x(x, h, v, -2, -3);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -2, -3);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -1, -4);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -1, -4);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, -5);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, -5);
                xp[i] = x;
                yp[i++] = y;
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, 0);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, 0);
                xp[i] = x;
                yp[i++] = y;
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, -5);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, -5);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 1, -4);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 1, -4);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 2, -3);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 2, -3);
                if (isAdvanced) {
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 3, -2);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 3, -2);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 4, -1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 4, -1);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 5, 0);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 5, 0);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 4, 1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 4, 1);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 3, 2);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 3, 2);
                }
                xp[i] = PlotEnvelope.projected_x(x, h, v, 2, 3);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 2, 3);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 1, 4);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 1, 4);
                break;
            }
            case 6: {
                if (isAdvanced) {
                    xp = new double[28];
                    yp = new double[28];
                } else {
                    xp = new double[18];
                    yp = new double[18];
                }
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, 6);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, 6);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -1, 5);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -1, 5);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -2, 4);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -2, 4);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -3, 3);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -3, 3);
                if (isAdvanced) {
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -4, 2);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -4, 2);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -5, 1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -5, 1);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -6, 0);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -6, 0);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -5, -1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -5, -1);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -4, -2);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -4, -2);
                }
                xp[i] = PlotEnvelope.projected_x(x, h, v, -3, -3);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -3, -3);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -2, -4);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -2, -4);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -1, -5);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -1, -5);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, -6);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, -6);
                xp[i] = x;
                yp[i++] = y;
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, 0);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, 0);
                xp[i] = x;
                yp[i++] = y;
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, -6);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, -6);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 1, -5);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 1, -5);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 2, -4);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 2, -4);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 3, -3);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 3, -3);
                if (isAdvanced) {
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 4, -2);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 4, -2);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 5, -1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 5, -1);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 6, 0);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 6, 0);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 5, 1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 5, 1);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 4, 2);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 4, 2);
                }
                xp[i] = PlotEnvelope.projected_x(x, h, v, 3, 3);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 3, 3);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 2, 4);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 2, 4);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 1, 5);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 1, 5);
                break;
            }
            case 7: {
                if (isAdvanced) {
                    xp = new double[32];
                    yp = new double[32];
                } else {
                    xp = new double[18];
                    yp = new double[18];
                }
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, 7);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, 7);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -1, 6);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -1, 6);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -2, 5);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -2, 5);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -3, 4);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -3, 4);
                if (isAdvanced) {
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -4, 3);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -4, 3);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -5, 2);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -5, 2);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -6, 1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -6, 1);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -7, 0);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -7, 0);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -6, -1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -6, -1);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -5, -2);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -5, -2);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -4, -3);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -4, -3);
                }
                xp[i] = PlotEnvelope.projected_x(x, h, v, -3, -4);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -3, -4);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -2, -5);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -2, -5);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -1, -6);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -1, -6);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, -7);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, -7);
                xp[i] = x;
                yp[i++] = y;
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, 0);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, 0);
                xp[i] = x;
                yp[i++] = y;
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, -7);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, -7);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 1, -6);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 1, -6);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 2, -5);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 2, -5);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 3, -4);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 3, -4);
                if (isAdvanced) {
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 4, -3);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 4, -3);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 5, -2);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 5, -2);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 6, -1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 6, -1);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 7, 0);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 7, 0);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 6, 1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 6, 1);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 5, 2);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 5, 2);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 4, 3);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 4, 3);
                }
                xp[i] = PlotEnvelope.projected_x(x, h, v, 3, 4);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 3, 4);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 2, 5);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 2, 5);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 1, 6);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 1, 6);
                break;
            }
            case 8: {
                if (isAdvanced) {
                    xp = new double[36];
                    yp = new double[36];
                } else {
                    xp = new double[22];
                    yp = new double[22];
                }
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, 8);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, 8);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -1, 7);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -1, 7);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -2, 6);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -2, 6);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -3, 5);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -3, 5);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -4, 4);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -4, 4);
                if (isAdvanced) {
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -5, 3);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -5, 3);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -6, 2);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -6, 2);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -7, 1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -7, 1);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -8, 0);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -8, 0);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -7, -1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -7, -1);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -6, -2);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -6, -2);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, -5, -3);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, -5, -3);
                }
                xp[i] = PlotEnvelope.projected_x(x, h, v, -4, -4);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -4, -4);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -3, -5);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -3, -5);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -2, -6);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -2, -6);
                xp[i] = PlotEnvelope.projected_x(x, h, v, -1, -7);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, -1, -7);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, -8);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, -8);
                xp[i] = x;
                yp[i++] = y;
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, 0);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, 0);
                xp[i] = x;
                yp[i++] = y;
                xp[i] = PlotEnvelope.projected_x(x, h, v, 0, -8);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 0, -8);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 1, -7);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 1, -7);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 2, -6);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 2, -6);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 3, -5);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 3, -5);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 4, -4);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 4, -4);
                if (isAdvanced) {
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 5, -3);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 5, -3);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 6, -2);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 6, -2);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 7, -1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 7, -1);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 8, 0);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 8, 0);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 7, 1);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 7, 1);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 6, 2);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 6, 2);
                    xp[i] = PlotEnvelope.projected_x(x, h, v, 5, 3);
                    yp[i++] = PlotEnvelope.projected_y(y, h, v, 5, 3);
                }
                xp[i] = PlotEnvelope.projected_x(x, h, v, 4, 4);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 4, 4);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 3, 5);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 3, 5);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 2, 6);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 2, 6);
                xp[i] = PlotEnvelope.projected_x(x, h, v, 1, 7);
                yp[i++] = PlotEnvelope.projected_y(y, h, v, 1, 7);
                break;
            }
            default: {
                return null;
            }
        }
        PointContainer pc = new PointContainer();
        pc.x = xp;
        pc.y = yp;
        return pc;
    }

    public static PointContainer getPlotEnvelopeVector(Ship ship) {
        double[] yp;
        double[] xp;
        double x = ship.getXPosition();
        double y = ship.getYPosition();
        int h = ship.getHeading();
        double vx = ship.getXVelocity();
        double vy = ship.getYVelocity();
        int t = 0;
        int dt = 0;
        boolean isAdvanced = false;
        MainDrive md = ship.getMainDrive();
        if (md != null) {
            t = ship.getMainDrive().getCurrentThrust();
            dt = t - 1;
            isAdvanced = ship.getMainDrive().getType().equals("Advanced");
        }
        if (isAdvanced) {
            dt = t;
        }
        if (dt < 0) {
            dt = 0;
        }
        int i = 0;
        if (t == 0) {
            xp = new double[3];
            yp = new double[3];
            xp[i] = x + vx;
            yp[i++] = y + vy;
            xp[i] = x;
            yp[i++] = y;
            xp[i] = x + vx;
            yp[i++] = y + vy;
        } else {
            xp = new double[17];
            yp = new double[17];
            xp[i] = x + vx + (double)t * MathUtil.X(h);
            yp[i++] = y + vy + (double)t * MathUtil.Y(h);
            xp[i] = x + vx + (double)dt * MathUtil.X(h + 1);
            yp[i++] = y + vy + (double)dt * MathUtil.Y(h + 1);
            xp[i] = x + vx + (double)dt * MathUtil.X(h + 2);
            yp[i++] = y + vy + (double)dt * MathUtil.Y(h + 2);
            xp[i] = x + vx + (double)dt * MathUtil.X(h + 3);
            yp[i++] = y + vy + (double)dt * MathUtil.Y(h + 3);
            xp[i] = x + vx + (double)dt * MathUtil.X(h + 4);
            yp[i++] = y + vy + (double)dt * MathUtil.Y(h + 4);
            xp[i] = x + vx + (double)dt * MathUtil.X(h + 5);
            yp[i++] = y + vy + (double)dt * MathUtil.Y(h + 5);
            xp[i] = x + vx + (double)dt * MathUtil.X(h + 6);
            yp[i++] = y + vy + (double)dt * MathUtil.Y(h + 6);
            xp[i] = x;
            yp[i++] = y;
            xp[i] = x + vx + (double)dt * MathUtil.X(h + 6);
            yp[i++] = y + vy + (double)dt * MathUtil.Y(h + 6);
            xp[i] = x + vx;
            yp[i++] = y + vy;
            xp[i] = x + vx + (double)dt * MathUtil.X(h + 6);
            yp[i++] = y + vy + (double)dt * MathUtil.Y(h + 6);
            xp[i] = x + vx + (double)dt * MathUtil.X(h + 7);
            yp[i++] = y + vy + (double)dt * MathUtil.Y(h + 7);
            xp[i] = x + vx + (double)dt * MathUtil.X(h + 8);
            yp[i++] = y + vy + (double)dt * MathUtil.Y(h + 8);
            xp[i] = x + vx + (double)dt * MathUtil.X(h + 9);
            yp[i++] = y + vy + (double)dt * MathUtil.Y(h + 9);
            xp[i] = x + vx + (double)dt * MathUtil.X(h + 10);
            yp[i++] = y + vy + (double)dt * MathUtil.Y(h + 10);
            xp[i] = x + vx + (double)dt * MathUtil.X(h + 11);
            yp[i++] = y + vy + (double)dt * MathUtil.Y(h + 11);
            xp[i] = x + vx + (double)t * MathUtil.X(h + 12);
            yp[i++] = y + vy + (double)t * MathUtil.Y(h + 12);
        }
        PointContainer pc = new PointContainer();
        pc.x = xp;
        pc.y = yp;
        return pc;
    }

    private static double projected_x(double x, int h, int v, int deltaH, int deltaV) {
        double xProjected = 0.0;
        int speed = v + deltaV;
        if (speed < 0) {
            speed = 0;
        }
        double sign = 1.0;
        if (deltaH < 0) {
            sign = -1.0;
        }
        double xfirst = (double)speed / 2.0 * Math.sin(MathUtil.toRadians(((double)h + sign * Math.floor(Math.abs((double)deltaH / 2.0))) * 30.0));
        double xsecond = (double)speed / 2.0 * Math.sin(MathUtil.toRadians((double)(h + deltaH) * 30.0));
        xProjected = x + xfirst + xsecond;
        return xProjected;
    }

    private static double projected_y(double y, int h, int v, int deltaH, int deltaV) {
        double yProjected = 0.0;
        int speed = v + deltaV;
        if (speed < 0) {
            speed = 0;
        }
        double sign = 1.0;
        if (deltaH < 0) {
            sign = -1.0;
        }
        double yfirst = (double)speed / 2.0 * Math.cos(MathUtil.toRadians(((double)h + sign * Math.floor(Math.abs((double)deltaH / 2.0))) * 30.0));
        double ysecond = (double)speed / 2.0 * Math.cos(MathUtil.toRadians((double)(h + deltaH) * 30.0));
        yProjected = y + yfirst + ysecond;
        return yProjected;
    }
}

