/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.Client;
import ftjava.gui.FTJava;
import ftjava.gui.StarMap;
import ftjava.std.GameEngine;
import ftjava.std.importer.ImportGameEngine;
import java.awt.image.BufferedImage;
import java.io.File;
import uk.org.skeet.png.PngEncoder;

public class RenderStarmap {
    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: ftjava.gui.RenderStarmap <Game.xml> <Image.png>");
            System.exit(0);
        }
        ImportGameEngine ie = new ImportGameEngine();
        try {
            GameEngine engine = ie.readGameEngine(new File(args[0]));
            RenderStarmap.execute(null, engine, args[1]);
        }
        catch (Exception e) {
            System.out.println(e);
        }
        System.exit(0);
    }

    public static void execute(Client theClient, GameEngine gEngine, String fileName) {
        FTJava ftj = null;
        if (theClient != null) {
            ftj = (FTJava)theClient.getMainProgram();
        }
        try {
            StarMap map = new StarMap(gEngine, null);
            PngEncoder.encode((BufferedImage)map.renderImage(), (String)fileName);
            if (ftj != null) {
                ftj.writeMessage("Image file, " + fileName + " generated");
            }
        }
        catch (Exception e) {
            System.out.println(e);
        }
    }
}

