/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.ScenarioEditor;
import ftjava.gui.ssd.SSDWidget;
import ftjava.std.Ship;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ScenarioShipEditor {
    JTextField nameField;
    JTextField positionField;
    JTextField headingField;
    JTextField speedField;
    Ship ship = null;
    JDialog dialog;
    ScenarioEditor editor;
    JFrame guiSSD = null;
    private SSDWidget theSSD;

    public void setShip(Ship inship) {
        this.ship = inship;
        this.dialog.setTitle(this.ship.getName());
        this.nameField.setText(this.ship.getName());
        this.positionField.setText(this.ship.getXPosition() + ", " + this.ship.getYPosition());
        this.headingField.setText(Integer.toString(this.ship.getHeading()));
        this.speedField.setText(Integer.toString(this.ship.getSpeed()));
        if (this.guiSSD.isVisible()) {
            this.showSSD();
        }
    }

    public void show() {
        this.dialog.setVisible(true);
    }

    public ScenarioShipEditor(ScenarioEditor ineditor) {
        this.editor = ineditor;
        this.dialog = new JDialog();
        this.guiSSD = new JFrame();
        this.dialog.setTitle("Ship Editor");
        JPanel table = new JPanel();
        table.setLayout(new GridLayout(0, 2));
        this.dialog.getContentPane().add((Component)table, "Center");
        table.add(new JLabel("Name:"));
        this.nameField = new JTextField();
        table.add(this.nameField);
        table.add(new JLabel("Position:"));
        this.positionField = new JTextField();
        table.add(this.positionField);
        table.add(new JLabel("Heading:"));
        this.headingField = new JTextField();
        table.add(this.headingField);
        table.add(new JLabel("Speed:"));
        this.speedField = new JTextField();
        table.add(this.speedField);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(0));
        JButton ssd = new JButton("SSD");
        ssd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScenarioShipEditor.this.showSSD();
            }
        });
        JButton cancel = new JButton("Cancel");
        cancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScenarioShipEditor.this.CancelPressed();
            }
        });
        JButton apply = new JButton("Apply");
        apply.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScenarioShipEditor.this.ApplyPressed();
            }
        });
        JButton ok = new JButton("OK");
        ok.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                ScenarioShipEditor.this.OKPressed();
            }
        });
        buttonPanel.add(ok);
        buttonPanel.add(cancel);
        buttonPanel.add(apply);
        buttonPanel.add(ssd);
        this.dialog.getRootPane().setDefaultButton(ok);
        this.dialog.getContentPane().add((Component)buttonPanel, "South");
        this.dialog.pack();
    }

    public void CancelPressed() {
        this.dialog.setVisible(false);
        this.guiSSD.setVisible(false);
    }

    private boolean isValid() {
        if (this.nameField.getText().equals(this.ship.getName())) {
            return true;
        }
        String uniquename = this.editor.generateUniqueShipName(this.nameField.getText());
        if (uniquename.equals(this.nameField.getText())) {
            return true;
        }
        JOptionPane.showMessageDialog(this.dialog, this.nameField.getText() + " is not a unique ship name in this scenario, please choose a unique name.", "Invalid ship name", 0);
        return false;
    }

    public void ApplyPressed() {
        if (!this.isValid()) {
            return;
        }
        this.ship.setName(this.nameField.getText());
        String s = this.positionField.getText();
        int p = s.indexOf(",");
        this.ship.setXPosition(Float.parseFloat(s.substring(0, p - 1)));
        this.ship.setYPosition(Float.parseFloat(s.substring(p + 1)));
        this.ship.setSpeed(Integer.parseInt(this.speedField.getText()));
        this.ship.setHeading(Integer.parseInt(this.headingField.getText()));
        this.ship.setVectorCourse(this.ship.getHeading());
        this.ship.setVectorSpeed(this.ship.getSpeed());
        this.editor.shipChanged(this.ship);
        this.editor.redraw();
    }

    public void OKPressed() {
        if (this.isValid()) {
            this.ApplyPressed();
            this.dialog.setVisible(false);
            this.guiSSD.setVisible(false);
        }
    }

    protected void showSSD() {
        this.guiSSD.setTitle(this.ship.getName());
        this.guiSSD.getContentPane().removeAll();
        this.guiSSD.getContentPane().add(new SSDWidget(this.ship, true));
        this.guiSSD.pack();
        this.guiSSD.setVisible(true);
    }
}

