/*
 * Decompiled with CFR 0.152.
 */
package ftjava.gui;

import ftjava.gui.GUIAdapter;
import ftjava.gui.StarMap;
import ftjava.gui.util.ImageUtilities;
import ftjava.std.AntiMatterTorpedo;
import ftjava.std.FighterGroup;
import ftjava.std.GameEngine;
import ftjava.std.HeavenlyBody;
import ftjava.std.Missile;
import ftjava.std.MissileSalvo;
import ftjava.std.NovaCannonBolt;
import ftjava.std.PlasmaBolt;
import ftjava.std.SpaceObject;
import ftjava.std.WaveGunBolt;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import javax.swing.JButton;
import javax.swing.JMenu;
import javax.swing.JMenuItem;

public class SpaceObjectGUIAdapter
implements GUIAdapter,
Comparable {
    public static int minimumRank = 0;
    public static int maximumRank = 0;
    public static final int ARCNONE = -1;
    public static final int ARCRANGE = 0;
    public static final int ARCSENSOR = 15;
    public static final int CLEARDISPLAY = 1;
    public static final int LOCKONS = 2;
    public static final int ENVELOPE = 3;
    public static final int SCALE_80 = 0;
    public static final int SCALE_40 = 1;
    public static final int SCALE_20 = 2;
    public static final int SCALE_10 = 3;
    public static final int SCALE_5 = 4;
    public static final int SCALE_2_5 = 5;
    public static final int SCALE_1 = 6;
    public static final int SCALE_0_2 = 7;
    private SpaceObject spaceObject;
    private GameEngine engine;
    private int rank;
    private BufferedImage Icon = null;
    private BufferedImage[] scaledIcons;
    private int arcOption = 0;
    private boolean showCombatRangeBand = false;
    private boolean showMoveRangeBand = false;
    private boolean showSensorRangeBand = false;
    private boolean showLockOns = false;
    private BufferedImage[] cachedImages = new BufferedImage[13];
    private StarMap map = null;

    public SpaceObjectGUIAdapter(GameEngine e, SpaceObject so, int initialRank) {
        this.spaceObject = so;
        this.engine = e;
        this.rank = minimumRank;
        this.Icon = null;
        this.scaledIcons = new BufferedImage[8];
        String BasePath = "Images/ShipIcons/";
        String BodyPath = "Images/Bodies/";
        String Path2 = null;
        String objectRace = null;
        for (int i = 0; i < 13; ++i) {
            this.cachedImages[i] = null;
        }
        JButton b = new JButton();
        String iconPath = so.getIconFamily();
        objectRace = so.getRace();
        if (objectRace != null && objectRace.equals("Kra'Vak")) {
            objectRace = "Kravak";
        }
        if (so instanceof MissileSalvo) {
            if (iconPath != null) {
                Path2 = BasePath + iconPath + "/" + "SM.gif";
                this.Icon = ImageUtilities.getImage(Path2, b);
            }
            if (this.Icon == null) {
                Path2 = BasePath + this.engine.getOptions().getVariant() + "/" + objectRace + "/" + "SM.gif";
                this.Icon = ImageUtilities.getImage(Path2, b);
            }
            if (this.Icon == null) {
                Path2 = BasePath + "Generic/" + objectRace + "/" + "SM.gif";
                this.Icon = ImageUtilities.getImage(Path2, b);
            }
            if (this.Icon == null) {
                Path2 = BasePath + "Generic/SM.gif";
                this.Icon = ImageUtilities.getImage(Path2, b);
            }
        } else if (so instanceof PlasmaBolt || so instanceof WaveGunBolt || so instanceof NovaCannonBolt) {
            if (iconPath != null) {
                Path2 = BasePath + iconPath + "/" + "PB.gif";
                this.Icon = ImageUtilities.getImage(Path2, b);
            }
            if (this.Icon == null) {
                Path2 = BasePath + this.engine.getOptions().getVariant() + "/" + objectRace + "/" + "PB.gif";
                this.Icon = ImageUtilities.getImage(Path2, b);
            }
            if (this.Icon == null) {
                Path2 = BasePath + "Generic/PB.gif";
                this.Icon = ImageUtilities.getImage(Path2, b);
            }
        } else if (so instanceof Missile) {
            if (iconPath != null) {
                Path2 = BasePath + iconPath + "/" + "Missile.gif";
                this.Icon = ImageUtilities.getImage(Path2, b);
            }
            if (this.Icon == null) {
                Path2 = BasePath + this.engine.getOptions().getVariant() + "/" + objectRace + "/" + "Missile.gif";
                this.Icon = ImageUtilities.getImage(Path2, b);
            }
            if (this.Icon == null) {
                Path2 = BasePath + "Generic/Missile.gif";
                this.Icon = ImageUtilities.getImage(Path2, b);
            }
        } else if (so instanceof AntiMatterTorpedo) {
            if (iconPath != null) {
                Path2 = BasePath + iconPath + "/" + "AMT.gif";
                this.Icon = ImageUtilities.getImage(Path2, b);
            }
            if (this.Icon == null) {
                Path2 = BasePath + this.engine.getOptions().getVariant() + "/" + objectRace + "/" + "AMT.gif";
                this.Icon = ImageUtilities.getImage(Path2, b);
            }
            if (this.Icon == null) {
                Path2 = BasePath + "Generic/AMT.gif";
                this.Icon = ImageUtilities.getImage(Path2, b);
            }
        } else if (so instanceof FighterGroup) {
            FighterGroup fg = (FighterGroup)so;
            String prefix = "F";
            if (fg.isAnAttackFighter()) {
                prefix = "A";
            }
            if (fg.isAnInterceptor()) {
                prefix = "I";
            }
            if (fg.isAHeavyFighter()) {
                prefix = "H";
            }
            if (fg.isATorpedoFighter()) {
                prefix = "T";
            }
            if (iconPath != null) {
                Path2 = BasePath + iconPath + "/" + prefix + fg.getCount() + ".gif";
                this.Icon = ImageUtilities.getImage(Path2, b);
            }
            if (this.Icon == null) {
                Path2 = BasePath + this.engine.getOptions().getVariant() + "/" + objectRace + "/" + prefix + fg.getCount() + ".gif";
                this.Icon = ImageUtilities.getImage(Path2, b);
            }
            if (this.Icon == null) {
                Path2 = BasePath + this.engine.getOptions().getVariant() + "/" + objectRace + "/" + "F" + fg.getCount() + ".gif";
                this.Icon = ImageUtilities.getImage(Path2, b);
            }
            if (this.Icon == null) {
                Path2 = BasePath + "Generic/F" + fg.getCount() + ".gif";
                this.Icon = ImageUtilities.getImage(Path2, b);
            }
        } else if (so instanceof HeavenlyBody) {
            Path2 = BodyPath + iconPath + "/" + iconPath + "_80.gif";
            this.scaledIcons[0] = ImageUtilities.getImage(Path2, b);
            Path2 = BodyPath + iconPath + "/" + iconPath + "_40.gif";
            this.scaledIcons[1] = ImageUtilities.getImage(Path2, b);
            Path2 = BodyPath + iconPath + "/" + iconPath + "_20.gif";
            this.scaledIcons[2] = ImageUtilities.getImage(Path2, b);
            Path2 = BodyPath + iconPath + "/" + iconPath + "_10.gif";
            this.scaledIcons[3] = ImageUtilities.getImage(Path2, b);
            Path2 = BodyPath + iconPath + "/" + iconPath + "_5.gif";
            this.scaledIcons[4] = ImageUtilities.getImage(Path2, b);
            Path2 = BodyPath + iconPath + "/" + iconPath + "_2_5.gif";
            this.scaledIcons[5] = ImageUtilities.getImage(Path2, b);
            Path2 = BodyPath + iconPath + "/" + iconPath + "_1.gif";
            this.scaledIcons[6] = ImageUtilities.getImage(Path2, b);
            this.scaledIcons[7] = this.scaledIcons[6];
            this.Icon = this.scaledIcons[3];
        }
        if (this.Icon == null) {
            Path2 = BasePath + "Generic/GenericShipIcon.gif";
            this.Icon = ImageUtilities.getImage(Path2, b);
        }
        if (this.Icon != null) {
            this.Icon.getRGB(0, 0);
        }
    }

    public int getRank() {
        return this.rank;
    }

    public void setRank(int r) {
        this.rank = r;
    }

    public int getId() {
        return this.spaceObject.getId();
    }

    public int getArcOption() {
        return this.arcOption;
    }

    public void setShowArcOption(int arc) {
        this.arcOption = arc;
    }

    public String toString() {
        return this.getSpaceObject().toString();
    }

    public int compareTo(Object o) {
        GUIAdapter s = (GUIAdapter)o;
        return s.getId();
    }

    public boolean getShowRangeBand() {
        return this.showCombatRangeBand;
    }

    public void setShowRangeBand(boolean show) {
        this.showCombatRangeBand = show;
    }

    public void showRangeBand() {
        this.setShowRangeBand(true);
    }

    public void hideRangeBand() {
        this.setShowRangeBand(false);
    }

    public boolean getShowMoveRangeBand() {
        return this.showMoveRangeBand;
    }

    public void setShowMoveRangeBand(boolean show) {
        this.showMoveRangeBand = show;
    }

    public void showMoveRangeBand() {
        this.setShowMoveRangeBand(true);
    }

    public void hideMoveRangeBand() {
        this.setShowMoveRangeBand(false);
    }

    public boolean getShowSensorRangeBand() {
        return this.showSensorRangeBand;
    }

    public void setShowSensorRangeBand(boolean show) {
        this.showSensorRangeBand = show;
    }

    public void showSensorRangeBand() {
        this.setShowSensorRangeBand(true);
    }

    public void hideSensorRangeBand() {
        this.setShowSensorRangeBand(false);
    }

    public boolean getShowLockOns() {
        return this.showLockOns;
    }

    public void setShowLockOns(boolean show) {
        this.showLockOns = show;
    }

    public void showLockOns() {
        this.setShowLockOns(true);
    }

    public void hideLockOns() {
        this.setShowLockOns(false);
    }

    public GameEngine getGameEngine() {
        return this.engine;
    }

    public SpaceObject getSpaceObject() {
        return this.spaceObject;
    }

    public JMenu getMenu() {
        JMenu spaceObjectMenu = new JMenu(this.spaceObject.getName());
        if (this.spaceObject instanceof HeavenlyBody) {
            return spaceObjectMenu;
        }
        JMenuItem item = new JMenuItem("Clear All Information");
        item.addActionListener(new ClearAll());
        spaceObjectMenu.add(item);
        if (this.spaceObject instanceof FighterGroup) {
            item = new JMenuItem("Plot Envelope");
            item.addActionListener(new ToggleEnvelope());
            spaceObjectMenu.add(item);
            item = new JMenuItem("Sensor");
            item.addActionListener(new ToggleSensors());
            spaceObjectMenu.add(item);
        }
        item = new JMenuItem("Range Band");
        item.addActionListener(new ToggleRangeBand());
        spaceObjectMenu.add(item);
        if (!(this.spaceObject instanceof PlasmaBolt)) {
            item = new JMenuItem("Lock Ons");
            item.addActionListener(new ToggleLockOns());
            spaceObjectMenu.add(item);
        }
        return spaceObjectMenu;
    }

    public BufferedImage getImage(int heading, double scale) {
        if (this.spaceObject instanceof HeavenlyBody) {
            BufferedImage bImage = this.getBodyImage(scale);
            if (bImage == null) {
                bImage = this.Icon;
            }
            return bImage;
        }
        double angle = 90.0 - this.getHeadingInDegrees(heading);
        while (heading <= 0) {
            heading += 12;
        }
        while (heading > 12) {
            heading -= 12;
        }
        if (this.cachedImages[heading] != null) {
            return this.cachedImages[heading];
        }
        AffineTransform trans = AffineTransform.getRotateInstance(Math.toRadians(angle), (double)this.Icon.getWidth() / 2.0, (double)this.Icon.getHeight() / 2.0);
        double w = this.Icon.getWidth();
        double wPrime = 0.0;
        double h = this.Icon.getHeight();
        double hPrime = 0.0;
        wPrime = hPrime = Math.sqrt(w * w + h * h);
        trans.preConcatenate(AffineTransform.getTranslateInstance(wPrime / 2.0 - w / 2.0, hPrime / 2.0 - h / 2.0));
        AffineTransformOp op = new AffineTransformOp(trans, 2);
        BufferedImage TranslatedIcon = new BufferedImage((int)wPrime, (int)hPrime, this.Icon.getType());
        this.cachedImages[heading] = op.filter(this.Icon, TranslatedIcon);
        return this.cachedImages[heading];
    }

    private BufferedImage getBodyImage(double scale) {
        if (scale >= 80.0) {
            return this.scaledIcons[0];
        }
        if (scale >= 40.0) {
            return this.scaledIcons[1];
        }
        if (scale >= 20.0) {
            return this.scaledIcons[2];
        }
        if (scale >= 10.0) {
            return this.scaledIcons[3];
        }
        if (scale >= 5.0) {
            return this.scaledIcons[4];
        }
        if (scale >= 2.5) {
            return this.scaledIcons[5];
        }
        if (scale >= 1.0) {
            return this.scaledIcons[6];
        }
        return this.scaledIcons[7];
    }

    public double getHeadingInDegrees() {
        return this.getHeadingInDegrees(this.spaceObject.getHeading());
    }

    public double getHeadingInDegrees(int heading) {
        double a = (double)(3 - heading) * 30.0;
        if (a < 0.0) {
            a += 360.0;
        }
        return a;
    }

    public void clearDisplay() {
        this.arcOption = 0;
        this.hideRangeBand();
        this.hideMoveRangeBand();
        this.hideSensorRangeBand();
        this.hideLockOns();
    }

    public void setStarMap(StarMap m) {
        this.map = m;
    }

    public class ClearAll
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            SpaceObjectGUIAdapter.this.clearDisplay();
        }
    }

    public class ToggleLockOns
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            SpaceObjectGUIAdapter.this.setShowLockOns(!SpaceObjectGUIAdapter.this.getShowLockOns());
        }
    }

    public class ToggleRangeBand
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            SpaceObjectGUIAdapter.this.setShowRangeBand(!SpaceObjectGUIAdapter.this.getShowRangeBand());
        }
    }

    public class ToggleSensors
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            SpaceObjectGUIAdapter.this.setShowSensorRangeBand(!SpaceObjectGUIAdapter.this.getShowSensorRangeBand());
        }
    }

    public class ToggleEnvelope
    implements ActionListener {
        public void actionPerformed(ActionEvent e) {
            SpaceObjectGUIAdapter.this.setShowMoveRangeBand(!SpaceObjectGUIAdapter.this.getShowMoveRangeBand());
        }
    }
}

